/*
 * Decompiled with CFR 0.152.
 */
package com.cleanroommc.javautils.locators;

import com.cleanroommc.javautils.api.JavaInstall;
import com.cleanroommc.javautils.locators.AbstractJavaLocator;
import com.cleanroommc.platformutils.Platform;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class MinecraftJavaLocator
extends AbstractJavaLocator {
    @Override
    protected List<JavaInstall> initialize() {
        ArrayList<JavaInstall> installs = new ArrayList<JavaInstall>();
        Platform current = Platform.current();
        switch (current.operatingSystem()) {
            case WINDOWS: {
                ArrayList<File> programFilesLocations = new ArrayList<File>();
                String programFiles = MinecraftJavaLocator.env("ProgramFiles");
                if (programFiles != null) {
                    programFilesLocations.add(new File(programFiles));
                }
                if ((programFiles = MinecraftJavaLocator.env("ProgramFiles(x86)")) != null) {
                    programFilesLocations.add(new File(programFiles));
                }
                if ((programFiles = MinecraftJavaLocator.env("ProgramFiles(Arm)")) != null) {
                    programFilesLocations.add(new File(programFiles));
                }
                for (File directory : programFilesLocations) {
                    if (!directory.exists()) continue;
                    MinecraftJavaLocator.deepScanForInstalls(new File(directory, "Minecraft Launcher/runtime"), installs);
                }
                File appData = new File(MinecraftJavaLocator.env("LOCALAPPDATA"));
                MinecraftJavaLocator.deepScanForInstalls(new File(appData, "Packages/Microsoft.4297127D64EC6_8wekyb3d8bbwe/LocalCache/Local/runtime"), installs);
                MinecraftJavaLocator.deepScanForInstalls(new File(appData, "Packages/Microsoft.MinecraftUWP_8wekyb3d8bbwe/LocalCache/Local/runtime"), installs);
                MinecraftJavaLocator.deepScanForInstalls(new File(appData, "Packages/Microsoft.MinecraftJavaEdition_8wekyb3d8bbwe/LocalCache/Local/runtime"), installs);
                break;
            }
            case LINUX: {
                MinecraftJavaLocator.deepScanForInstalls(new File(MinecraftJavaLocator.userHome(".minecraft/runtime")), installs);
                break;
            }
            case MAC_OS: {
                MinecraftJavaLocator.deepScanForInstalls(new File(MinecraftJavaLocator.userHome("Library/Application Support/minecraft/runtime")), installs);
            }
        }
        return Collections.emptyList();
    }
}

