/*
 * Decompiled with CFR 0.152.
 */
package com.cleanroommc.javautils.locators;

import com.cleanroommc.javautils.api.JavaInstall;
import com.cleanroommc.javautils.locators.AbstractJavaLocator;
import com.cleanroommc.platformutils.Platform;
import com.cleanroommc.platformutils.windows.HKey;
import com.cleanroommc.platformutils.windows.HRegistryValueType;
import com.cleanroommc.platformutils.windows.QueryParameter;
import com.cleanroommc.platformutils.windows.QueryResult;
import com.cleanroommc.platformutils.windows.WindowsRegistry;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;

public class WindowsRegistryJavaLocator
extends AbstractJavaLocator {
    @Override
    protected List<JavaInstall> initialize() {
        if (!Platform.current().isWindows()) {
            return Collections.emptyList();
        }
        ArrayList<QueryResult> results = new ArrayList<QueryResult>();
        results.add(WindowsRegistry.query(HKey.HKEY_LOCAL_MACHINE, "Software/JavaSoft", this.parameters("JavaHome")));
        results.add(WindowsRegistry.query(HKey.HKEY_LOCAL_MACHINE, "Software/Wow6432Node/JavaSoft", this.parameters("JavaHome")));
        results.add(WindowsRegistry.query(HKey.HKEY_LOCAL_MACHINE, "Software/AdoptOpenJDK/JDK/", this.parameters("Path")));
        results.add(WindowsRegistry.query(HKey.HKEY_LOCAL_MACHINE, "Software/Eclipse Adoptium/JDK/", this.parameters("Path")));
        results.add(WindowsRegistry.query(HKey.HKEY_LOCAL_MACHINE, "Software/Eclipse Foundation/JDK/", this.parameters("Path")));
        return results.stream().filter(QueryResult::successful).map(QueryResult::entries).flatMap(Collection::stream).map(QueryResult.Entry::value).map(AbstractJavaLocator::parseOrLog).collect(Collectors.toList());
    }

    private QueryParameter[] parameters(String valueName) {
        return new QueryParameter[]{QueryParameter.recursive(), QueryParameter.valueName(valueName), QueryParameter.valueFilter(HRegistryValueType.REG_SZ)};
    }
}

