/*
 * Decompiled with CFR 0.152.
 */
package com.cleanroommc.platformutils;

public final class Architecture {
    static final Architecture CURRENT = Architecture.determine();
    private final boolean is64Bit;
    private final boolean isArm;

    private static Architecture determine() {
        String arch = System.getProperty("os.arch");
        boolean is64Bit = arch.contains("64") || arch.startsWith("armv8");
        boolean isArm = arch.startsWith("arm") || arch.startsWith("aarch64");
        return new Architecture(is64Bit, isArm);
    }

    private Architecture(boolean is64Bit, boolean isArm) {
        this.is64Bit = is64Bit;
        this.isArm = isArm;
    }

    boolean is64Bit() {
        return this.is64Bit;
    }

    boolean isArm() {
        return this.isArm;
    }
}

