/*
 * Decompiled with CFR 0.152.
 */
package com.cleanroommc.platformutils;

public enum OperatingSystem {
    WINDOWS,
    MAC_OS,
    LINUX;

    static final OperatingSystem CURRENT;

    private static OperatingSystem determine() {
        String osName = System.getProperty("os.name").toLowerCase();
        if (osName.contains("win")) {
            return WINDOWS;
        }
        if (osName.contains("mac")) {
            return MAC_OS;
        }
        return LINUX;
    }

    boolean isWindows() {
        return this == WINDOWS;
    }

    boolean isMacOS() {
        return this == MAC_OS;
    }

    boolean isLinux() {
        return this == LINUX;
    }

    static {
        CURRENT = OperatingSystem.determine();
    }
}

