/*
 * Decompiled with CFR 0.152.
 */
package com.cleanroommc.platformutils;

import com.cleanroommc.platformutils.Architecture;
import com.cleanroommc.platformutils.OperatingSystem;

public final class Platform {
    private static final Platform CURRENT = new Platform();
    private final OperatingSystem operatingSystem = OperatingSystem.CURRENT;
    private final Architecture architecture = Architecture.CURRENT;

    public static Platform current() {
        return CURRENT;
    }

    private Platform() {
    }

    public OperatingSystem operatingSystem() {
        return this.operatingSystem;
    }

    public Architecture architecture() {
        return this.architecture;
    }

    public boolean isWindows() {
        return this.operatingSystem.isWindows();
    }

    public boolean isMacOS() {
        return this.operatingSystem.isMacOS();
    }

    public boolean isLinux() {
        return this.operatingSystem.isLinux();
    }

    public boolean is64Bit() {
        return this.architecture.is64Bit();
    }

    public boolean isArm() {
        return this.architecture.isArm();
    }
}

