/*
 * Decompiled with CFR 0.152.
 */
package com.cleanroommc.platformutils.windows;

import com.cleanroommc.platformutils.windows.HKey;
import com.cleanroommc.platformutils.windows.HRegistryValueType;
import java.util.Arrays;
import java.util.Collection;

public class QueryResult {
    private final Collection<Entry> entries;
    private final String message;

    static Entry parse(HKey hKey, String key, String[] split) {
        if (key == null) {
            throw new IllegalArgumentException(String.format("Unable to parse QueryResult with a null key: {%s}", Arrays.toString(split)));
        }
        if (split.length != 4) {
            throw new IllegalArgumentException(String.format("Unable to parse QueryResult from: {%s}", Arrays.toString(split)));
        }
        return new Entry(hKey, key, split[1], HRegistryValueType.valueOf(split[2]), split[3]);
    }

    static QueryResult success(Collection<Entry> entries) {
        return new QueryResult(entries);
    }

    static QueryResult error(String message) {
        return new QueryResult(message);
    }

    private QueryResult(Collection<Entry> entries) {
        this.entries = entries;
        this.message = null;
    }

    private QueryResult(String message) {
        this.entries = null;
        this.message = message;
    }

    public boolean successful() {
        return this.entries != null;
    }

    public boolean errored() {
        return this.message != null;
    }

    public Collection<Entry> entries() {
        return this.entries;
    }

    public static class Entry {
        private final HKey hKey;
        private final String key;
        private final String valueKey;
        private final String valueString;
        private final HRegistryValueType valueType;

        private Entry(HKey hKey, String key, String valueKey, HRegistryValueType valueType, String valueString) {
            this.hKey = hKey;
            this.key = key;
            this.valueKey = valueKey;
            this.valueType = valueType;
            this.valueString = valueString;
        }

        public HKey hKey() {
            return this.hKey;
        }

        public String key() {
            return this.key;
        }

        public String valueKey() {
            return this.valueKey;
        }

        public HRegistryValueType valueType() {
            return this.valueType;
        }

        public String value() {
            return this.valueString;
        }

        public String toString() {
            return "QueryResult$Entry{hKey=" + (Object)((Object)this.hKey) + ", key='" + this.key + '\'' + ", valueKey='" + this.valueKey + '\'' + ", valueString='" + this.valueString + '\'' + ", valueType=" + (Object)((Object)this.valueType) + '}';
        }
    }
}

