/*
 * Decompiled with CFR 0.152.
 */
package com.cleanroommc.relauncher;

import com.cleanroommc.relauncher.DownloadEntry;
import com.cleanroommc.relauncher.Downloader;
import com.cleanroommc.relauncher.Initializer;
import com.cleanroommc.relauncher.Relauncher;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.nio.file.Files;
import java.util.ArrayList;

public class CleanroomVersionParser {
    private static String version = "";

    public static String getVersion() throws IOException {
        if (!version.isEmpty()) {
            return version;
        }
        Relauncher.LOGGER.info("Parsing latest Cleanroom versions");
        Initializer.getMainStatusLabel().setText("Parsing latest Cleanroom versions");
        File metadata = new File(Relauncher.workingDir, "maven-metadata.xml");
        String version = "0.3.19-alpha";
        Relauncher.LOGGER.info("Downloading metadata");
        ArrayList<DownloadEntry> list = new ArrayList<DownloadEntry>(1);
        list.add(new DownloadEntry(new URL("https://repo.cleanroommc.com/releases/com/cleanroommc/cleanroom/maven-metadata.xml"), metadata, ""));
        try {
            Downloader.downloadAll(list);
        }
        catch (Exception e) {
            Relauncher.LOGGER.error((Object)e);
            throw new RuntimeException(e);
        }
        BufferedReader reader = Files.newBufferedReader(metadata.toPath());
        while (reader.ready()) {
            String temp;
            String line = reader.readLine();
            if (!line.contains("<version>") || (temp = line.substring(line.indexOf("<version>") + 9, line.indexOf("</version>"))).contains("build")) continue;
            version = temp;
        }
        Relauncher.LOGGER.info("Found version {}", (Object)version);
        Initializer.getMainStatusLabel().setText("Found version " + version);
        reader.close();
        CleanroomVersionParser.version = version;
        return version;
    }

    public static void setVersion(String version) {
        CleanroomVersionParser.version = version;
    }
}

