/*
 * Decompiled with CFR 0.152.
 */
package com.cleanroommc.relauncher;

import com.cleanroommc.relauncher.Config;
import com.cleanroommc.relauncher.Relauncher;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.lang3.tuple.Triple;

public class DownloadEntry {
    private final URL url;
    private final File destination;
    private final String sha1;
    private final AtomicInteger attempts = new AtomicInteger(0);

    public DownloadEntry(URL url, File destination, String sha1) {
        this.url = url;
        this.destination = destination;
        this.sha1 = sha1;
    }

    public DownloadEntry(Triple<String, String, String> triple) {
        File libDir = Config.libraryPath.isEmpty() ? Relauncher.workingDir : new File(Config.libraryPath);
        String[] a = ((String)triple.getMiddle()).split("/");
        String fileName = a[a.length - 1];
        if (Config.respectLibraryStructure) {
            String[] maven = ((String)triple.getLeft()).split(":");
            fileName = maven[0].replace('.', File.separatorChar) + File.separatorChar + maven[2] + File.separatorChar + fileName;
            if (File.separatorChar == '\\') {
                fileName = fileName.replace("\\", "\\\\");
            }
        }
        this.destination = new File(libDir, fileName);
        try {
            String urlString = (String)triple.getMiddle();
            if (!Config.replaceMavenURL.isEmpty()) {
                urlString = urlString.replace("https://repo.maven.apache.org/maven2", Config.replaceMavenURL);
            }
            this.url = new URL(urlString);
        }
        catch (MalformedURLException e) {
            throw new RuntimeException(e);
        }
        this.sha1 = (String)triple.getRight();
    }

    public URL getUrl() {
        return this.url;
    }

    public File getDestination() {
        return this.destination;
    }

    public String getSha1() {
        return this.sha1;
    }

    public int failed() {
        return this.attempts.addAndGet(1);
    }
}

