/*
 * Decompiled with CFR 0.152.
 */
package com.cleanroommc.relauncher;

import com.cleanroommc.relauncher.Config;
import com.cleanroommc.relauncher.DownloadEntry;
import com.cleanroommc.relauncher.Initializer;
import com.cleanroommc.relauncher.JVMInfo;
import com.cleanroommc.relauncher.Relauncher;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URISyntaxException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.attribute.FileAttribute;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;
import java.util.List;
import java.util.PriorityQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import nl.altindag.ssl.SSLFactory;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.io.IOUtils;
import org.apache.hc.client5.http.classic.methods.HttpGet;
import org.apache.hc.client5.http.impl.classic.CloseableHttpClient;
import org.apache.hc.client5.http.impl.classic.CloseableHttpResponse;
import org.apache.hc.client5.http.impl.classic.HttpClientBuilder;
import org.apache.hc.client5.http.impl.classic.HttpClients;
import org.apache.hc.client5.http.impl.io.PoolingHttpClientConnectionManager;
import org.apache.hc.client5.http.impl.io.PoolingHttpClientConnectionManagerBuilder;
import org.apache.hc.client5.http.ssl.DefaultClientTlsStrategy;
import org.apache.hc.core5.http.ClassicHttpRequest;
import org.apache.hc.core5.http.ClassicHttpResponse;
import org.apache.hc.core5.http.HttpHost;

public class Downloader {
    private static final PoolingHttpClientConnectionManager connManager;
    private static final HttpClientBuilder builder;
    private static final PriorityQueue<DownloadEntry> queue;

    public static void downloadAll(List<DownloadEntry> list) {
        Initializer.getMainProgressbar().setMaximum(list.size());
        try (CloseableHttpClient client = builder.build();){
            while (!list.isEmpty() || !queue.isEmpty()) {
                while (!queue.isEmpty()) {
                    list.add(queue.poll());
                }
                ExecutorService pool = Executors.newFixedThreadPool(Config.maxDownloadSession);
                AtomicInteger i = new AtomicInteger();
                while (!list.isEmpty()) {
                    DownloadEntry entry = list.remove(0);
                    try {
                        HttpGet httpGet = new HttpGet(entry.getUrl().toURI());
                        pool.submit(new DownloadThread(client, httpGet, i.getAndIncrement(), entry));
                    }
                    catch (URISyntaxException e) {
                        Relauncher.LOGGER.error((Object)e);
                    }
                }
                pool.shutdown();
                pool.awaitTermination(Long.MAX_VALUE, TimeUnit.MILLISECONDS);
            }
        }
        catch (IOException | InterruptedException e) {
            Relauncher.LOGGER.error((Object)e);
        }
    }

    private static boolean calculateSHA1(File dest, String sha1) {
        if (sha1.isEmpty()) {
            return true;
        }
        try {
            boolean match = DigestUtils.sha1Hex((InputStream)Files.newInputStream(dest.toPath(), new OpenOption[0])).equals(sha1);
            if (!match) {
                Relauncher.LOGGER.warn("SHA1 calculation of file {} failed, re-downloading", (Object)dest);
            }
            return match;
        }
        catch (IOException e) {
            Relauncher.LOGGER.warn("Caught error in SHA1 calculation of file {}, re-downloading", (Object)dest.getName(), (Object)e);
            return false;
        }
    }

    static {
        queue = new PriorityQueue();
        try {
            InputStream certStream = Downloader.class.getResourceAsStream("/cacerts.jks");
            KeyStore keyStore = KeyStore.getInstance("JKS");
            keyStore.load(certStream, "changeit".toCharArray());
            SSLFactory sslFactory = SSLFactory.builder().withDefaultTrustMaterial().withSystemTrustMaterial().withTrustMaterial(keyStore).withProtocols("TLSv1.0").build();
            DefaultClientTlsStrategy tlsStrategy = new DefaultClientTlsStrategy(sslFactory.getSslContext());
            connManager = JVMInfo.getCurrentUpdateNumber() < 341 ? PoolingHttpClientConnectionManagerBuilder.create().setTlsSocketStrategy(tlsStrategy).build() : PoolingHttpClientConnectionManagerBuilder.create().build();
        }
        catch (IOException | KeyStoreException | NoSuchAlgorithmException | CertificateException e) {
            throw new RuntimeException(e);
        }
        connManager.setMaxTotal(Config.maxDownloadSession);
        builder = !Config.proxyAddr.isEmpty() && Config.proxyPort != 0 ? HttpClients.custom().setConnectionManager(connManager).setConnectionManagerShared(true).setProxy(new HttpHost(Config.proxyAddr, Config.proxyPort)) : HttpClients.custom().setConnectionManager(connManager).setConnectionManagerShared(true);
    }

    private static class DownloadThread
    extends Thread {
        private final CloseableHttpClient httpClient;
        private final HttpGet httpget;
        private final DownloadEntry entry;

        public DownloadThread(CloseableHttpClient httpClient, HttpGet httpget, int id, DownloadEntry entry) {
            this.httpClient = httpClient;
            this.httpget = httpget;
            this.setName("Download thread#" + id);
            this.entry = entry;
        }

        @Override
        public void run() {
            Relauncher.LOGGER.info("Checking {}...", (Object)this.entry.getDestination().getName());
            if (this.entry.getDestination().exists()) {
                if (Downloader.calculateSHA1(this.entry.getDestination(), this.entry.getSha1())) {
                    Relauncher.LOGGER.info("File {} already exist, skipping", (Object)this.entry.getDestination().getName());
                    Initializer.addProgress();
                    return;
                }
            } else {
                try {
                    Files.createDirectories(this.entry.getDestination().getParentFile().toPath(), new FileAttribute[0]);
                }
                catch (IOException e) {
                    Relauncher.LOGGER.error("Create parent directory of {} failed.", (Object)this.entry.getDestination());
                    Relauncher.LOGGER.error(e.getMessage());
                }
            }
            try {
                ClassicHttpResponse httpresponse = this.httpClient.execute((ClassicHttpRequest)this.httpget, response -> {
                    try (FileOutputStream outputStream = new FileOutputStream(this.entry.getDestination());){
                        IOUtils.copy((InputStream)response.getEntity().getContent(), (OutputStream)outputStream);
                    }
                    return (CloseableHttpResponse)response;
                });
                if (!this.entry.getSha1().isEmpty()) {
                    if (!Downloader.calculateSHA1(this.entry.getDestination(), this.entry.getSha1())) {
                        Relauncher.LOGGER.info("Downloaded file {} has invalid checksum, re-downloading...", (Object)this.entry.getDestination().getName());
                        if (this.entry.failed() >= Config.maxRetry) {
                            Relauncher.LOGGER.error("Download {} reached max attempts", (Object)this.entry.getDestination().getName());
                            throw new RuntimeException("Max retry reached");
                        }
                        queue.add(this.entry);
                        Relauncher.LOGGER.info("Adding {} back to queue", (Object)this.entry.getDestination().getName());
                    } else {
                        Initializer.addProgress();
                    }
                }
            }
            catch (Exception e) {
                Relauncher.LOGGER.error(e.getMessage());
                if (this.entry.failed() >= Config.maxRetry) {
                    Relauncher.LOGGER.error("Download {} reached max attempts, caused by {}.", (Object)this.entry.getDestination().getName(), (Object)e);
                    throw new RuntimeException("Max retry reached");
                }
                queue.add(this.entry);
                Relauncher.LOGGER.info("Retrying on {}", (Object)this.entry.getDestination().getName());
            }
        }
    }
}

