/*
 * Decompiled with CFR 0.152.
 */
package com.cleanroommc.relauncher;

import com.cleanroommc.relauncher.Config;
import com.cleanroommc.relauncher.GUIUtils;
import com.cleanroommc.relauncher.JVMInfo;
import com.cleanroommc.relauncher.JavaDetector;
import com.cleanroommc.relauncher.MMCPackDownloader;
import com.cleanroommc.relauncher.MMCPackParser;
import com.cleanroommc.relauncher.Relauncher;
import com.google.common.collect.Lists;
import java.awt.Color;
import java.awt.Component;
import java.awt.Desktop;
import java.awt.Dimension;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Arrays;
import java.util.Vector;
import java.util.function.Consumer;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JProgressBar;
import javax.swing.JSeparator;
import javax.swing.JSpinner;
import javax.swing.JTextField;
import javax.swing.SpinnerNumberModel;
import javax.swing.UIManager;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.filechooser.FileFilter;
import net.miginfocom.swing.MigLayout;
import net.minecraftforge.fml.ExitWrapper;
import org.apache.commons.lang3.SystemUtils;
import org.apache.logging.log4j.Logger;

public class Initializer {
    private static final String valid = "\u2714";
    private static final String invalid = "\u274c";
    private static volatile boolean verified = false;
    private static final JLabel mainStatusLabel = new JLabel();
    private static final JProgressBar mainProgressbar = new JProgressBar();
    private static JButton launchButton;
    private static final JFrame mainFrame;
    private static Consumer<Boolean> setInteractable;
    private static Runnable verifyJVM;
    private static final String[] mirrors;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void InitJavaAndArg() {
        Initializer.checkJavaAndWarn();
        Config.syncConfig();
        mainFrame.setLayout(new MigLayout("", "[grow][grow][grow][grow]", "[grow][grow][grow][grow][grow][grow][grow]"));
        JLabel pathLabel = new JLabel("Java Path*");
        final JTextField pathText = new JTextField();
        JLabel jvmStatus = new JLabel(invalid);
        JFileChooser jvmPicker = Initializer.getJavaFileChooser();
        JButton detectJvmButton = new JButton("Detect Java");
        JButton browserButton = new JButton("Browse Java");
        JLabel argsLabel = new JLabel("Java Args");
        final JTextField args = new JTextField();
        JButton advSetting = new JButton("Advanced Settings");
        setInteractable = value -> {
            launchButton.setEnabled((boolean)value);
            pathText.setEnabled((boolean)value);
            detectJvmButton.setEnabled((boolean)value);
            browserButton.setEnabled((boolean)value);
            args.setEnabled((boolean)value);
            advSetting.setEnabled((boolean)value);
        };
        launchButton = new JButton("Launch");
        launchButton.setEnabled(false);
        mainFrame.add((Component)pathLabel, "cell 0 0, grow");
        pathLabel.setHorizontalAlignment(0);
        GUIUtils.enlargeFont(pathLabel);
        mainFrame.add((Component)pathText, "cell 1 0 2 1, grow");
        pathText.setMinimumSize(new Dimension(300, 10));
        GUIUtils.enlargeFont(pathText);
        mainFrame.add((Component)jvmStatus, "cell 3 0, grow");
        jvmStatus.setHorizontalAlignment(0);
        GUIUtils.enlargeFont(jvmStatus);
        mainFrame.add((Component)detectJvmButton, "cell 0 1 2 1, grow");
        GUIUtils.enlargeFont(detectJvmButton);
        mainFrame.add((Component)browserButton, "cell 2 1 21, grow");
        GUIUtils.enlargeFont(browserButton);
        mainFrame.add((Component)new JSeparator(0), "cell 0 2 4 1, grow");
        mainFrame.add((Component)argsLabel, "cell 0 3, grow");
        argsLabel.setHorizontalAlignment(0);
        GUIUtils.enlargeFont(argsLabel);
        mainFrame.add((Component)args, "cell 1 3 3 1, grow");
        args.setMinimumSize(new Dimension(300, 10));
        GUIUtils.enlargeFont(args);
        mainFrame.add((Component)advSetting, "cell 0 4 4 1, grow");
        advSetting.setMinimumSize(new Dimension(300, 10));
        GUIUtils.enlargeFont(advSetting);
        mainFrame.add((Component)new JSeparator(0), "cell 0 5 4 1, grow");
        mainFrame.add((Component)mainStatusLabel, "cell 0 6 4 1, grow");
        mainStatusLabel.setMinimumSize(new Dimension(300, 10));
        mainStatusLabel.setHorizontalAlignment(0);
        GUIUtils.enlargeFont(mainStatusLabel);
        mainFrame.add((Component)mainProgressbar, "cell 0 7 4 1, grow");
        mainProgressbar.setMinimumSize(new Dimension(300, 10));
        GUIUtils.enlargeFont(mainProgressbar);
        mainFrame.add((Component)launchButton, "cell 0 8 4 1, grow");
        launchButton.setMinimumSize(new Dimension(300, 10));
        GUIUtils.enlargeFont(launchButton, 1, 20);
        mainFrame.setTitle("Relauncher Initialization Settings");
        mainFrame.setDefaultCloseOperation(0);
        mainFrame.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent windowEvent) {
                ExitWrapper.exit(0);
            }
        });
        pathLabel.setHorizontalAlignment(0);
        pathText.setToolTipText("Input your Java 21+ executable here");
        detectJvmButton.addActionListener(actionEvent -> {
            if (actionEvent.getSource().equals(detectJvmButton)) {
                Initializer.showDetectorDialog(pathText);
            }
        });
        pathText.setText(Config.javaPath);
        args.setText(Config.jvmArgs);
        advSetting.addActionListener(actionEvent -> Initializer.showAdvancedSettingDialog());
        launchButton.addActionListener(actionEvent -> {
            if (actionEvent.getSource().equals(launchButton)) {
                if (verified || Initializer.isJavaNewerThan21(pathText.getText())) {
                    Relauncher.LOGGER.info("Java valid and saved");
                    setInteractable.accept(false);
                    Config.javaPath = pathText.getText();
                    Config.jvmArgs = args.getText();
                    mainProgressbar.setIndeterminate(false);
                    try {
                        Thread workingThread = new Thread(() -> {
                            try {
                                MMCPackDownloader.downloadAndExtract();
                                MMCPackParser.parseMMCPack();
                            }
                            catch (IOException e) {
                                throw new RuntimeException(e);
                            }
                            Object object = Relauncher.o;
                            synchronized (object) {
                                Relauncher.o.notify();
                            }
                        }, "Relauncher Working Thread");
                        workingThread.start();
                    }
                    catch (Throwable t) {
                        Relauncher.LOGGER.error(t.getMessage());
                        Arrays.stream(t.getStackTrace()).forEach(arg_0 -> ((Logger)Relauncher.LOGGER).info(arg_0));
                        mainStatusLabel.setText(t.getMessage());
                        setInteractable.accept(true);
                        mainProgressbar.setIndeterminate(true);
                    }
                } else {
                    Relauncher.LOGGER.warn("Invalid Java");
                    launchButton.setEnabled(false);
                    verifyJVM.run();
                }
            }
        });
        verifyJVM = () -> {
            if (Initializer.isJavaNewerThan21(pathText.getText())) {
                verified = true;
                jvmStatus.setText(valid);
                jvmStatus.setForeground(Color.GREEN);
                launchButton.setEnabled(true);
            } else {
                verified = false;
                jvmStatus.setText(invalid);
                jvmStatus.setForeground(Color.RED);
                launchButton.setEnabled(false);
            }
        };
        verifyJVM.run();
        pathText.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent documentEvent) {
                this.onChange();
            }

            @Override
            public void removeUpdate(DocumentEvent documentEvent) {
                this.onChange();
            }

            @Override
            public void changedUpdate(DocumentEvent documentEvent) {
                this.onChange();
            }

            private void onChange() {
                verifyJVM.run();
                pathText.setToolTipText(pathText.getText());
            }
        });
        browserButton.addActionListener(actionEvent -> {
            if (actionEvent.getSource().equals(browserButton)) {
                GUIUtils.setCentral(jvmPicker);
                int r = jvmPicker.showOpenDialog(mainFrame);
                if (r == 0) {
                    pathText.setText(jvmPicker.getSelectedFile().getAbsolutePath());
                    verifyJVM.run();
                }
            }
        });
        args.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent documentEvent) {
                this.onChange();
            }

            @Override
            public void removeUpdate(DocumentEvent documentEvent) {
                this.onChange();
            }

            @Override
            public void changedUpdate(DocumentEvent documentEvent) {
                this.onChange();
            }

            private void onChange() {
                args.setToolTipText(pathText.getText());
            }
        });
        argsLabel.setHorizontalAlignment(0);
        mainProgressbar.setIndeterminate(true);
        mainProgressbar.addChangeListener(changeEvent -> mainStatusLabel.setText(String.format("Downloading: %d/%d", mainProgressbar.getValue(), mainProgressbar.getMaximum())));
        mainStatusLabel.setHorizontalAlignment(0);
        mainStatusLabel.setText("Status: Idle");
        Relauncher.LOGGER.info("Launching GUI");
        mainFrame.validate();
        mainFrame.pack();
        GUIUtils.setCentral(mainFrame);
        mainFrame.setVisible(true);
        mainFrame.setMinimumSize(mainFrame.getSize());
        Object object = Relauncher.o;
        synchronized (object) {
            try {
                Relauncher.o.wait();
            }
            catch (InterruptedException e) {
                Relauncher.LOGGER.error((Object)e);
            }
        }
    }

    private static JFileChooser getJavaFileChooser() {
        JFileChooser jvmPicker = new JFileChooser(SystemUtils.getUserDir());
        jvmPicker.setMultiSelectionEnabled(false);
        jvmPicker.setAcceptAllFileFilterUsed(false);
        jvmPicker.addChoosableFileFilter(new FileFilter(){

            @Override
            public boolean accept(File file) {
                return file.getName().equals("javaw.exe") || file.getName().equals("java") || file.isDirectory();
            }

            @Override
            public String getDescription() {
                return "Java executable, javaw.exe on Windows and java on other OS";
            }
        });
        jvmPicker.setFileHidingEnabled(false);
        jvmPicker.setFileSelectionMode(0);
        return jvmPicker;
    }

    private static JFileChooser getLibraryPathChooser() {
        JFileChooser jvmPicker = new JFileChooser(SystemUtils.getUserDir());
        jvmPicker.setMultiSelectionEnabled(false);
        jvmPicker.setAcceptAllFileFilterUsed(false);
        jvmPicker.setFileHidingEnabled(false);
        jvmPicker.setFileSelectionMode(1);
        return jvmPicker;
    }

    public static boolean isJavaNewerThan21(String path) {
        if (path == null) {
            return false;
        }
        Relauncher.LOGGER.info("Checking path {}", (Object)path);
        return new JVMInfo(path).getSpecification() > 20;
    }

    public static JLabel getMainStatusLabel() {
        return mainStatusLabel;
    }

    public static JProgressBar getMainProgressbar() {
        return mainProgressbar;
    }

    public static JButton getLaunchButton() {
        return launchButton;
    }

    public static void setGUIInteractable(boolean enable) {
        setInteractable.accept(enable);
    }

    public static void hideWindow() {
        mainFrame.setVisible(false);
    }

    private static void showDetectorDialog(JTextField pathField) {
        JDialog detector = new JDialog(mainFrame.getOwner());
        detector.setFocusableWindowState(true);
        detector.setDefaultCloseOperation(0);
        detector.setLayout(new MigLayout("", "[grow][grow]", "[grow][grow][grow]"));
        DefaultListModel model = new DefaultListModel();
        JList list = new JList(model);
        JLabel info = new JLabel("Status: Idle");
        info.setHorizontalAlignment(0);
        JButton confirm = new JButton("Confirm");
        JButton cancel = new JButton("Cancel");
        detector.add(list, "cell 0 0 2 2, grow");
        GUIUtils.enlargeFont(list);
        detector.add((Component)info, "cell 0 2 2 1, grow");
        GUIUtils.enlargeFont(info);
        detector.add((Component)cancel, "cell 0 3, grow");
        GUIUtils.enlargeFont(cancel);
        detector.add((Component)confirm, "cell 1 3, grow");
        GUIUtils.enlargeFont(confirm, 1, 20);
        list.setSelectionMode(0);
        list.setLayoutOrientation(0);
        list.setVisibleRowCount(-1);
        list.addListSelectionListener(listSelectionEvent -> {
            String path = ((JVMInfo)list.getSelectedValue()).getFile().getAbsolutePath();
            info.setText(path);
            info.setToolTipText(path);
            detector.pack();
        });
        list.setMinimumSize(new Dimension(300, 200));
        cancel.addActionListener(actionEvent -> {
            if (actionEvent.getSource().equals(cancel)) {
                detector.setVisible(false);
                Initializer.setGUIInteractable(true);
            }
        });
        confirm.addActionListener(actionEvent -> {
            if (actionEvent.getSource().equals(confirm)) {
                detector.setVisible(false);
                Initializer.setGUIInteractable(true);
                pathField.setText(((JVMInfo)list.getSelectedValue()).getFile().getAbsolutePath());
                verifyJVM.run();
            }
        });
        cancel.setEnabled(false);
        confirm.setEnabled(false);
        info.setText("Scanning...");
        Relauncher.LOGGER.info("Scanning...");
        detector.pack();
        GUIUtils.setCentral(detector);
        detector.setAlwaysOnTop(true);
        Initializer.setGUIInteractable(false);
        detector.setVisible(true);
        detector.setMinimumSize(detector.getSize());
        Thread scan = new Thread(() -> {
            for (JVMInfo i : JavaDetector.getInstalledJVMs()) {
                model.addElement(i);
            }
            cancel.setEnabled(true);
            confirm.setEnabled(true);
            info.setText("Scan complete.");
            detector.pack();
            GUIUtils.setCentral(detector);
        });
        scan.start();
    }

    private static void showAdvancedSettingDialog() {
        JDialog advSetting = new JDialog(mainFrame.getOwner());
        advSetting.setLayout(new MigLayout("", "[grow][grow][grow][grow]", "[grow][grow][grow][grow][grow][grow][grow][grow]"));
        advSetting.setFocusableWindowState(true);
        JLabel libraryPathLabel = new JLabel("Library Path");
        libraryPathLabel.setHorizontalAlignment(0);
        JTextField libraryPathText = new JTextField();
        libraryPathText.setText(Config.libraryPath);
        JButton cancel = new JButton("Cancel");
        JButton confirm = new JButton("Confirm");
        JFileChooser libraryPicker = Initializer.getLibraryPathChooser();
        JCheckBox groupNameInPathCheckbox = new JCheckBox("Place Libraries in Group Name");
        groupNameInPathCheckbox.setSelected(Config.respectLibraryStructure);
        JButton libraryBrowserButton = new JButton("Browser...");
        JLabel proxyLabel = new JLabel("Proxy Host");
        proxyLabel.setHorizontalAlignment(0);
        JLabel proxyPortLabel = new JLabel("Proxy Port");
        proxyPortLabel.setHorizontalAlignment(0);
        JTextField proxyAddrTextField = new JTextField();
        proxyAddrTextField.setText(Config.proxyAddr);
        JSpinner portSpinner = new JSpinner(new SpinnerNumberModel(Config.proxyPort, 0, 65535, 1));
        JCheckBox useLocalCheckbox = new JCheckBox("Use Local MMC Pack");
        useLocalCheckbox.setSelected(Config.useLocalPack);
        JLabel mirrorLabel = new JLabel("Maven Mirror");
        mirrorLabel.setHorizontalAlignment(0);
        JComboBox mirrorList = new JComboBox(new Vector(Lists.newArrayList((Object[])mirrors)));
        mirrorList.setSelectedItem(Config.replaceMavenURL);
        JLabel maxRetryLabel = new JLabel("Max retry");
        maxRetryLabel.setHorizontalAlignment(0);
        JSpinner maxRetrySpinner = new JSpinner(new SpinnerNumberModel(Config.maxRetry, 1, 65535, 1));
        JLabel maxSessionLabel = new JLabel("Max sessions");
        maxSessionLabel.setHorizontalAlignment(0);
        JSpinner maxSessionSpinner = new JSpinner(new SpinnerNumberModel(Config.maxDownloadSession, 1, 65535, 1));
        libraryPathText.setToolTipText("Path to place the libraries, leave it empty to use default location");
        advSetting.add((Component)libraryPathLabel, "cell 0 0, grow");
        GUIUtils.enlargeFont(libraryPathLabel);
        advSetting.add((Component)libraryPathText, "cell 1 0 3 1, grow");
        GUIUtils.enlargeFont(libraryPathText);
        advSetting.add((Component)groupNameInPathCheckbox, "cell 1 1 2 1, grow");
        GUIUtils.enlargeFont(groupNameInPathCheckbox);
        advSetting.add((Component)libraryBrowserButton, "cell 3 1, grow");
        GUIUtils.enlargeFont(libraryBrowserButton);
        advSetting.add((Component)new JSeparator(0), "cell 0 2 4 1, grow");
        advSetting.pack();
        int width = libraryPathText.getWidth();
        advSetting.add((Component)mirrorLabel, "cell 0 3, grow");
        GUIUtils.enlargeFont(mirrorLabel);
        advSetting.add(mirrorList, "cell 1 3 3 1, grow");
        GUIUtils.enlargeFont(mirrorList);
        mirrorList.setMaximumSize(new Dimension(width, Integer.MAX_VALUE));
        advSetting.add((Component)proxyLabel, "cell 0 4, grow");
        GUIUtils.enlargeFont(proxyLabel);
        advSetting.add((Component)proxyAddrTextField, "cell 1 4, grow");
        GUIUtils.enlargeFont(proxyAddrTextField);
        advSetting.add((Component)proxyPortLabel, "cell 2 4,grow");
        GUIUtils.enlargeFont(proxyPortLabel);
        advSetting.add((Component)portSpinner, "cell 3 4, grow");
        GUIUtils.enlargeFont(portSpinner);
        advSetting.add((Component)maxRetryLabel, "cell 0 5, grow");
        GUIUtils.enlargeFont(maxRetryLabel);
        advSetting.add((Component)maxRetrySpinner, "cell 1 5, grow");
        GUIUtils.enlargeFont(maxRetrySpinner);
        advSetting.add((Component)maxSessionLabel, "cell 2 5, grow");
        GUIUtils.enlargeFont(maxSessionLabel);
        advSetting.add((Component)maxSessionSpinner, "cell 3 5, grow");
        GUIUtils.enlargeFont(maxSessionSpinner);
        advSetting.add((Component)new JSeparator(0), "cell 0 6 4 1, grow");
        advSetting.add((Component)useLocalCheckbox, "cell 0 7 2 1, grow");
        GUIUtils.enlargeFont(useLocalCheckbox);
        advSetting.add((Component)cancel, "cell 2 7, grow");
        GUIUtils.enlargeFont(cancel);
        advSetting.add((Component)confirm, "cell 3 7, grow");
        GUIUtils.enlargeFont(confirm, 1, 20);
        groupNameInPathCheckbox.setToolTipText("Place libraries in their corresponding groups. Useful when you want to reuse libraries with the launcher.");
        mirrorLabel.setToolTipText("The mirror URL used to replace central maven. Currently only Chinese ISP may need this.");
        libraryBrowserButton.addActionListener(actionEvent -> {
            if (actionEvent.getSource().equals(libraryBrowserButton)) {
                GUIUtils.setCentral(libraryPicker);
                int r = libraryPicker.showOpenDialog(mainFrame);
                if (r == 0) {
                    libraryPathText.setText(libraryPicker.getSelectedFile().getAbsolutePath());
                }
            }
        });
        mirrorList.addActionListener(actionEvent -> mirrorList.setToolTipText((String)mirrorList.getSelectedItem()));
        useLocalCheckbox.setToolTipText("Will use first Cleanroom-MMC-instance-*.zip in relauncher dir");
        proxyAddrTextField.setToolTipText("Proxy Address, leave it empty means no proxy");
        portSpinner.setToolTipText("Proxy Port, leave it 0 means no proxy");
        portSpinner.setModel(new SpinnerNumberModel());
        mirrorList.setEditable(true);
        cancel.addActionListener(actionEvent -> {
            if (actionEvent.getSource().equals(cancel)) {
                advSetting.setVisible(false);
                Initializer.setGUIInteractable(true);
            }
        });
        confirm.addActionListener(actionEvent -> {
            if (actionEvent.getSource().equals(confirm)) {
                advSetting.setVisible(false);
                Initializer.setGUIInteractable(true);
                Config.replaceMavenURL = (String)mirrorList.getSelectedItem();
                Config.useLocalPack = useLocalCheckbox.isSelected();
                Config.proxyPort = (Integer)portSpinner.getValue();
                Config.proxyAddr = proxyAddrTextField.getText();
                Config.maxDownloadSession = (Integer)maxSessionSpinner.getValue();
                Config.maxRetry = (Integer)maxRetrySpinner.getValue();
                Config.respectLibraryStructure = groupNameInPathCheckbox.isSelected();
            }
        });
        advSetting.setDefaultCloseOperation(0);
        advSetting.setAlwaysOnTop(true);
        advSetting.pack();
        GUIUtils.setCentral(advSetting);
        advSetting.setMinimumSize(advSetting.getSize());
        Initializer.setGUIInteractable(false);
        advSetting.setVisible(true);
        advSetting.requestFocus();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void checkJavaAndWarn() {
        JDialog warning = new JDialog();
        warning.setLayout(new MigLayout());
        JLabel icon = new JLabel(UIManager.getIcon("OptionPane.warningIcon"));
        GUIUtils.enlargeFont(icon);
        JLabel oldJava = new JLabel("You are using an outdated Java VM, relauncher may hang and need manually retry.");
        oldJava.setHorizontalAlignment(0);
        GUIUtils.enlargeFont(oldJava);
        JLabel oldJava2 = new JLabel("To avoid potential malfunction, please click the button to download latest java 8.");
        oldJava2.setHorizontalAlignment(0);
        GUIUtils.enlargeFont(oldJava2);
        LinkButton java8button = new LinkButton("https://adoptium.net/temurin/releases?version=8&os=any&arch=any");
        GUIUtils.enlargeFont(java8button);
        JLabel newJava = new JLabel("You will need at lest one Java 21+ JRE installed to use relauncher.");
        newJava.setHorizontalAlignment(0);
        GUIUtils.enlargeFont(newJava);
        JLabel newJava2 = new JLabel("If you don't, please click the button to download one.");
        newJava2.setHorizontalAlignment(0);
        GUIUtils.enlargeFont(newJava2);
        LinkButton java21button = new LinkButton("https://adoptium.net/temurin/releases?version=21&os=any&arch=any");
        GUIUtils.enlargeFont(java21button);
        JButton confirm = new JButton("Continue");
        GUIUtils.enlargeFont(confirm, 1, 20);
        JButton quit = new JButton("Quit");
        GUIUtils.enlargeFont(quit);
        warning.add((Component)icon, "cell 0 0 2 1, grow");
        if (JVMInfo.getCurrentUpdateNumber() < 341 && JVMInfo.getCurrentUpdateNumber() > 0) {
            warning.add((Component)oldJava, "cell 0 1, grow");
            warning.add((Component)oldJava2, "cell 0 2, grow");
            warning.add((Component)java8button, "cell 1 2, grow");
            warning.add((Component)new JSeparator(0), "cell 0 3 2 1, grow");
            warning.add((Component)newJava, "cell 0 4, grow");
            warning.add((Component)newJava2, "cell 0 5, grow");
            warning.add((Component)java21button, "cell 1 5, grow");
            warning.add((Component)new JSeparator(0), "cell 0 6 2 1, grow");
            warning.add((Component)quit, "cell 0 7, grow");
            warning.add((Component)confirm, "cell 1 7, grow");
        } else {
            warning.add((Component)newJava, "cell 0 1, grow");
            warning.add((Component)newJava2, "cell 0 2, grow");
            warning.add((Component)java21button, "cell 1 2, grow");
            warning.add((Component)new JSeparator(0), "cell 0 3 2 1, grow");
            warning.add((Component)quit, "cell 0 4, grow");
            warning.add((Component)confirm, "cell 1 4, grow");
        }
        quit.addActionListener(actionEvent -> ExitWrapper.exit(0));
        confirm.addActionListener(actionEvent -> {
            if (actionEvent.getSource().equals(confirm)) {
                warning.setVisible(false);
                Object object = Relauncher.o;
                synchronized (object) {
                    Relauncher.o.notify();
                }
            }
        });
        warning.validate();
        warning.pack();
        GUIUtils.setCentral(warning);
        warning.setVisible(true);
        warning.setResizable(false);
        Object object = Relauncher.o;
        synchronized (object) {
            try {
                Relauncher.o.wait();
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
        }
    }

    public static synchronized void addProgress() {
        mainProgressbar.setValue(mainProgressbar.getValue() + 1);
    }

    static {
        mainFrame = new JFrame();
        mirrors = new String[]{"https://repo.maven.apache.org/maven2", "https://maven.aliyun.com/repository/public", "http://mirrors.163.com/maven/repository/maven-public", "https://repo.huaweicloud.com/repository/maven", "http://mirrors.cloud.tencent.com/nexus/repository/maven-public"};
    }

    private static class LinkButton
    extends JButton {
        public LinkButton(String link) {
            this.setText("<HTML><FONT color=\"#000099\"><U>link</U></FONT></HTML>");
            this.addActionListener(actionEvent -> {
                if (actionEvent.getSource().equals(this)) {
                    if (Desktop.isDesktopSupported() && Desktop.getDesktop().isSupported(Desktop.Action.BROWSE)) {
                        try {
                            Desktop.getDesktop().browse(new URI(link));
                        }
                        catch (IOException | URISyntaxException e) {
                            Relauncher.LOGGER.error("Failed to open URL {}", (Object)link);
                        }
                    } else {
                        Runtime runtime = Runtime.getRuntime();
                        try {
                            runtime.exec("xdg-open " + link);
                        }
                        catch (IOException e) {
                            Relauncher.LOGGER.error("Failed to open URL {}", (Object)link);
                        }
                    }
                }
            });
        }
    }
}

