/*
 * Decompiled with CFR 0.152.
 */
package com.cleanroommc.relauncher;

import com.cleanroommc.relauncher.Relauncher;
import com.google.common.base.Strings;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import javax.annotation.Nonnull;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.SystemUtils;

public class JVMInfo {
    private File file = null;
    private int specification = 0;
    private String arch;
    private String version;
    private String vendor;

    public JVMInfo(@Nonnull String path) {
        if (Strings.isNullOrEmpty((String)path)) {
            return;
        }
        this.file = new File(path);
        ProcessBuilder builder = new ProcessBuilder(path, "-XshowSettings:properties");
        try {
            String line;
            Process p = builder.start();
            BufferedReader reader = new BufferedReader(new InputStreamReader(p.getErrorStream()));
            ArrayList<String> output = new ArrayList<String>();
            while ((line = reader.readLine()) != null) {
                output.add(line);
            }
            reader.close();
            for (String s : output) {
                if ((s = StringUtils.deleteWhitespace((String)s)).startsWith("java.specification.version=")) {
                    this.specification = (s = s.substring(s.indexOf("=") + 1)).startsWith("1.") ? Integer.parseInt(s.substring(s.indexOf(".") + 1)) : Integer.parseInt(s);
                }
                if (s.startsWith("java.version=")) {
                    this.version = s = s.substring(s.indexOf("=") + 1);
                }
                if (s.startsWith("java.vm.vendor=")) {
                    this.vendor = s = s.substring(s.indexOf("=") + 1);
                }
                if (s.startsWith("os.arch=")) {
                    this.arch = s = s.substring(s.indexOf("=") + 1);
                }
                if (!s.contains("options")) continue;
                break;
            }
        }
        catch (IOException e) {
            Relauncher.LOGGER.debug((Object)e);
        }
    }

    public File getFile() {
        return this.file;
    }

    public int getSpecification() {
        return this.specification;
    }

    public String getArch() {
        return this.arch;
    }

    public String getVersion() {
        return this.version;
    }

    public String getVendor() {
        return this.vendor;
    }

    public String toString() {
        return this.specification + "|" + this.arch + "|" + this.version + "|" + this.vendor;
    }

    public static JVMInfo getCurrent() {
        File binary;
        String bin = System.getProperty("java.home") + File.separatorChar + "bin" + File.separatorChar;
        if (SystemUtils.IS_OS_WINDOWS) {
            binary = new File(bin + "javaw.exe");
            if (!binary.exists()) {
                binary = new File(bin + "java.exe");
            }
        } else {
            binary = new File(bin + "java");
        }
        return new JVMInfo(binary.getAbsolutePath());
    }

    public static int getCurrentUpdateNumber() {
        String version = JVMInfo.getCurrent().getVersion();
        if (version.contains("_")) {
            return Integer.parseInt(version.split("_")[1]);
        }
        return 0;
    }
}

