/*
 * Decompiled with CFR 0.152.
 */
package com.cleanroommc.relauncher;

import com.cleanroommc.javautils.api.JavaInstall;
import com.cleanroommc.javautils.spi.JavaLocator;
import com.cleanroommc.relauncher.JVMInfo;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.ServiceLoader;

public class JavaDetector {
    private static final List<JavaInstall> javaInstalls = new ArrayList<JavaInstall>();

    public static List<JVMInfo> getInstalledJVMs() {
        ArrayList<JVMInfo> out = new ArrayList<JVMInfo>();
        HashSet<String> javaPaths = new HashSet<String>();
        if (javaInstalls.isEmpty()) {
            ServiceLoader<JavaLocator> providers = ServiceLoader.load(JavaLocator.class);
            for (JavaLocator locator : providers) {
                javaInstalls.addAll(locator.all());
            }
        }
        for (JavaInstall install : javaInstalls) {
            try {
                String path = install.executable(true).getCanonicalPath();
                if (javaPaths.contains(path)) continue;
                javaPaths.add(path);
                JVMInfo info = new JVMInfo(path);
                if (info.getSpecification() < 21) continue;
                out.add(info);
            }
            catch (IOException iOException) {}
        }
        return out;
    }
}

