/*
 * Decompiled with CFR 0.152.
 */
package com.cleanroommc.relauncher;

import com.cleanroommc.relauncher.Config;
import com.cleanroommc.relauncher.GUIUtils;
import com.cleanroommc.relauncher.MMCPackDownloader;
import com.cleanroommc.relauncher.Relauncher;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.function.Consumer;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JSeparator;
import javax.swing.JSpinner;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.SpinnerNumberModel;
import net.miginfocom.swing.MigLayout;
import net.minecraft.launchwrapper.Launch;
import net.minecraftforge.fml.ExitWrapper;
import org.apache.commons.io.FileUtils;
import org.apache.logging.log4j.Logger;

public class MMCInstaller {
    private static final JLabel mainStatusLabel = new JLabel();
    private static JButton confirmButton;
    private static final JFrame mainFrame;
    private static Consumer<Boolean> setInteractable;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void showGUI() {
        mainFrame.setLayout(new MigLayout());
        JLabel host = new JLabel("Proxy Host");
        JTextField proxyAddrTextField = new JTextField();
        proxyAddrTextField.setText(Config.proxyAddr);
        JLabel port = new JLabel("Proxy Port");
        JSpinner portSpinner = new JSpinner(new SpinnerNumberModel(0, 0, 65535, 1));
        portSpinner.setValue(Config.proxyPort);
        JCheckBox useLocalCheckbox = new JCheckBox("Use Local Pack");
        JSeparator jSeparator1 = new JSeparator(0);
        JSeparator jSeparator2 = new JSeparator(0);
        setInteractable = value -> {
            confirmButton.setEnabled((boolean)value);
            if (!value.booleanValue() || !useLocalCheckbox.isSelected()) {
                proxyAddrTextField.setEnabled((boolean)value);
                portSpinner.setEnabled((boolean)value);
            }
            useLocalCheckbox.setEnabled((boolean)value);
        };
        confirmButton = new JButton("Confirm");
        mainFrame.add((Component)useLocalCheckbox, "cell 0 0 2 1, grow, align center");
        GUIUtils.enlargeFont(useLocalCheckbox);
        useLocalCheckbox.setHorizontalAlignment(0);
        mainFrame.add((Component)jSeparator1, "cell 0 1 2 1, grow");
        mainFrame.add((Component)host, "cell 0 2, grow");
        GUIUtils.enlargeFont(host);
        mainFrame.add((Component)proxyAddrTextField, "cell 1 2, grow");
        GUIUtils.enlargeFont(proxyAddrTextField);
        proxyAddrTextField.setMinimumSize(new Dimension(200, 10));
        mainFrame.pack();
        mainFrame.add((Component)port, "cell 0 3, grow");
        GUIUtils.enlargeFont(port);
        mainFrame.add((Component)portSpinner, "cell 1 3, grow");
        GUIUtils.enlargeFont(portSpinner);
        portSpinner.setMinimumSize(new Dimension(200, 10));
        int width = port.getWidth() + portSpinner.getWidth();
        mainFrame.add((Component)mainStatusLabel, "cell 0 4 2 1, grow");
        mainStatusLabel.setHorizontalAlignment(0);
        GUIUtils.enlargeFont(mainStatusLabel);
        mainStatusLabel.setMinimumSize(new Dimension(width, 10));
        mainFrame.add((Component)jSeparator2, "cell 0 5 2 1, grow");
        jSeparator1.setMinimumSize(new Dimension(width, 0));
        jSeparator2.setMinimumSize(new Dimension(width, 0));
        mainFrame.add((Component)confirmButton, "cell 0 6 2 1, grow");
        GUIUtils.enlargeFont(confirmButton, 1, 20);
        confirmButton.setMinimumSize(new Dimension(width, 10));
        mainFrame.setTitle("Relauncher Initialization Settings");
        mainFrame.setDefaultCloseOperation(0);
        mainFrame.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent windowEvent) {
                ExitWrapper.exit(0);
            }
        });
        confirmButton.addActionListener(actionEvent -> {
            if (actionEvent.getSource().equals(confirmButton)) {
                setInteractable.accept(false);
                Config.useLocalPack = useLocalCheckbox.isSelected();
                Config.proxyAddr = proxyAddrTextField.getText();
                Config.proxyPort = (Integer)portSpinner.getValue();
                try {
                    Thread workingThread = new Thread(() -> {
                        try {
                            mainStatusLabel.setText("Installing Cleanroom...");
                            MMCPackDownloader.downloadAndExtract();
                            File packDir = new File(Relauncher.workingDir, "mmcpack").getAbsoluteFile();
                            File instance = Launch.minecraftHome.getParentFile();
                            Relauncher.LOGGER.info("Instance directory: {}", (Object)instance.getAbsolutePath());
                            File libraries = new File(instance, "libraries");
                            File patches = new File(instance, "patches");
                            libraries.mkdirs();
                            patches.mkdirs();
                            try {
                                FileUtils.copyDirectory((File)new File(packDir, "libraries"), (File)libraries);
                                FileUtils.copyDirectory((File)new File(packDir, "patches"), (File)patches);
                                FileUtils.copyFile((File)new File(packDir, "mmc-pack.json"), (File)new File(instance, "mmc-pack.json"));
                            }
                            catch (IOException e) {
                                throw new RuntimeException(e);
                            }
                            Relauncher.LOGGER.info("Install finished");
                            JDialog dialog = MMCInstaller.finishedDialog();
                            GUIUtils.setCentral(dialog);
                            dialog.setVisible(true);
                            Object object = Relauncher.o;
                            synchronized (object) {
                                Relauncher.o.wait();
                            }
                        }
                        catch (Throwable e) {
                            mainStatusLabel.setText(e.getMessage());
                        }
                        Config.save();
                        Object object = Relauncher.o;
                        synchronized (object) {
                            Relauncher.o.notify();
                        }
                    }, "MMC installation Working Thread");
                    workingThread.start();
                }
                catch (Throwable t) {
                    Relauncher.LOGGER.error(t.getMessage());
                    Arrays.stream(t.getStackTrace()).forEach(arg_0 -> ((Logger)Relauncher.LOGGER).info(arg_0));
                    Config.configFile.delete();
                    mainStatusLabel.setText(t.getMessage());
                    setInteractable.accept(true);
                }
            }
        });
        useLocalCheckbox.setToolTipText("Will use first Cleanroom-MMC-instance-*.zip in relauncher dir");
        useLocalCheckbox.setSelected(Config.useLocalPack);
        proxyAddrTextField.setText(Config.proxyAddr);
        portSpinner.setValue(Config.proxyPort);
        useLocalCheckbox.setToolTipText("Use the pack placed in /relauncher. Will disable proxy settings.");
        useLocalCheckbox.addItemListener(itemEvent -> {
            boolean selected = itemEvent.getStateChange() == 1;
            portSpinner.setEnabled(!selected);
            proxyAddrTextField.setEnabled(!selected);
        });
        proxyAddrTextField.setToolTipText("Proxy Address");
        proxyAddrTextField.setEnabled(!useLocalCheckbox.isSelected());
        portSpinner.setEnabled(!useLocalCheckbox.isSelected());
        portSpinner.setToolTipText("Proxy Port");
        portSpinner.setModel(new SpinnerNumberModel());
        mainStatusLabel.setText("Status: Idle");
        mainStatusLabel.setHorizontalAlignment(0);
        Relauncher.LOGGER.info("Launching GUI");
        mainFrame.validate();
        mainFrame.pack();
        mainFrame.setResizable(false);
        GUIUtils.setCentral(mainFrame);
        mainFrame.setVisible(true);
        Object object = Relauncher.o;
        synchronized (object) {
            try {
                Relauncher.o.wait();
            }
            catch (InterruptedException e) {
                Relauncher.LOGGER.error((Object)e);
            }
        }
    }

    private static JDialog finishedDialog() {
        JDialog dialog = new JDialog();
        JTextArea area = new JTextArea("MMC pack installation complete. After clicking the quit button, please:\n1. Switch your java in instance settings to Java 21+\n2. Make sure you have installed Scalar Legacy and Fugue");
        area.setFocusable(false);
        GUIUtils.enlargeFont(area, 1, 20);
        JButton quit = new JButton("Quit");
        GUIUtils.enlargeFont(quit, 1, 20);
        quit.setActionCommand("quit");
        quit.addActionListener(actionEvent -> {
            if (actionEvent.getActionCommand().equals("quit")) {
                ExitWrapper.exit(0);
            }
        });
        dialog.setDefaultCloseOperation(0);
        dialog.setLayout(new BorderLayout());
        dialog.add((Component)area, "North");
        dialog.add((Component)quit, "South");
        dialog.pack();
        dialog.setResizable(false);
        dialog.setAlwaysOnTop(true);
        return dialog;
    }

    static {
        mainFrame = new JFrame();
    }
}

