/*
 * Decompiled with CFR 0.152.
 */
package com.cleanroommc.relauncher;

import com.cleanroommc.relauncher.CleanroomVersionParser;
import com.cleanroommc.relauncher.Config;
import com.cleanroommc.relauncher.DownloadEntry;
import com.cleanroommc.relauncher.Downloader;
import com.cleanroommc.relauncher.Relauncher;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.StandardCopyOption;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.Optional;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.apache.commons.io.IOUtils;

public class MMCPackDownloader {
    public static void downloadAndExtract() throws IOException {
        File mmcDir = new File(Relauncher.workingDir, "mmcpack");
        File libraries = new File(mmcDir, "libraries");
        File universalJar = new File(libraries, "cleanroom-0.3.19-alpha-universal.jar");
        mmcDir.mkdir();
        File pack = new File(mmcDir, "mmcpack.zip");
        if (!pack.exists()) {
            if (!Config.useLocalPack) {
                String version = CleanroomVersionParser.getVersion();
                universalJar = new File(libraries, "cleanroom-" + version + "-universal.jar");
                Relauncher.LOGGER.info("Downloading MMC pack with version {}", (Object)version);
                ArrayList<DownloadEntry> list = new ArrayList<DownloadEntry>(1);
                list.add(new DownloadEntry(new URL("https://repo.cleanroommc.com/releases/com/cleanroommc/cleanroom/" + version + "/cleanroom-" + version + "-alpha.zip"), pack, ""));
                Downloader.downloadAll(list);
            } else if (Relauncher.workingDir.listFiles() != null) {
                Optional<File> packfile = Arrays.stream(Relauncher.workingDir.listFiles()).filter(file -> file.getName().startsWith("Cleanroom-MMC-instance-") && file.getName().endsWith(".zip")).findFirst();
                if (packfile.isPresent()) {
                    Relauncher.LOGGER.info("Found local pack {}", (Object)packfile.get());
                    Files.copy(packfile.get().toPath(), pack.toPath(), new CopyOption[0]);
                } else {
                    MMCPackDownloader.extractBundledZip(pack);
                }
            } else {
                MMCPackDownloader.extractBundledZip(pack);
            }
        }
        Relauncher.LOGGER.info("Extracting MMC pack");
        try (ZipFile zipFile = new ZipFile(pack);){
            Enumeration<? extends ZipEntry> entries = zipFile.entries();
            while (entries.hasMoreElements()) {
                ZipEntry entry = entries.nextElement();
                if (entry.getName().equals(".packignore") || entry.getName().equals("instance.cfg")) continue;
                if (entry.getName().endsWith("net.minecraftforge.json")) {
                    JsonObject modJson = new JsonParser().parse(IOUtils.toString((InputStream)zipFile.getInputStream(entry), (Charset)StandardCharsets.UTF_8)).getAsJsonObject();
                    modJson.getAsJsonArray("libraries").forEach(jsonElement -> {
                        String libraryName = jsonElement.getAsJsonObject().get("name").getAsString();
                        if (libraryName.startsWith("com.cleanroommc:cleanroom")) {
                            String version = libraryName.split(":")[2].replace("-universal", "");
                            CleanroomVersionParser.setVersion(version);
                            Relauncher.LOGGER.info("Extracting Cleanroom version {}", (Object)version);
                        }
                    });
                    universalJar = new File(libraries, "cleanroom-" + CleanroomVersionParser.getVersion() + "-universal.jar");
                }
                File entryDestination = new File(mmcDir, entry.getName());
                if (entry.isDirectory()) {
                    entryDestination.mkdirs();
                    continue;
                }
                entryDestination.getParentFile().mkdirs();
                InputStream in = zipFile.getInputStream(entry);
                Throwable throwable = null;
                try {
                    OutputStream out = Files.newOutputStream(entryDestination.toPath(), new OpenOption[0]);
                    Throwable throwable2 = null;
                    try {
                        IOUtils.copy((InputStream)in, (OutputStream)out);
                    }
                    catch (Throwable throwable3) {
                        throwable2 = throwable3;
                        throw throwable3;
                    }
                    finally {
                        if (out == null) continue;
                        if (throwable2 != null) {
                            try {
                                out.close();
                            }
                            catch (Throwable throwable4) {
                                throwable2.addSuppressed(throwable4);
                            }
                            continue;
                        }
                        out.close();
                    }
                }
                catch (Throwable throwable5) {
                    throwable = throwable5;
                    throw throwable5;
                }
                finally {
                    if (in == null) continue;
                    if (throwable != null) {
                        try {
                            in.close();
                        }
                        catch (Throwable throwable6) {
                            throwable.addSuppressed(throwable6);
                        }
                        continue;
                    }
                    in.close();
                }
            }
        }
        if (universalJar.exists()) {
            File universalTarget = new File(Relauncher.workingDir, universalJar.getName());
            Files.copy(universalJar.toPath(), universalTarget.toPath(), StandardCopyOption.REPLACE_EXISTING);
        }
    }

    private static void extractBundledZip(File pack) {
        Relauncher.LOGGER.info("Attempt to unzip");
        try {
            FileOutputStream out = new FileOutputStream(pack);
            InputStream in = Relauncher.class.getResourceAsStream("/mmcpack.zip");
            IOUtils.copy((InputStream)in, (OutputStream)out);
            out.close();
            in.close();
        }
        catch (IOException e) {
            Relauncher.LOGGER.error("Failed to unzip bundled mmc pack");
            Relauncher.LOGGER.error(e.getMessage());
            throw new RuntimeException(e);
        }
    }
}

