/*
 * Decompiled with CFR 0.152.
 */
package com.cleanroommc.relauncher;

import com.cleanroommc.relauncher.CleanroomVersionParser;
import com.cleanroommc.relauncher.Config;
import com.cleanroommc.relauncher.DownloadEntry;
import com.cleanroommc.relauncher.Downloader;
import com.cleanroommc.relauncher.Initializer;
import com.cleanroommc.relauncher.Relauncher;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.SystemUtils;
import org.apache.commons.lang3.tuple.Triple;

public class MMCPackParser {
    private static final String osArch = System.getProperty("os.arch");

    public static void parseMMCPack() throws IOException {
        String version = CleanroomVersionParser.getVersion();
        File mmcDir = new File(Relauncher.workingDir, "mmcpack");
        File universalJar = new File(new File(mmcDir, "libraries"), "cleanroom-" + version + "-universal.jar");
        File patches = new File(mmcDir, "patches");
        File vanillaJson = new File(patches, "net.minecraft.json");
        File moddedJson = new File(patches, "net.minecraftforge.json");
        File lwjglJson = new File(patches, "org.lwjgl3.json");
        mmcDir.mkdir();
        File universalTarget = new File(Relauncher.workingDir, universalJar.getName());
        String cp = "";
        if (universalJar.exists()) {
            Files.copy(universalJar.toPath(), universalTarget.toPath(), StandardCopyOption.REPLACE_EXISTING);
            cp = universalTarget.getAbsolutePath() + File.pathSeparator;
        }
        JsonObject vanilla = new JsonParser().parse(IOUtils.toString((Reader)Files.newBufferedReader(vanillaJson.toPath()))).getAsJsonObject();
        JsonObject modded = new JsonParser().parse(IOUtils.toString((Reader)Files.newBufferedReader(moddedJson.toPath()))).getAsJsonObject();
        JsonObject lwjgl = new JsonParser().parse(IOUtils.toString((Reader)Files.newBufferedReader(lwjglJson.toPath()))).getAsJsonObject();
        ArrayList<Triple<String, String, String>> result = new ArrayList<Triple<String, String, String>>(MMCPackParser.parseAndAddVanillaLibraries(vanilla));
        result.addAll(MMCPackParser.parseAndAddModdedLibraries(modded));
        result.addAll(MMCPackParser.parseAndAddLwjglLibraries(lwjgl));
        StringBuilder builder = new StringBuilder();
        Initializer.getMainProgressbar().setMaximum(result.size());
        Initializer.getMainProgressbar().setMinimum(0);
        ArrayList<DownloadEntry> entries = new ArrayList<DownloadEntry>();
        result.forEach(triple -> {
            DownloadEntry entry = new DownloadEntry((Triple<String, String, String>)triple);
            entries.add(entry);
            builder.append(entry.getDestination().getAbsolutePath()).append(File.pathSeparator);
        });
        Downloader.downloadAll(entries);
        Config.classPath = cp = cp + builder.toString();
    }

    private static List<Triple<String, String, String>> parseAndAddModdedLibraries(JsonObject o) {
        ArrayList<Triple<String, String, String>> result = new ArrayList<Triple<String, String, String>>();
        o.getAsJsonArray("libraries").forEach(jsonElement -> {
            JsonObject libraries = jsonElement.getAsJsonObject();
            if (libraries != null) {
                JsonElement downloads = libraries.getAsJsonObject().get("downloads");
                JsonElement name = libraries.getAsJsonObject().get("name");
                if (downloads != null && name != null) {
                    JsonObject artifact = downloads.getAsJsonObject().get("artifact").getAsJsonObject();
                    result.add(Triple.of((Object)name.getAsString(), (Object)artifact.get("url").getAsString(), (Object)artifact.get("sha1").getAsString()));
                }
            }
        });
        return result;
    }

    private static List<Triple<String, String, String>> parseAndAddVanillaLibraries(JsonObject o) {
        ArrayList<Triple<String, String, String>> result = new ArrayList<Triple<String, String, String>>();
        o.getAsJsonArray("libraries").forEach(jsonElement -> {
            JsonObject libraries = jsonElement.getAsJsonObject();
            if (libraries != null) {
                JsonElement downloads = libraries.getAsJsonObject().get("downloads");
                JsonElement name = libraries.getAsJsonObject().get("name");
                if (downloads != null && name != null && !name.getAsString().startsWith("ca.weblite")) {
                    JsonElement classifiers;
                    String mavenName = name.getAsString();
                    JsonObject artifact = downloads.getAsJsonObject().get("artifact").getAsJsonObject();
                    result.add(Triple.of((Object)mavenName, (Object)artifact.get("url").getAsString(), (Object)artifact.get("sha1").getAsString()));
                    if (mavenName.startsWith("com.mojang:text2speech") && (classifiers = downloads.getAsJsonObject().get("classifiers")) != null) {
                        if (SystemUtils.IS_OS_LINUX && osArch.contains("64") && !osArch.toLowerCase().contains("arm") && !osArch.toLowerCase().contains("aarch")) {
                            JsonElement linux = classifiers.getAsJsonObject().get("natives-linux");
                            result.add(Triple.of((Object)mavenName, (Object)linux.getAsJsonObject().get("url").getAsString(), (Object)linux.getAsJsonObject().get("sha1").getAsString()));
                            return;
                        }
                        if (SystemUtils.IS_OS_WINDOWS) {
                            JsonElement linux = classifiers.getAsJsonObject().get("natives-windows");
                            result.add(Triple.of((Object)mavenName, (Object)linux.getAsJsonObject().get("url").getAsString(), (Object)linux.getAsJsonObject().get("sha1").getAsString()));
                        }
                    }
                }
            }
        });
        return result;
    }

    private static List<Triple<String, String, String>> parseAndAddLwjglLibraries(JsonObject o) {
        ArrayList<Triple<String, String, String>> result = new ArrayList<Triple<String, String, String>>();
        String suffix = MMCPackParser.getLwjglSuffix();
        o.getAsJsonArray("libraries").forEach(jsonElement -> {
            JsonObject libraries = jsonElement.getAsJsonObject();
            if (libraries != null) {
                JsonElement downloads = libraries.getAsJsonObject().get("downloads");
                JsonElement name = libraries.getAsJsonObject().get("name");
                if (downloads != null && name != null) {
                    String mavenName = name.getAsString();
                    if (mavenName.split(":").length == 4 && !mavenName.endsWith(suffix)) {
                        return;
                    }
                    JsonObject artifact = downloads.getAsJsonObject().get("artifact").getAsJsonObject();
                    result.add(Triple.of((Object)mavenName, (Object)artifact.get("url").getAsString(), (Object)artifact.get("sha1").getAsString()));
                }
            }
        });
        return result;
    }

    private static String getLwjglSuffix() {
        String os = "";
        String arch = "";
        if (SystemUtils.IS_OS_WINDOWS) {
            os = "windows";
            if (!osArch.contains("64")) {
                arch = "x86";
            }
        } else if (SystemUtils.IS_OS_LINUX) {
            os = "linux";
        } else if (SystemUtils.IS_OS_MAC) {
            os = "macos";
        }
        if (osArch.toLowerCase().contains("arm") || osArch.contains("aarch")) {
            arch = "arm";
            arch = osArch.contains("64") ? arch + "64" : arch + "32";
        }
        String suffix = "natives-" + os;
        if (!arch.isEmpty()) {
            suffix = suffix + "-" + arch;
        }
        Relauncher.LOGGER.info("LWJGL suffix: {}, os.arch: {}", (Object)suffix, (Object)osArch);
        return suffix;
    }
}

