/*
 * Decompiled with CFR 0.152.
 */
package com.cleanroommc.relauncher;

import com.cleanroommc.relauncher.ArgumentGetter;
import com.cleanroommc.relauncher.Config;
import com.cleanroommc.relauncher.Initializer;
import com.cleanroommc.relauncher.MMCInstaller;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import javax.swing.UIManager;
import net.minecraft.launchwrapper.Launch;
import net.minecraftforge.fml.ExitWrapper;
import net.minecraftforge.fml.relauncher.IFMLLoadingPlugin;
import org.apache.commons.lang3.JavaVersion;
import org.apache.commons.lang3.SystemUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@IFMLLoadingPlugin.MCVersion(value="1.12.2")
public class Relauncher
implements IFMLLoadingPlugin {
    public static final File workingDir = new File(Launch.minecraftHome, "relauncher");
    public static final Logger LOGGER = LogManager.getLogger((String)"cleanroom_relauncher");
    static final Object o = new Object();

    public Relauncher() throws Throwable {
        if (!SystemUtils.isJavaVersionAtLeast((JavaVersion)JavaVersion.JAVA_9)) {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
            StackTraceElement[] stacks = Thread.currentThread().getStackTrace();
            if (Relauncher.isServer(stacks)) {
                return;
            }
            String entry = stacks[stacks.length - 1].getClassName();
            if (!workingDir.exists()) {
                workingDir.mkdirs();
            }
            LOGGER.info("Checking config");
            boolean configExists = Files.exists(new File(new File(Launch.minecraftHome, "config"), "cleanroom_relauncher.cfg").toPath(), new LinkOption[0]);
            if (configExists) {
                Config.syncConfig();
            } else {
                LOGGER.info("No config found, creating...");
            }
            if (entry.startsWith("org.prismlauncher") || entry.startsWith("org.multimc") || entry.startsWith("org.polymc")) {
                MMCInstaller.showGUI();
            } else {
                if (!Config.booted) {
                    Initializer.InitJavaAndArg();
                }
                Initializer.hideWindow();
                List<String> args = ArgumentGetter.getLaunchArgs();
                ProcessBuilder relaunch = new ProcessBuilder(args);
                try {
                    Process p = relaunch.directory(Launch.minecraftHome).inheritIO().start();
                    Config.booted = true;
                    Config.save();
                    Runtime.getRuntime().addShutdownHook(new Thread(p::destroy));
                    BufferedReader inputReader = new BufferedReader(new InputStreamReader(p.getInputStream()));
                    BufferedReader errorReader = new BufferedReader(new InputStreamReader(p.getErrorStream()));
                    while (p.isAlive()) {
                        String line;
                        while ((line = inputReader.readLine()) != null) {
                            LOGGER.info(line);
                        }
                        while ((line = errorReader.readLine()) != null) {
                            LOGGER.info(line);
                        }
                    }
                }
                catch (IOException e) {
                    LOGGER.info("Launch failed: ", (Throwable)e);
                    ExitWrapper.exit(1);
                }
            }
            ExitWrapper.exit(0);
        }
    }

    private static boolean isServer(StackTraceElement[] stack) {
        for (StackTraceElement e : stack) {
            if (!e.getClassName().equals("net.minecraftforge.fml.relauncher.ServerLaunchWrapper")) continue;
            return true;
        }
        return false;
    }

    public String[] getASMTransformerClass() {
        return null;
    }

    public String getModContainerClass() {
        return null;
    }

    @Nullable
    public String getSetupClass() {
        return null;
    }

    public void injectData(Map<String, Object> data) {
    }

    public String getAccessTransformerClass() {
        return null;
    }
}

