// --- ||  Play Swing Sound!  || --- //

if (swingProgress === 0) return;

let l = (bl ? 1 : 2);

let mainHandSoundSwingProgress = mainHandSwingProgress;
let offHandSoundSwingProgress = offHandSwingProgress;

global.prevMainHandSoundSwingProgress = 0;
global.prevOffHandSoundSwingProgress = 0;

global.mainHandSwingSoundStartFlag = false;
global.offHandSwingSoundStartFlag = false;

function isItemInList(item, itemString) {
    const entries = itemString.split(",").map(s => s.trim());

    for (const name of entries) {
        if (name.startsWith("tag:")) {
            const tagName = name.slice(4);
            let tag = null;

            try {
                if (tagName.startsWith("minecraft:")) {
                    tag = Tags.getVanillaTag(tagName.slice(10));
                } else if (tagName.includes(":")) {
                    tag = Tags.getTag(tagName);
                } else {
                    tag = Tags.getVanillaTag(tagName);
                }
            } catch (e) {
                tag = null;
            }

            if (tag && I.isIn(item, tag)) return true;
        } else {
            if (I.isOf(item, Items.get(name))) return true;
        }
    }

    return false;
}

// --- Table of sound conditions ---
const soundConditions = [
    { condition: () => I.isEmpty(item) && (${isHandEmpty} === 0 ? true : ${isHandEmpty}) },
    { condition: () => (
            I.isIn(item, Tags.getVanillaTag("swords")) ||
            I.isIn(item, Tags.getVanillaTag("axes")) ||
            I.getUseAction(item) === "spear" ||
            I.isOf(item, Items.get("minecraft:mace")) ||
            I.getUseAction(item) === "bow" ||
            I.getUseAction(item) === "crossbow"
        ) && (${isItemWeapon} === 0 ? true : ${isItemWeapon}) },
    { condition: () => (
            I.isIn(item, Tags.getVanillaTag("pickaxes")) ||
            I.isIn(item, Tags.getVanillaTag("axes")) ||
            I.isIn(item, Tags.getVanillaTag("shovels")) ||
            I.isIn(item, Tags.getVanillaTag("hoes"))
        ) && (${isItemTool} === 0 ? true : ${isItemTool}) },
    { condition: () => I.isBlock(item) && (${isItemBlock} === 0 ? true : ${isItemBlock}) },
    { condition: () => I.getUseAction(item) === "eat" && (${isItemFood} === 0 ? true : ${isItemFood}) },
    { condition: () => I.getUseAction(item) === "drink" && (${isItemDrink} === 0 ? true : ${isItemDrink}) }
];

// --- Cancel conditions ---
const cancelConditions = [
    { condition: () => "${enableSwingSound}".includes("Disabled") },
    { condition: () => l === 1 && !(${mainHandSwing} === 0 ? true : ${mainHandSwing}) },
    { condition: () => l === 2 && !(${offHandSwing} === 0 ? true : ${offHandSwing}) },
    { condition: () => blockBreaking && !(${isBreakingBlock} === 0 ? false : ${isBreakingBlock}) }
];

function playSwingSound() {
    // Global toggle (exact logic from Lua)
    const globalToggle = "${globalSwingSound}" === 0 ? true : ("${globalSwingSound}".includes("GLOBAL") ? true : false);

    let inIncluded = isItemInList(item, "${includedItems}") && (${toggleIncluded} == "0" ? false : ${toggleIncluded});
    let inExcluded = isItemInList(item, "${excludedItems}") && (${toggleExcluded} == "0" ? false : ${toggleExcluded});

    // Resolve inclusion/exclusion conflict
    if (inIncluded && inExcluded) {
        if ("${priorityOverMode}".includes("Included")) {
            inExcluded = false;
        } else {
            inIncluded = false;
        }
    }

    // Exclusion cancels everything
    if (inExcluded) return;

    for (const entry of cancelConditions) {
        const cond = typeof entry.condition === "function" ? entry.condition() : entry.condition;
        if (cond) return;
    }

    let inSoundConditions = false;
    for (const entry of soundConditions) {
        const cond = typeof entry.condition === "function" ? entry.condition() : entry.condition;
        if (cond || inIncluded) {
            inSoundConditions = true;
            break;
        }
    }

    const shouldPlay = globalToggle || inSoundConditions;
    if (!shouldPlay) return;

    const soundSwingProgress = [mainHandSoundSwingProgress, offHandSoundSwingProgress];
    const prevSoundSwingProgress = [prevMainHandSoundSwingProgress, prevOffHandSoundSwingProgress];
    const soundSwingFlag = [mainHandSwingSoundStartFlag, offHandSwingSoundStartFlag];

    const delta = soundSwingProgress[l - 1] - prevSoundSwingProgress[l - 1];

    if (delta < 0) {
        soundSwingFlag[l - 1] = true;
    }

    const swingSoundID =
        ("${swingSoundId}" == "0" ? "swing" : "${swingSoundId}");

    if (soundSwingFlag[l - 1] && delta > 0) {
        const vol = ${swingSoundVolume} == "0" ? 0.3 : ${swingSoundVolume};
        S.playSound(swingSoundID, vol);
        soundSwingFlag[l - 1] = false;
    }

    if (l === 1) {
        prevMainHandSoundSwingProgress = soundSwingProgress[0];
        mainHandSwingSoundStartFlag = soundSwingFlag[0];
    } else if (l === 2) {
        prevOffHandSoundSwingProgress = soundSwingProgress[1];
        offHandSwingSoundStartFlag = soundSwingFlag[1];
    }
}

playSwingSound();
