--- ||  Play Swing Sound!  || ---

if swingProgress == 0 then return end

local l = (bl and 1) or 2

local mainHandSoundSwingProgress = mainHandSwingProgress
local offHandSoundSwingProgress = offHandSwingProgress

global.prevMainHandSoundSwingProgress = 0;
global.prevOffHandSoundSwingProgress = 0;

global.mainHandSwingSoundStartFlag = false;
global.offHandSwingSoundStartFlag = false;

local function isItemInList(item, itemString)
    -- Split the string by comma and trim spaces
    local t = {}

    for s in string.gmatch(itemString, "([^,]+)") do
        table.insert(t, s:match("^%s*(.-)%s*$")) -- trim spaces
    end

	for _, name in ipairs(t) do
        if name == "0" then return end
        if name:sub(1,4) == "tag:" then
            local tagName = name:sub(5)
            local tag

            -- Vanilla tags always use getVanillaTag
            if tagName:sub(1,10) == "minecraft:" then
            	tag = Tags:getVanillaTag(tagName:sub(11)) -- Vanilla tags always use getVanillaTag
            elseif tagName:find(":") then
                -- Modded tag with namespace
                if pcall(function() tag = Tags:getTag(tagName) end) then
                    -- tag assigned
                else
                    tag = nil
                end
            else
                -- Vanilla tag without namespace
                tag = Tags:getVanillaTag(tagName)
            end
            if tag and I:isIn(item, tag) then
                return true
            end
        else
            -- normal item
            if I:isOf(item, Items:get(name)) then
                return true
            end
        end
    end
    return false
end

-- Table of conditions to play sound
local soundConditions = {
    { condition = function() return I:isEmpty(item) and (${isHandEmpty} == 0 and true or ${isHandEmpty}) end },
    { condition = function() return (
    	I:isIn(item, Tags:getVanillaTag("swords")) 
		or I:isIn(item, Tags:getVanillaTag("axes"))
		or I:getUseAction(item) == "spear"  
		or I:isOf(item, Items:get("minecraft:mace")) 
		or I:getUseAction(item) == "bow"
		or I:getUseAction(item) == "crossbow"
    	) and (${isItemWeapon} == 0 and true or ${isItemWeapon}) end },
    { condition = function() return (
		I:isIn(item, Tags:getVanillaTag("pickaxes"))
    	or I:isIn(item, Tags:getVanillaTag("axes"))
    	or I:isIn(item, Tags:getVanillaTag("shovels"))
    	or I:isIn(item, Tags:getVanillaTag("hoes"))
		) and ${isItemTool} end },
    { condition = function() return I:isBlock(item) and (${isItemBlock} == 0 and true or ${isItemBlock}) end },
    { condition = function() return I:getUseAction(item) == "eat" and (${isItemFood} == 0 and true or ${isItemFood}) end },
    { condition = function() return I:getUseAction(item) == "drink" and (${isItemDrink} == 0 and true or ${isItemDrink}) end }
}

local cancelConditions = {
    { condition = function() return ("${enableSwingSound}"):sub(4) == "Disabled" and true end },
    { condition = function() return l == 1 and not (${mainHandSwing} == 0 and true or ${mainHandSwing}) end },
    { condition = function() return l == 2 and not (${offHandSwing} == 0 and true or ${offHandSwing}) end },
    { condition = function() return blockBreaking and not (${isBreakingBlock} == 0 and false or ${isBreakingBlock}) end }
}

function playSwingSound()

    local globalToggle = ("${globalSwingSound}" == "0" and true or (("${globalSwingSound}"):sub(4) == "GLOBAL" and true or false))
	local inIncluded = isItemInList(item, "${includedItems}") and (${toggleIncluded} == 0 and false or ${toggleIncluded})
    local inExcluded = isItemInList(item, "${excludedItems}") and (${toggleExcluded} == 0 and false or ${toggleExcluded})

    -- Resolve conflict between lists
    if inIncluded and inExcluded then
        if ("${priorityOverMode}"):sub(4) == "Included" then
            inExcluded = false  -- ignore exclusion if include is prioritized
        else
            inIncluded = false  -- ignore inclusion if exclude is prioritized
        end
    end

    -- Apply exclusion first (it cancels everything else)
    if inExcluded then return end

	for _, entry in ipairs(cancelConditions) do
	    local cond = entry.condition
	    if type(cond) == "function" then cond = cond() end
	    if cond then return end -- cancel swing sound 
	end

    local inSoundConditions = false
    for _, entry in ipairs(soundConditions) do
    	local cond = entry.condition
    	if type(cond) == "function" then cond = cond() end
        if cond or inIncluded then 
        	inSoundConditions = true
       		break
       	end
    end

    -- Decide whether to play
    local shouldPlay = globalToggle or inSoundConditions

	if not shouldPlay then return end

	local soundSwingProgress = { mainHandSoundSwingProgress, offHandSoundSwingProgress }	
	local prevSoundSwingProgress = { prevMainHandSoundSwingProgress, prevOffHandSoundSwingProgress }
	local soundSwingFlag = { mainHandSwingSoundStartFlag, offHandSwingSoundStartFlag }

	local delta = soundSwingProgress[l] - prevSoundSwingProgress[l]

	-- Detect decrease (reset at end or interrupt)
	if delta < 0 then
		soundSwingFlag[l] = true 
	end

    local swingSoundID = ("${swingSoundId}" == "0" and "swing" or "${swingSoundId}")
    -- Play sound at the start of the increase (beginning of swing)
	if soundSwingFlag[l] and delta > 0 then
		S:playSound(swingSoundID, (${swingSoundVolume} == 0 and 0.3 or ${swingSoundVolume}))  -- Adjust to actual sword sound if needed
		soundSwingFlag[l] = false
    end

    -- Update the global variables
    if l == 1 then
        prevMainHandSoundSwingProgress = soundSwingProgress[1]
        mainHandSwingSoundStartFlag = soundSwingFlag[1]
    elseif l == 2 then
        prevOffHandSoundSwingProgress = soundSwingProgress[2]
        offHandSwingSoundStartFlag = soundSwingFlag[2]
    end
end

playSwingSound()