package io.wispforest.accessories;

import Z;
import io.wispforest.accessories.api.events.AllowEntityModificationCallback;
import io.wispforest.accessories.client.AccessoriesMenu;
import io.wispforest.accessories.compat.AccessoriesConfig;
import io.wispforest.accessories.criteria.AccessoryChangedCriterion;
import io.wispforest.accessories.impl.AccessoriesTags;
import io.wispforest.accessories.mixin.CriteriaTriggersAccessor;
import me.shedaniel.autoconfig.AutoConfig;
import me.shedaniel.autoconfig.ConfigHolder;
import me.shedaniel.autoconfig.serializer.JanksonConfigSerializer;
import net.fabricmc.fabric.api.util.TriState;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1675;
import net.minecraft.class_1799;
import net.minecraft.class_1928;
import net.minecraft.class_239;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_3917;
import net.minecraft.class_3966;
import net.minecraft.class_6025;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;

import java.util.function.Consumer;

public class Accessories {

    @ApiStatus.Internal
    public static class_1928.class_4313<class_1928.class_4310> RULE_KEEP_ACCESSORY_INVENTORY = null;

    public static final String MODID = "accessories";

    public static class_2960 of(String path){
        return new class_2960(MODID, path);
    }

    public static String translation(String path){
        return MODID + "." + path;
    }

    public static AccessoriesConfig getConfig(){
        if(CONFIG_HOLDER == null) return null;

        return CONFIG_HOLDER.getConfig();
    }

    public static void setAndSaveConfig(Consumer<AccessoriesConfig> consumer) {
        consumer.accept(getConfig());

        CONFIG_HOLDER.save();
    }

    public static boolean attemptOpenScreenPlayer(class_3222 player) {
        var result = class_1675.method_49998(player, e -> e instanceof class_1309, (player.method_7337() ? 4.5 : 4));

        if(!(result instanceof class_3966 entityHitResult)) return false;

        Accessories.openAccessoriesMenu(player, (class_1309) entityHitResult.method_17782());

        return true;
    }

    public static void openAccessoriesMenu(class_1657 player, @Nullable class_1309 targetEntity) {
        openAccessoriesMenu(player, targetEntity, null);
    }

    public static void openAccessoriesMenu(class_1657 player, @Nullable class_1309 targetEntity, @Nullable class_1799 carriedStack) {
        if(targetEntity != null) {
            var result = AllowEntityModificationCallback.EVENT.invoker().allowModifications(targetEntity, player, null);

            if(!result.orElse(false)) return;
        }

        AccessoriesInternals.openAccessoriesMenu(player, targetEntity, carriedStack);
    }

    //--

    @Nullable
    public static ConfigHolder<AccessoriesConfig> CONFIG_HOLDER = null;

    public static class_3917<AccessoriesMenu> ACCESSORIES_MENU_TYPE;

    public static AccessoryChangedCriterion ACCESSORY_EQUIPPED;
    public static AccessoryChangedCriterion ACCESSORY_UNEQUIPPED;

    public static void init() {
        CONFIG_HOLDER = AutoConfig.register(AccessoriesConfig.class, JanksonConfigSerializer::new);

        AllowEntityModificationCallback.EVENT.register((target, player, reference) -> {
            var type = target.method_5864();

            if(type.method_20210(AccessoriesTags.MODIFIABLE_ENTITY_BLACKLIST)) return TriState.FALSE;

            var isOwnersPet = (target instanceof class_6025 ownableEntity && ownableEntity.method_35057().equals(player));

            if(isOwnersPet || type.method_20210(AccessoriesTags.MODIFIABLE_ENTITY_WHITELIST)) return TriState.TRUE;

            return TriState.DEFAULT;
        });
    }

    public static void registerCriteria(){
        ACCESSORY_EQUIPPED = CriteriaTriggersAccessor.accessories$callRegister(new AccessoryChangedCriterion(Accessories.of("equip_accessory")));
        ACCESSORY_UNEQUIPPED = CriteriaTriggersAccessor.accessories$callRegister(new AccessoryChangedCriterion(Accessories.of("unequip_accessory")));
    }

    public static void registerMenuType() {
        ACCESSORIES_MENU_TYPE = AccessoriesInternals.registerMenuType(of("accessories_menu"), AccessoriesMenu::of);
    }
}