package io.wispforest.accessories;

import com.google.gson.JsonObject;
import com.mojang.brigadier.arguments.ArgumentType;
import dev.architectury.injectables.annotations.ExpectPlatform;
import io.wispforest.accessories.api.AccessoriesHolder;
import io.wispforest.accessories.client.AccessoriesMenuData;
import io.wispforest.accessories.networking.base.BaseNetworkHandler;
import org.apache.commons.lang3.function.TriFunction;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;

import java.util.Collection;
import java.util.Optional;
import java.util.function.UnaryOperator;
import net.minecraft.class_1304;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1799;
import net.minecraft.class_2314;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_3917;
import net.minecraft.class_6862;
import net.minecraft.class_6880;
import net.minecraft.class_7225;

/**
 * Util Class implemented though Architectury Plugin allowing for various access to platform specific way
 * of getting class instances
 */
@ApiStatus.Internal
public class AccessoriesInternals {

    @Nullable
    public static class_1304 INTERNAL_SLOT = null;

    @Nullable
    public static class_1304.class_1305 ACCESSORIES_TYPE = null;

    @ExpectPlatform
    public static boolean isDevelopmentEnv() {
        throw new AssertionError();
    }

    /**
     * @return {@link AccessoriesHolder} attached to a given {@link class_1309} based on the Platforms method for getting it
     */
    @ExpectPlatform
    public static AccessoriesHolder getHolder(class_1309 livingEntity){
        throw new AssertionError();
    }

    @ExpectPlatform
    public static void modifyHolder(class_1309 livingEntity, UnaryOperator<AccessoriesHolder> modifier){
        throw new AssertionError();
    }

    /**
     * @return {@link BaseNetworkHandler} based on the Platforms method for getting it
     */
    @ExpectPlatform
    public static BaseNetworkHandler getNetworkHandler(){
        throw new AssertionError();
    }

    //--

    @ExpectPlatform
    public static <T> Optional<Collection<class_6880<T>>> getHolder(class_6862<T> tagKey){
        throw new AssertionError();
    }

    @ExpectPlatform
    public static void giveItemToPlayer(class_3222 player, class_1799 stack){
        throw new AssertionError();
    }

    @ExpectPlatform
    public static boolean isValidOnConditions(JsonObject object, String dataType, class_2960 key, @Nullable class_7225.class_7874 registryLookup){
        throw new AssertionError();
    }

    @ExpectPlatform
    public static <T extends class_1703> class_3917<T> registerMenuType(class_2960 location, TriFunction<Integer, class_1661, AccessoriesMenuData, T> func){
        throw new AssertionError();
    }

    @ExpectPlatform
    public static <A extends ArgumentType<?>, T extends class_2314.class_7217<A>, I extends class_2314<A, T>> I registerCommandArgumentType(class_2960 location, Class<A> clazz, I info) {
        throw new AssertionError();
    }

    @ExpectPlatform
    public static void openAccessoriesMenu(class_1657 player, @Nullable class_1309 targetEntity, @Nullable class_1799 carriedStack) {
        throw new AssertionError();
    }
}
