package io.wispforest.accessories.api.attributes;

import io.wispforest.accessories.utils.AttributeUtils;
import it.unimi.dsi.fastutil.Pair;
import net.minecraft.class_1320;
import net.minecraft.class_1322;
import net.minecraft.class_2960;
import org.jetbrains.annotations.Nullable;

public record AttributeModificationData(@Nullable String slotPath, class_1320 attribute, class_1322 modifier) {

    public AttributeModificationData(class_1320 attribute, class_1322 modifier) {
        this(null, attribute, modifier);
    }

    @Override
    public class_1322 modifier() {
        if (this.slotPath == null) return modifier;

        var location = AttributeUtils.getLocation(modifier.method_6185())
                .method_45134((path) -> this.slotPath + "/" + path);

        var data = AttributeUtils.getModifierData(location);

        return new class_1322(data.second(), data.first(), modifier.method_6186(), modifier.method_6182());
    }

    @Override
    public String toString() {
        return "AttributeModifierInstance[" +
                "attribute=" + this.attribute + ", " +
                "modifier=" + this.modifier +
                "slotPath=" + (this.slotPath != null ? this.slotPath : "none") +
                ']';
    }
}
