package io.wispforest.accessories.api.client;

import io.wispforest.accessories.Accessories;
import io.wispforest.accessories.api.AccessoriesAPI;
import io.wispforest.accessories.api.components.AccessoriesDataComponents;
import io.wispforest.accessories.api.components.AccessoryRenderOverrideComponent;
import net.fabricmc.fabric.api.util.TriState;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import org.jetbrains.annotations.Nullable;

import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;

/**
 * Main class used to register and hold {@link AccessoryRenderer}'s. This contains a method to
 * reload all renders when a data reload occurs for the client combined with method to retrieve renders.
 */
public class AccessoriesRendererRegistry {

    private static final Map<class_1792, Supplier<AccessoryRenderer>> RENDERERS = new HashMap<>();

    private static final Map<class_1792, AccessoryRenderer> CACHED_RENDERERS = new HashMap<>();

    /**
     * Main method used to register an {@link class_1792} with a given {@link AccessoryRenderer}
     */
    public static void registerRenderer(class_1792 item, Supplier<AccessoryRenderer> renderer){
        RENDERERS.put(item, renderer);
    }

    /**
     * Method used to prevent default rendering for the given {@link class_1792}
     * <br/>
     * This should ONLY be used if ABSOLUTELY necessary
     */
    public static void registerNoRenderer(class_1792 item){
        RENDERERS.put(item, () -> null);
    }

    //--

    /**
     * @return Either the {@link AccessoryRenderer} bound to the item or the instance of the {@link DefaultAccessoryRenderer}
     */
    @Nullable
    public static AccessoryRenderer getRender(class_1799 stack){
        var shouldOverride = AccessoriesDataComponents.readOrDefault(AccessoriesDataComponents.RENDER_OVERRIDE, stack).defaultRenderOverride();

        if(shouldOverride != TriState.DEFAULT) {
            if(shouldOverride.get()) {
                return DefaultAccessoryRenderer.INSTANCE;
            } else if(AccessoriesAPI.getOrDefaultAccessory(stack.method_7909()) == AccessoriesAPI.defaultAccessory()) {
                return null;
            }
        }

        return getRender(stack.method_7909());
    }

    /**
     * @return Either the {@link AccessoryRenderer} bound to the item or the instance of the {@link DefaultAccessoryRenderer}
     */
    @Nullable
    public static AccessoryRenderer getRender(class_1792 item){
        var renderer = CACHED_RENDERERS.getOrDefault(item, DefaultAccessoryRenderer.INSTANCE);

        if(renderer == null && Accessories.getConfig().clientData.forceNullRenderReplacement) {
            renderer = DefaultAccessoryRenderer.INSTANCE;
        }

        return renderer;
    }

    public static void onReload() {
        CACHED_RENDERERS.clear();

        RENDERERS.forEach((item, supplier) -> CACHED_RENDERERS.put(item, supplier.get()));
    }
}