package io.wispforest.accessories.api.client;

import I;
import com.mojang.logging.LogUtils;
import io.wispforest.accessories.Accessories;
import io.wispforest.accessories.api.Accessory;
import io.wispforest.accessories.api.slot.SlotReference;
import io.wispforest.accessories.compat.AccessoriesConfig;
import io.wispforest.accessories.compat.AccessoriesConfig.RenderSlotTarget;
import org.slf4j.Logger;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import net.minecraft.class_1306;
import net.minecraft.class_1309;
import net.minecraft.class_1799;
import net.minecraft.class_310;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_4608;
import net.minecraft.class_572;
import net.minecraft.class_583;
import net.minecraft.class_7833;
import net.minecraft.class_811;

/**
 * Default Renderer for any {@link Accessory} that doesn't have a renderer registered.
 */
public class DefaultAccessoryRenderer implements AccessoryRenderer {

    private static final Logger LOGGER = LogUtils.getLogger();

    //--

    public static final DefaultAccessoryRenderer INSTANCE;

    private final Map<String, RenderHelper> slotToHelpers = new HashMap<>();

    public DefaultAccessoryRenderer(){
        slotToHelpers.putAll(DEFAULT_HELPERS);
    }

    /**
     * Registers a {@link RenderHelper} for a given slot name if not already registered
     */
    public static void registerHelper(String slotType, RenderHelper helper){
        var helpers = INSTANCE.slotToHelpers;

        if(!helpers.containsKey(slotType)){
            helpers.put(slotType, helper);
        } else {
            LOGGER.warn("[DefaultAccessoryRenderer] Unable to add to the main renderer instance due to a duplicate helper already exists!");
        }
    }

    @Override
    public <M extends class_1309> void render(class_1799 stack, SlotReference reference, class_4587 matrices, class_583<M> model, class_4597 multiBufferSource, int light, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch) {
        if (!(model instanceof class_572<? extends class_1309> humanoidModel)) return;

        var disabledTargetType = Accessories.getConfig().clientData.disabledDefaultRenders;

        for (var target : disabledTargetType) {
            if(reference.slotName().equals(target.slotType) && target.targetType.isValid(stack.method_7909())) return;
        }

        Consumer<class_4587> render = (poseStack) -> class_310.method_1551().method_1480().method_23178(stack, class_811.field_4319, light, class_4608.field_21444, poseStack, multiBufferSource, reference.entity().method_37908(), 0);

        var helper = slotToHelpers.get(reference.slotName());

        if(helper != null) helper.render(render, matrices, humanoidModel, reference);
    }

    @Override
    public boolean shouldRenderInFirstPerson(class_1306 arm, class_1799 stack, SlotReference reference) {
        var slotName = reference.slotName();

        return (slotName.equals("hand") || slotName.equals("wrist") || slotName.equals("ring")) && (reference.slot() % 2 == 0 ? arm == class_1306.field_6183 : arm == class_1306.field_6182);
    }

    public interface RenderHelper {
        <M extends class_1309> void render(Consumer<class_4587> renderCall, class_4587 matrices, class_572<M> humanoidModel, SlotReference reference);
    }

    //--

    private static final Map<String, RenderHelper> DEFAULT_HELPERS;

    static {
        DEFAULT_HELPERS = Map.ofEntries(
                Map.entry("face", new RenderHelper() {
                    @Override
                    public <M extends class_1309> void render(Consumer<class_4587> renderCall, class_4587 matrices, class_572<M> humanoidModel, SlotReference reference) {
                        AccessoryRenderer.transformToFace(matrices, humanoidModel.field_3398, Side.FRONT);
                        renderCall.accept(matrices);
                    }
                }),
                Map.entry("hat", new RenderHelper() {
                    @Override
                    public <M extends class_1309> void render(Consumer<class_4587> renderCall, class_4587 matrices, class_572<M> humanoidModel, SlotReference reference) {
                        AccessoryRenderer.transformToFace(matrices, humanoidModel.field_3398, Side.TOP);
                        matrices.method_22904(0, 0.25, 0);
                        for (int i = 0; i < reference.getStack().method_7947(); i++) {
                            renderCall.accept(matrices);
                            matrices.method_22904(0, 0.5, 0);
                        }
                    }
                }),
                Map.entry("back", new RenderHelper() {
                    @Override
                    public <M extends class_1309> void render(Consumer<class_4587> renderCall, class_4587 matrices, class_572<M> humanoidModel, SlotReference reference) {
                        AccessoryRenderer.transformToFace(matrices, humanoidModel.field_3391, Side.BACK);
                        matrices.method_22905(1.5f, 1.5f, 1.5f);
                        renderCall.accept(matrices);
                    }
                }),
                Map.entry("necklace", new RenderHelper() {
                    @Override
                    public <M extends class_1309> void render(Consumer<class_4587> renderCall, class_4587 matrices, class_572<M> humanoidModel, SlotReference reference) {
                        AccessoryRenderer.transformToModelPart(matrices, humanoidModel.field_3391, 0, 1, 1);
                        matrices.method_22904(0, -0.25, 0);
                        renderCall.accept(matrices);
                    }
                }),
                Map.entry("cape", new RenderHelper() {
                    @Override
                    public <M extends class_1309> void render(Consumer<class_4587> renderCall, class_4587 matrices, class_572<M> humanoidModel, SlotReference reference) {
                        AccessoryRenderer.transformToModelPart(matrices, humanoidModel.field_3391, 0, 1, -1);
                        matrices.method_22904(0, -0.25, 0);
                        renderCall.accept(matrices);
                    }
                }),
                Map.entry("ring", new RenderHelper() {
                    @Override
                    public <M extends class_1309> void render(Consumer<class_4587> renderCall, class_4587 matrices, class_572<M> humanoidModel, SlotReference reference) {
                        AccessoryRenderer.transformToModelPart(
                                matrices,
                                reference.slot() % 2 == 0 ? humanoidModel.field_3401 : humanoidModel.field_27433,
                                reference.slot() % 2 == 0 ? 1 : -1,
                                -1,
                                0
                        );
                        var offset = reference.slot() / 2;
                        matrices.method_22904(
                                (reference.slot() % 2 == 0 ? -1 : 1) * offset * -0.0001,
                                0.25 * (offset + 1),
                                0
                        );
                        matrices.method_22905(0.5f, 0.5f, 0.5f);
                        matrices.method_22907(class_7833.field_40716.rotationDegrees(90));
                        for (int i = 0; i < reference.getStack().method_7947(); i++) {
                            renderCall.accept(matrices);
                            matrices.method_22904(
                                    0,
                                    0,
                                    reference.slot() % 2 == 0 ? -0.5 : 0.5
                            );
                        }
                    }
                }),
                Map.entry("wrist", new RenderHelper() {
                    @Override
                    public <M extends class_1309> void render(Consumer<class_4587> renderCall, class_4587 matrices, class_572<M> humanoidModel, SlotReference reference) {
                        AccessoryRenderer.transformToModelPart(matrices, reference.slot() % 2 == 0 ? humanoidModel.field_3401 : humanoidModel.field_27433, 0, -0.5, 0);
                        matrices.method_22905(1.01f, 1.01f, 1.01f);
                        matrices.method_22907(class_7833.field_40716.rotationDegrees(90));
                        renderCall.accept(matrices);
                    }
                }),
                Map.entry("hand", new RenderHelper() {
                    @Override
                    public <M extends class_1309> void render(Consumer<class_4587> renderCall, class_4587 matrices, class_572<M> humanoidModel, SlotReference reference) {
                        AccessoryRenderer.transformToFace(matrices, reference.slot() % 2 == 0 ? humanoidModel.field_3401 : humanoidModel.field_27433, Side.BOTTOM);
                        matrices.method_22904(0, 0.25, 0);
                        matrices.method_22905(1.02f, 1.02f, 1.02f);
                        matrices.method_22907(class_7833.field_40716.rotationDegrees(90));
                        renderCall.accept(matrices);
                    }
                }),
                Map.entry("belt", new RenderHelper() {
                    @Override
                    public <M extends class_1309> void render(Consumer<class_4587> renderCall, class_4587 matrices, class_572<M> humanoidModel, SlotReference reference) {
                        AccessoryRenderer.transformToFace(matrices, humanoidModel.field_3391, Side.BOTTOM);
                        matrices.method_22905(1.01f, 1.01f, 1.01f);
                        renderCall.accept(matrices);
                    }
                }),
                Map.entry("anklet", new RenderHelper() {
                    @Override
                    public <M extends class_1309> void render(Consumer<class_4587> renderCall, class_4587 matrices, class_572<M> humanoidModel, SlotReference reference) {
                        AccessoryRenderer.transformToModelPart(matrices, reference.slot() % 2 == 0 ? humanoidModel.field_3392 : humanoidModel.field_3397, 0, -0.5, 0);
                        matrices.method_22905(1.01f, 1.01f, 1.01f);
                        renderCall.accept(matrices);
                    }
                }),
                Map.entry("shoes", new RenderHelper() {
                    @Override
                    public <M extends class_1309> void render(Consumer<class_4587> renderCall, class_4587 matrices, class_572<M> humanoidModel, SlotReference reference) {
                        matrices.method_22903();
                        AccessoryRenderer.transformToFace(matrices, humanoidModel.field_3392, Side.BOTTOM);
                        matrices.method_22904(0, 0.25, 0);
                        matrices.method_22905(1.02f, 1.02f, 1.02f);
                        renderCall.accept(matrices);
                        matrices.method_22909();
                        matrices.method_22903();
                        AccessoryRenderer.transformToFace(matrices, humanoidModel.field_3397, Side.BOTTOM);
                        matrices.method_22904(0, 0.25, 0);
                        matrices.method_22905(1.02f, 1.02f, 1.02f);
                        renderCall.accept(matrices);
                        matrices.method_22909();
                    }
                })
        );

        INSTANCE = new DefaultAccessoryRenderer();
    }
}
