package io.wispforest.accessories.api.client;

import io.wispforest.accessories.api.slot.SlotReference;
import net.minecraft.class_1309;
import net.minecraft.class_1799;
import net.minecraft.class_310;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_4608;
import net.minecraft.class_583;
import net.minecraft.class_811;

/**
 * Simple version of the {@link AccessoryRenderer} with a transformation method to adjust
 * a given item to certain part of the given {@link class_1309} then rendering the accessory
 * as an Item at the specified location and scale
 */
public interface SimpleAccessoryRenderer extends AccessoryRenderer {

    @Override
    default <M extends class_1309> void render(class_1799 stack, SlotReference reference, class_4587 matrices, class_583<M> model, class_4597 multiBufferSource, int light, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch){
        align(stack, reference, model, matrices);

        class_310.method_1551().method_1480().method_23178(stack, class_811.field_4319, light, class_4608.field_21444, matrices, multiBufferSource, reference.entity().method_37908(), 0);
    }

    /**
     * Method used to align the given matrices to the desired position and scale on the current {@link class_1309}
     * passed within the {@link #render} method.
     *
     * @param stack
     * @param reference
     * @param model
     * @param matrices
     * @param <M>
     */
    <M extends class_1309> void align(class_1799 stack, SlotReference reference, class_583<M> model, class_4587 matrices);

}