package io.wispforest.accessories.api.components;

import com.mojang.logging.LogUtils;
import io.wispforest.accessories.Accessories;
import io.wispforest.accessories.endec.NbtMapCarrier;
import io.wispforest.accessories.endec.format.nbt.NbtDeserializer;
import io.wispforest.accessories.endec.format.nbt.NbtEndec;
import io.wispforest.accessories.endec.format.nbt.NbtSerializer;
import io.wispforest.endec.Endec;
import io.wispforest.endec.SerializationAttribute;
import io.wispforest.endec.SerializationContext;
import io.wispforest.endec.impl.KeyedEndec;
import org.jetbrains.annotations.ApiStatus;
import org.slf4j.Logger;

import java.util.HashMap;
import java.util.Map;
import java.util.function.UnaryOperator;
import net.minecraft.class_1799;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2960;

public class AccessoriesDataComponents {

    private static final Logger LOGGER = LogUtils.getLogger();

    /*
     * {
     *   "id": "",
     *   "count": 1,
     *   "components": {
     *     "accessories:nested_accessories": {
     *       //..
     *     },
     *     "accessories:render_override": {
     *       //..
     *     },
     *     "accessories:slot_validation": {
     *       //..
     *     },
     *     "accessories:attributes": {
     *       //..
     *     },
     *     "accessories:stack_size": {
     *       //..
     *     },
     *   }
     * }
     */

    //Accessories.of("nested_accessories")
    public static final KeyedEndec<AccessoryNestContainerContents> NESTED_ACCESSORIES = AccessoryNestContainerContents.ENDEC
            .keyed(Accessories.of("nested_accessories").toString(), AccessoryNestContainerContents.EMPTY);

    //Accessories.of("render_override")
    public static final KeyedEndec<AccessoryRenderOverrideComponent> RENDER_OVERRIDE = AccessoryRenderOverrideComponent.ENDEC
            .keyed(Accessories.of("render_override").toString(), AccessoryRenderOverrideComponent.DEFAULT);

    //Accessories.of("slot_validation")
    public static final KeyedEndec<AccessorySlotValidationComponent> SLOT_VALIDATION = AccessorySlotValidationComponent.ENDEC
            .keyed(Accessories.of("slot_validation").toString(), AccessorySlotValidationComponent.EMPTY);

    //Accessories.of("attributes")
    public static final KeyedEndec<AccessoryItemAttributeModifiers> ATTRIBUTES = AccessoryItemAttributeModifiers.ENDEC
            .keyed(Accessories.of("attributes").toString(), AccessoryItemAttributeModifiers.EMPTY);

    //Accessories.of("stack_size")
    public static final KeyedEndec<AccessoryStackSizeComponent> STACK_SIZE = AccessoryStackSizeComponent.ENDEC
            .keyed(Accessories.of("stack_size").toString(), AccessoryStackSizeComponent.DEFAULT);

    public static final Endec<Map<class_2960, class_2520>> COMPONENTS_ENDEC = NbtEndec.COMPOUND.xmap(compoundTag -> {
        var map = new HashMap<class_2960, class_2520>();

        for (var key : compoundTag.method_10541()) {
            var location = class_2960.method_12829(key);

            if (location != null) map.put(location, compoundTag.method_10580(key));
        }

        return map;
    }, map -> {
        var compound = new class_2487();

        map.forEach((location, tag) -> compound.method_10566(location.toString(), tag));

        return compound;
    });

    public static final KeyedEndec<Map<class_2960, class_2520>> COMPONENTS_KEY = COMPONENTS_ENDEC.keyed("components", HashMap::new);

    @ApiStatus.Internal
    public static void init() {}

    public static <T> boolean has(KeyedEndec<T> keyedEndec, class_1799 stack) {
        var tag = stack.method_7969();

        if (tag != null) {
            var location = class_2960.method_12829(keyedEndec.key());

            if (location != null) return new NbtMapCarrier(tag).get(COMPONENTS_KEY).containsKey(location);
        }

        return false;
    }

    public static <T> T readOrDefault(KeyedEndec<T> keyedEndec, class_1799 stack) {
        var tag = stack.method_7969();

        if (tag != null) {
            var location = class_2960.method_12829(keyedEndec.key());

            if (location != null) {
                var carrier = new NbtMapCarrier(tag);

                var components = carrier
                        .get(COMPONENTS_KEY);

                var data = components.get(location);

                if (data != null) {
                    try {
                        return keyedEndec.endec().decodeFully(SerializationContext.attributes(new StackAttribute(stack.method_7972())), NbtDeserializer::of, data);
                    } catch (Exception e) {
                        LOGGER.warn("Unable to read the given component from the given stack: [Key: {}]", keyedEndec.key(), e);

                        components.remove(location);

                        carrier.put(SerializationContext.attributes(new StackAttribute(stack.method_7972())), COMPONENTS_KEY, components);
                    }
                }
            }
        }

        return keyedEndec.defaultValue();
    }

    public static <T> void write(KeyedEndec<T> keyedEndec, class_1799 stack, T data) {
        var carrier = new NbtMapCarrier(stack.method_7948());

        var components = carrier.get(COMPONENTS_KEY);

        var location = class_2960.method_12829(keyedEndec.key());

        if (location != null) {
            try {
                components.put(location, keyedEndec.endec().encodeFully(NbtSerializer::of, data));
            } catch (Exception e) {
                LOGGER.warn("Unable to write the given component from the given stack: [Key: {}]", keyedEndec.key(), e);
            }
        }

        carrier.put(COMPONENTS_KEY, components);
    }

    public static <T> void update(KeyedEndec<T> keyedEndec, class_1799 stack, UnaryOperator<T> operator) {
        write(keyedEndec, stack, operator.apply(readOrDefault(keyedEndec, stack)));
    }

    //--

    public record StackAttribute(class_1799 stack) implements SerializationAttribute.Instance {

        public static final SerializationAttribute.WithValue<StackAttribute> INSTANCE = SerializationAttribute.withValue("accessories:stack");

        @Override public SerializationAttribute attribute() { return INSTANCE; }
        @Override public Object value() { return this; }
    }
}
