package io.wispforest.accessories.api.components;

import io.wispforest.accessories.api.AccessoriesAPI;
import io.wispforest.accessories.api.Accessory;
import io.wispforest.accessories.api.AccessoryNest;
import io.wispforest.accessories.api.slot.SlotEntryReference;
import io.wispforest.accessories.api.slot.SlotReference;
import io.wispforest.accessories.endec.CodecUtils;
import io.wispforest.accessories.impl.AccessoryNestUtils;
import io.wispforest.endec.*;
import io.wispforest.endec.impl.StructEndecBuilder;
import io.wispforest.endec.impl.StructField;
import org.jetbrains.annotations.ApiStatus;

import java.util.*;
import net.minecraft.class_1799;
import net.minecraft.class_2487;

public final class AccessoryNestContainerContents {

    public static final AccessoryNestContainerContents EMPTY = new AccessoryNestContainerContents(class_1799.field_8037, List.of());

    public static final Endec<AccessoryNestContainerContents> ENDEC = new StructEndec<>() {
        private final StructField<AccessoryNestContainerContents, List<class_1799>> field = CodecUtils.ofCodec(class_1799.field_24671).listOf().fieldOf("accessories", AccessoryNestContainerContents::accessories);

        @Override
        public void encodeStruct(SerializationContext ctx, Serializer<?> serializer, Serializer.Struct struct, AccessoryNestContainerContents accessoryNestContainerContents) {
            field.encodeField(ctx, serializer, struct, accessoryNestContainerContents);
        }

        @Override
        public AccessoryNestContainerContents decodeStruct(SerializationContext ctx, Deserializer<?> deserializer, Deserializer.Struct struct) {
            var data = field.decodeField(ctx, deserializer, struct);

            return new AccessoryNestContainerContents(ctx.requireAttributeValue(AccessoriesDataComponents.StackAttribute.INSTANCE).stack(), data);
        }
    };

    //--

    private final AccessoryNest accessoryNest;
    private final class_1799 stack;

    private final List<class_1799> accessories;
    private final List<class_1799> defensiveCopies = new ArrayList<>();
    private class_2487 defensiveNbtData;

    //--

    public AccessoryNestContainerContents(class_1799 stack, List<class_1799> accessories) {
        this.accessoryNest = (AccessoryNest) AccessoriesAPI.getAccessory(stack.method_7909());
        this.stack = stack;

        this.accessories = accessories;

        for (var accessory : this.accessories) {
            defensiveCopies.add(accessory.method_7972());
        }

        if(stack.method_7985()) {
            this.defensiveNbtData = stack.method_7969().method_10553();
        }
    }

    private AccessoryNestContainerContents(AccessoryNestContainerContents contents, List<class_1799> accessories) {
        this.stack = contents.stack;

        this.accessoryNest = (AccessoryNest) AccessoriesAPI.getAccessory(stack.method_7909());

        this.accessories = accessories;
    }

    public boolean hasChangesOccured(class_1799 holderStack){
        var prevStacks = this.defensiveCopies;
        var currentStacks = this.accessories;

        for (int i = 0; i < prevStacks.size(); i++) {
            var currentStack = currentStacks.get(i);

            if(class_1799.method_7973(prevStacks.get(i), currentStack)) continue;

            accessoryNest.setInnerStack(holderStack, i, currentStack);
        }

        return true;
    }

    public final boolean isInvalid() {
        return !Objects.equals(stack.method_7969(), defensiveNbtData);
    }

    @ApiStatus.Internal
    public AccessoryNestContainerContents setStack(int index, class_1799 stack) {
        var accessories = new ArrayList<>(accessories());

        accessories.set(index, stack);

        return new AccessoryNestContainerContents(this, accessories);
    }

    public Map<class_1799, Accessory> getMap() {
        var map = new LinkedHashMap<class_1799, Accessory>();

        this.accessories().forEach(stack1 -> map.put(stack1, AccessoriesAPI.getOrDefaultAccessory(stack1)));

        return map;
    }

    public Map<SlotEntryReference, Accessory> getMap(SlotReference slotReference) {
        var map = new LinkedHashMap<SlotEntryReference, Accessory>();

        var innerStacks = this.accessories();

        for (int i = 0; i < innerStacks.size(); i++) {
            var innerStack = innerStacks.get(i);

            if (innerStack.method_7960()) continue;

            map.put(new SlotEntryReference(AccessoryNestUtils.create(slotReference, i), innerStack), AccessoriesAPI.getOrDefaultAccessory(innerStack));
        }

        return map;
    }

    public List<class_1799> accessories() {
        return accessories;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == this) return true;
        if (obj == null || obj.getClass() != this.getClass()) return false;
        var that = (AccessoryNestContainerContents) obj;
        return Objects.equals(this.accessories, that.accessories);
    }

    @Override
    public int hashCode() {
        return Objects.hash(accessories);
    }

    @Override
    public String toString() {
        return "AccessoryNestContainerContents[" +
                "accessories=" + accessories + ']';
    }

}
