package io.wispforest.accessories.api.events.extra;

import io.wispforest.accessories.api.slot.SlotReference;
import net.fabricmc.fabric.api.event.Event;
import net.fabricmc.fabric.api.event.EventFactory;
import net.fabricmc.fabric.api.util.TriState;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1799;
import net.minecraft.class_5635;

/**
 * Event callback used to adjust the given {@link class_5635#method_32355(class_1297)}s method calls return
 * either allowing or denying the ability to walk on powder snow
 * <p/>
 * This is called within {@link ExtraEventHandler#allowWalkingOnSnow(class_1309)}
 * if any given Accessory was found to implement this interface and/or any registered callback
 * to the {@link AllowWalkingOnSnow#EVENT} returns an adjustment
 */
public interface AllowWalkingOnSnow {

    Event<AllowWalkingOnSnow> EVENT = EventFactory.createArrayBacked(AllowWalkingOnSnow.class, invokers -> (stack, reference) -> {
        for (var invoker : invokers) {
            var state = invoker.allowWalkingOnSnow(stack, reference);

            if(state != TriState.DEFAULT) return state;
        }

        return TriState.DEFAULT;
    });

    /**
     * @param stack     The specific stack being evaluated
     * @param reference The reference to the specific location within the Accessories Inventory
     * @return If the given entity should be able to walk on snow
     */
    TriState allowWalkingOnSnow(class_1799 stack, SlotReference reference);
}
