package io.wispforest.accessories.api.events.extra;

import io.wispforest.accessories.api.slot.SlotReference;
import net.fabricmc.fabric.api.event.Event;
import net.fabricmc.fabric.api.event.EventFactory;
import net.fabricmc.fabric.api.util.TriState;
import net.minecraft.class_1309;
import net.minecraft.class_1560;
import net.minecraft.class_1657;
import net.minecraft.class_1799;

/**
 * Event callback used to adjust the given {@link class_1560#method_7026(class_1657)}s method calls return
 * either indicating the user is masked or not
 * <p/>
 * This is called within {@link ExtraEventHandler#isEndermanMask(class_1309, class_1560)} (LivingEntity)}
 * if any given Accessory was found to implement this interface and/or any registered callback
 * to the {@link EndermanMasked#EVENT} returns an adjustment
 */
public interface EndermanMasked {

    Event<EndermanMasked> EVENT = EventFactory.createArrayBacked(EndermanMasked.class, invokers -> (enderMan, stack, reference) -> {
        for (var invoker : invokers) {
            var state = invoker.isEndermanMasked(enderMan, stack, reference);

            if(state != TriState.DEFAULT) return state;
        }

        return TriState.DEFAULT;
    });

    /**
     * @param enderMan  The specific {@link class_1560} for the given check
     * @param stack     The specific stack being evaluated
     * @param reference The reference to the specific location within the Accessories Inventory
     * @return If the given enderman sees a mask on the given passed referenced entity
     */
    TriState isEndermanMasked(class_1560 enderMan, class_1799 stack, SlotReference reference);
}
