package io.wispforest.accessories.api.events.extra;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import io.wispforest.accessories.api.AccessoriesAPI;
import io.wispforest.accessories.api.AccessoriesCapability;
import io.wispforest.accessories.api.Accessory;
import io.wispforest.accessories.api.slot.SlotEntryReference;
import io.wispforest.accessories.api.slot.SlotReference;
import net.fabricmc.fabric.api.util.TriState;
import net.minecraft.class_1282;
import net.minecraft.class_1309;
import net.minecraft.class_1560;
import net.minecraft.class_1799;
import net.minecraft.class_181;
import net.minecraft.class_47;
import java.time.Duration;
import java.util.HashMap;
import java.util.Map;

/**
 * Choice Events implemented for use on {@link io.wispforest.accessories.api.Accessory} when needed
 */
public class ExtraEventHandler {

    public static int lootingAdjustments(class_1309 entity, class_1282 damageSource, int currentLevel){
        if(damageSource != null && damageSource.method_5529() instanceof class_1309 targetEntity){
            var capability = AccessoriesCapability.get(entity);

            if(capability != null){
                for (var entryRef : capability.getAllEquipped()) {
                    var reference = entryRef.reference();
                    var stack = entryRef.stack();

                    var accessory = AccessoriesAPI.getAccessory(stack);

                    if(accessory instanceof LootingAdjustment lootingAdjustment){
                        currentLevel += lootingAdjustment.getLootingAdjustment(stack, reference, targetEntity, damageSource, currentLevel);
                    }

                    currentLevel += LootingAdjustment.EVENT.invoker().getLootingAdjustment(stack, reference, targetEntity, damageSource, currentLevel);
                }
            }
        }

        return currentLevel;
    }

    public static int fortuneAdjustment(class_47 context, int currentLevel){
        if(context.method_296(class_181.field_1226) instanceof class_1309 livingEntity) {
            var capability = AccessoriesCapability.get(livingEntity);

            if (capability != null) {
                for (var entryRef : capability.getAllEquipped()) {
                    var reference = entryRef.reference();
                    var stack = entryRef.stack();

                    var accessory = AccessoriesAPI.getAccessory(stack);

                    if (accessory instanceof FortuneAdjustment fortuneAdjustment) {
                        currentLevel += fortuneAdjustment.getFortuneAdjustment(stack, reference, context, currentLevel);
                    }

                    currentLevel += FortuneAdjustment.EVENT.invoker().getFortuneAdjustment(stack, reference, context, currentLevel);
                }
            }
        }

        return currentLevel;
    }

    public static TriState isPiglinsNeutral(class_1309 entity){
        var state = TriState.DEFAULT;

        var capability = AccessoriesCapability.get(entity);

        if(capability != null){
            for (var entryRef : capability.getAllEquipped()) {
                var reference = entryRef.reference();
                var stack = entryRef.stack();

                var accessory = AccessoriesAPI.getAccessory(stack);

                if(accessory instanceof PiglinNeutralInducer inducer){
                    state = inducer.makePiglinsNeutral(stack, reference);

                    if(state != TriState.DEFAULT) return state;
                }

                state = PiglinNeutralInducer.EVENT.invoker().makePiglinsNeutral(stack, reference);

                if(state != TriState.DEFAULT) return state;
            }
        }

        return state;
    }

    public static TriState allowWalkingOnSnow(class_1309 entity){
        var state = TriState.DEFAULT;

        var capability = AccessoriesCapability.get(entity);

        if(capability != null){
            for (var entryRef : capability.getAllEquipped()) {
                var reference = entryRef.reference();
                var stack = entryRef.stack();

                var accessory = AccessoriesAPI.getAccessory(stack);

                if(accessory instanceof AllowWalkingOnSnow event){
                    state = event.allowWalkingOnSnow(stack, reference);

                    if(state != TriState.DEFAULT) return state;
                }

                state = AllowWalkingOnSnow.EVENT.invoker().allowWalkingOnSnow(stack, reference);

                if(state != TriState.DEFAULT) return state;
            }
        }

        return state;
    }

    private static final LoadingCache<Integer, Map<Integer, TriState>> endermanAngyCacheResults = CacheBuilder.newBuilder()
            .concurrencyLevel(1)
            .expireAfterAccess(Duration.ofSeconds(1))
            //.maximumSize(1000)
            .weakKeys()
            .build(CacheLoader.from(() -> new HashMap<>()));

    public static TriState isEndermanMask(class_1309 entity, class_1560 enderMan){
        var cache = endermanAngyCacheResults.getIfPresent(entity.method_5628());

        if(cache != null && cache.containsKey(enderMan.method_5628())) return cache.get(enderMan.method_5628());

        var state = TriState.DEFAULT;
        var capability = AccessoriesCapability.get(entity);

        if(capability != null) {
            for (var entryRef : capability.getAllEquipped()) {
                var reference = entryRef.reference();
                var stack = entryRef.stack();

                var accessory = AccessoriesAPI.getAccessory(stack);

                if(accessory instanceof EndermanMasked masked){
                    state = masked.isEndermanMasked(enderMan, stack, reference);

                    if(state != TriState.DEFAULT) return state;
                }

                state = EndermanMasked.EVENT.invoker().isEndermanMasked(enderMan, stack, reference);

                if(state != TriState.DEFAULT) return state;
            }
        }

        endermanAngyCacheResults.getUnchecked(entity.method_5628())
                .put(enderMan.method_5628(), state);

        return state;
    }
}