package io.wispforest.accessories.api.events.extra;

import I;
import io.wispforest.accessories.api.slot.SlotReference;
import net.fabricmc.fabric.api.event.Event;
import net.fabricmc.fabric.api.event.EventFactory;
import net.minecraft.class_1282;
import net.minecraft.class_1309;
import net.minecraft.class_1799;

/**
 * Event callback used to adjust the given {@link class_1309}s looting amount from the {@link class_1309#method_16080} method
 * <p/>
 * This is called within {@link ExtraEventHandler#lootingAdjustments(class_1309, class_1282, int)}
 * if any given Accessory was found to implement this interface and/or any registered callback
 * to the {@link LootingAdjustment#EVENT} returns an adjustment
 */
public interface LootingAdjustment {

    Event<LootingAdjustment> EVENT = EventFactory.createArrayBacked(LootingAdjustment.class, invokers -> (stack, reference, target, damageSource, currentLevel) -> {
        var additionalLevels = 0;

        for (var invoker : invokers) {
            additionalLevels += invoker.getLootingAdjustment(stack, reference, target, damageSource, additionalLevels + currentLevel);
        }

        return additionalLevels;
    });

    /**
     * @param stack        The stack being evaluated
     * @param reference    The reference to the specific location within the Accessories Inventory
     * @param target       The given target entity for which the attack occurred on
     * @param damageSource The specific source of damage used against the target
     * @param currentLevel The current level that has been calculated so far
     * @return The given looting adjustment for the given stack
     */
    int getLootingAdjustment(class_1799 stack, SlotReference reference, class_1309 target, class_1282 damageSource, int currentLevel);
}
