package io.wispforest.accessories.api.menu;

import com.mojang.datafixers.util.Pair;
import com.mojang.logging.LogUtils;
import io.wispforest.accessories.Accessories;
import io.wispforest.accessories.api.AccessoriesAPI;
import io.wispforest.accessories.api.AccessoriesCapability;
import io.wispforest.accessories.api.AccessoriesContainer;
import io.wispforest.accessories.api.Accessory;
import io.wispforest.accessories.api.events.AllowEntityModificationCallback;
import io.wispforest.accessories.api.slot.SlotReference;
import io.wispforest.accessories.api.slot.SlotType;
import io.wispforest.accessories.data.EntitySlotLoader;
import io.wispforest.accessories.impl.ExpandedSimpleContainer;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.fabricmc.fabric.api.util.TriState;
import net.minecraft.class_124;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1735;
import net.minecraft.class_1799;
import net.minecraft.class_2561;
import net.minecraft.class_2960;

/**
 * Base slot class implementation for Accessories with static methods that force checks if
 * the passed entity and type can be found. Primarily used with internal screen and
 * with the {@link AccessoriesSlotGenerator} for unique slots API
 */
public class AccessoriesBasedSlot extends class_1735 {

    private static final Logger LOGGER = LogUtils.getLogger();

    public final class_1309 entity;
    public final AccessoriesContainer accessoriesContainer;

    public AccessoriesBasedSlot(AccessoriesContainer accessoriesContainer, ExpandedSimpleContainer container, int slot, int x, int y) {
        super(container, slot, x, y);

        this.accessoriesContainer = accessoriesContainer;
        this.entity = accessoriesContainer.capability().entity();
    }

    @Nullable
    public static AccessoriesBasedSlot of(class_1309 livingEntity, SlotType slotType, int x, int y) {
        return of(livingEntity, slotType, 0, x, y);
    }

    @Nullable
    public static AccessoriesBasedSlot of(class_1309 livingEntity, SlotType slotType, int slot, int x, int y) {
        var capability = livingEntity.accessoriesCapability();

        if(capability == null) {
            LOGGER.error("Unable to locate a capability for the given livingEntity meaning it does not have a valid Accessory Inventory [EntityType: {}]", livingEntity.method_5864());

            return null;
        }

        var validEntitySlots = EntitySlotLoader.getEntitySlots(livingEntity);

        if(!validEntitySlots.containsKey(slotType.name())) {
            LOGGER.error("Unable to create Accessory Slot due to the given LivingEntity not having the given SlotType bound to it! [EntityType: {}, SlotType: {}]", livingEntity.method_5864(), slotType.name());

            return null;
        }

        var container = capability.getContainer(slotType);

        if(container == null){
            LOGGER.error("Unable to locate the given container for the passed slotType. [SlotType:{}]", slotType.name());

            return null;
        }

        return new AccessoriesBasedSlot(container, container.getAccessories(), slot, x, y);
    }

    @Override
    @Deprecated
    public int method_7675() {
        // TODO: API TO LIMIT IDK
        return super.method_7675();
    }

    @Override
    public int method_7676(class_1799 stack) {
        var accessory = AccessoriesAPI.getOrDefaultAccessory(stack);

        return accessory.maxStackSize(stack);
    }

    @Override
    public void method_7673(class_1799 stack) {
        super.method_7673(stack);
    }

    @Override
    public boolean method_7680(class_1799 stack) {
        return AccessoriesAPI.canInsertIntoSlot(stack, SlotReference.of(this.entity, this.accessoriesContainer.getSlotName(), this.method_34266()));
    }

    @Override
    public boolean method_7674(class_1657 player) {
        if(!this.entity.equals(player)/*this.entity != player*/) {
            var ref = this.accessoriesContainer.createReference(this.method_34266());

            var result = AllowEntityModificationCallback.EVENT.invoker().allowModifications(this.entity, player, ref);

            if(!result.orElse(false)) return false;
        }

        return AccessoriesAPI.canUnequip(this.method_7677(), SlotReference.of(this.entity, this.accessoriesContainer.getSlotName(), this.method_34266()));
    }

    protected class_2960 icon(){
        var slotType = this.accessoriesContainer.slotType();

        return slotType != null ? slotType.icon() : SlotType.EMPTY_SLOT_ICON;
    }

    public List<class_2561> getTooltipData() {
        var tooltipData = new ArrayList<class_2561>();

        var slotType = this.accessoriesContainer.slotType();

        tooltipData.add(class_2561.method_43471(Accessories.translation( "slot.tooltip.singular"))
                .method_27692(class_124.field_1080)
                .method_10852(class_2561.method_43471(slotType.translation()).method_27692(class_124.field_1078)));

        return tooltipData;
    }

    @Nullable
    @Override
    public Pair<class_2960, class_2960> method_7679() {
        // Thanks to mojang you can not access the GUI atlas from this call and you must use Atlases from ModelManager.
        // )::::::::::::::::::::::::::::::

        return new Pair<>(new class_2960("textures/atlas/blocks.png"), icon());
    }
}
