package io.wispforest.accessories.api.slot;

import io.wispforest.accessories.Accessories;
import it.unimi.dsi.fastutil.Pair;
import java.util.Set;
import net.minecraft.class_2561;
import net.minecraft.class_2960;

/**
 * A Group of {@link SlotType}'s based on name used to cosmetically
 * group them together for the UI
 */
public interface SlotGroup {

    class_2960 UNKNOWN = Accessories.of("gui/group/unknown");

    /**
     * @return The name of the given group
     */
    String name();

    /**
     * @return The {@link class_2561} Translation key for the given group
     */
    default String translation(){
        return Accessories.translation("slot_group." + name());
    }

    /**
     * @return The priority order for the given group
     */
    int order();

    /**
     * @return All slot names bound to the given group
     */
    Set<String> slots();

    /**
     * @return The location for the given icon within the Block Atlas for the given slot group
     */
    class_2960 icon();
}
