package io.wispforest.accessories.api.slot;

import com.google.common.collect.ImmutableList;
import io.wispforest.accessories.api.AccessoriesCapability;
import io.wispforest.accessories.api.AccessoriesContainer;
import io.wispforest.accessories.api.Accessory;
import io.wispforest.accessories.api.AccessoryNest;
import io.wispforest.accessories.data.SlotTypeLoader;
import io.wispforest.endec.Endec;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;

import java.util.List;
import java.util.UUID;
import net.minecraft.class_1309;
import net.minecraft.class_1799;

/**
 * A reference to a specific accessory slot of a {@link class_1309}.
 */
public sealed interface SlotReference permits NestedSlotReferenceImpl, SlotReferenceImpl {

    static SlotReference of(class_1309 livingEntity, String slotName, int slot) {
        return new SlotReferenceImpl(livingEntity, slotName, slot);
    }

    static SlotReference ofNest(class_1309 livingEntity, String slotName, int initialHolderSlot, List<Integer> innerSlotIndices) {
        return new NestedSlotReferenceImpl(livingEntity, slotName, initialHolderSlot, ImmutableList.copyOf(innerSlotIndices));
    }

    /**
     * @return the referenced slot name
     */
    String slotName();

    /**
     * @return the referenced entity
     */
    class_1309 entity();

    /**
     * @return the referenced slot index
     */
    int slot();

    //--

    default boolean isValid() {
        var capability = this.capability();

        if(capability == null) return false;

        var container = capability.getContainers().get(this.slotName());

        if(container == null) return false;

        return slot() < container.getSize();
    }

    default String createSlotPath() {
        return this.slotName().replace(":", "-") + "/" + this.slot();
    }

    @Nullable
    default SlotType type(){
        return SlotTypeLoader.getSlotType(entity().method_37908(), slotName());
    }

    @Nullable
    default AccessoriesCapability capability() {
        return this.entity().accessoriesCapability();
    }

    @Nullable
    default AccessoriesContainer slotContainer() {
        var capability = this.capability();

        if(capability == null) return null;

        return capability.getContainers().get(slotName());
    }

    /**
     * @return the current referenced stack
     */
    @Nullable
    default class_1799 getStack() {
        var container = this.slotContainer();

        if(container == null) return null;

        return container.getAccessories().method_5438(slot());
    }

    /**
     * @return {@code true} if the stack was successfully set, {@code false} otherwise
     */
    default boolean setStack(class_1799 stack) {
        var container = this.slotContainer();

        if(container == null) return false;

        container.getAccessories().method_5447(slot(), stack);

        return true;
    }
}
