package io.wispforest.accessories.client;

import Z;
import io.wispforest.accessories.Accessories;
import io.wispforest.accessories.AccessoriesInternals;
import io.wispforest.accessories.AccessoriesInternalsClient;
import io.wispforest.accessories.api.AccessoriesAPI;
import io.wispforest.accessories.api.AccessoriesHolder;
import io.wispforest.accessories.api.client.AccessoriesRendererRegistry;
import io.wispforest.accessories.compat.AccessoriesConfig;
import io.wispforest.accessories.data.EntitySlotLoader;
import io.wispforest.accessories.networking.holder.HolderProperty;
import io.wispforest.accessories.networking.holder.SyncHolderChange;
import io.wispforest.accessories.networking.server.ScreenOpen;
import java.util.Collection;
import net.fabricmc.fabric.api.event.Event;
import net.fabricmc.fabric.api.event.EventFactory;
import net.minecraft.class_1041;
import net.minecraft.class_1269;
import net.minecraft.class_1309;
import net.minecraft.class_1675;
import net.minecraft.class_239;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3966;
import net.minecraft.class_5944;
import net.minecraft.class_746;

public class AccessoriesClient {

    public static final class_2960 BLIT_SHADER_ID = Accessories.of("fish");
    public static class_5944 BLIT_SHADER;

    public static final Event<WindowResizeCallback> WINDOW_RESIZE_CALLBACK_EVENT = EventFactory.createArrayBacked(WindowResizeCallback.class, callbacks -> (client, window) -> {
        for (var callback : callbacks) callback.onResized(client, window);
    });

    public static boolean IS_PLAYER_INVISIBLE = false;

    public static void init(){
        AccessoriesInternalsClient.registerToMenuTypes();

        Accessories.CONFIG_HOLDER.registerSaveListener((manager, data) -> {
            handleConfigChangesSync(data);

            return class_1269.field_5812;
        });

        Accessories.CONFIG_HOLDER.registerLoadListener((manager, data) -> {
            handleConfigChangesSync(data);

            return class_1269.field_5812;
        });

        ClientLifecycleEvents.END_DATA_PACK_RELOAD.register((client, success) -> {
            if (!success) return;

            AccessoriesRendererRegistry.onReload();
        });
    }

    public static void handleConfigChangesSync(AccessoriesConfig config) {
        var currentPlayer = class_310.method_1551().field_1724;

        if(currentPlayer == null || class_310.method_1551().field_1687 == null) return;

        var holder = currentPlayer.accessoriesHolder();

        if(holder == null) return;

        if(holder.showUniqueSlots() && !config.clientData.showUniqueRendering) {
            AccessoriesInternals.getNetworkHandler().sendToServer(SyncHolderChange.of(HolderProperty.UNIQUE_PROP, false));
        }

        if(holder.equipControl() != config.clientData.equipControl) {
            AccessoriesInternals.getNetworkHandler().sendToServer(SyncHolderChange.of(HolderProperty.EQUIP_CONTROL, config.clientData.equipControl));
        }

        if(holder.showUnusedSlots() != config.clientData.showUnusedSlots) {
            AccessoriesInternals.getNetworkHandler().sendToServer(SyncHolderChange.of(HolderProperty.UNUSED_PROP, config.clientData.showUnusedSlots));
        }
    }

    public interface WindowResizeCallback {
        void onResized(class_310 client, class_1041 window);
    }

    private static boolean displayUnusedSlotWarning = false;

    public static boolean attemptToOpenScreen() {
        return attemptToOpenScreen(false);
    }

    public static boolean attemptToOpenScreen(boolean targetingLookingEntity) {
        var player = class_310.method_1551().field_1724;

        if(targetingLookingEntity) {
            var result = class_1675.method_49998(player, e -> e instanceof class_1309, (player.method_7337() ? 4.5 : 4));

            var bl = !(result instanceof class_3966 entityHitResult) ||
                    !(entityHitResult.method_17782() instanceof class_1309 living)
                    || EntitySlotLoader.getEntitySlots(living).isEmpty();

            if(bl) return false;

            AccessoriesInternals.getNetworkHandler().sendToServer(ScreenOpen.of(true));
        } else {
            var slots = AccessoriesAPI.getUsedSlotsFor(player);

            var holder = player.accessoriesHolder();

            if(holder == null) return false;

            if(slots.isEmpty() && !holder.showUnusedSlots() && !displayUnusedSlotWarning && !Accessories.getConfig().clientData.disableEmptySlotScreenError) {
                player.method_7353(class_2561.method_43470("[Accessories]: No Used Slots found by any mod directly, the screen will show empty unless a item is found to implement slots!"), false);

                displayUnusedSlotWarning = true;
            }

            AccessoriesInternals.getNetworkHandler().sendToServer(ScreenOpen.of(false));
        }

        return true;
    }
}
