package io.wispforest.accessories.client;

import I;
import com.google.common.collect.ImmutableSet;
import com.mojang.datafixers.util.Pair;
import com.mojang.logging.LogUtils;
import io.wispforest.accessories.Accessories;
import io.wispforest.accessories.AccessoriesInternals;
import io.wispforest.accessories.api.*;
import io.wispforest.accessories.api.slot.SlotGroup;
import io.wispforest.accessories.api.slot.SlotType;
import io.wispforest.accessories.client.gui.AccessoriesInternalSlot;
import io.wispforest.accessories.data.SlotGroupLoader;
import io.wispforest.accessories.data.SlotTypeLoader;
import io.wispforest.accessories.mixin.SlotAccessor;
import io.wispforest.accessories.networking.server.ScreenOpen;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;

import java.util.*;
import net.minecraft.class_1297;
import net.minecraft.class_1304;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1735;
import net.minecraft.class_1799;
import net.minecraft.class_2371;
import net.minecraft.class_2960;
import net.minecraft.class_3532;

public final class AccessoriesMenu extends class_1703 {

    private static final Logger LOGGER = LogUtils.getLogger();

    public static final class_2960 BLOCK_ATLAS = new class_2960("textures/atlas/blocks.png");

    public static final class_2960 EMPTY_ARMOR_SLOT_SHIELD = new class_2960("item/empty_armor_slot_shield");

    private static final Map<class_1304, class_2960> TEXTURE_EMPTY_SLOTS = Map.of(
            class_1304.field_6166, new class_2960("item/empty_armor_slot_boots"),
            class_1304.field_6172, new class_2960("item/empty_armor_slot_leggings"),
            class_1304.field_6174, new class_2960("item/empty_armor_slot_chestplate"),
            class_1304.field_6169, new class_2960("item/empty_armor_slot_helmet"));

    private static final class_1304[] SLOT_IDS = new class_1304[]{class_1304.field_6169, class_1304.field_6174, class_1304.field_6172, class_1304.field_6166};

    private final class_1657 owner;

    @Nullable
    private final class_1309 targetEntity;

    public int totalSlots = 0;
    public boolean overMaxVisibleSlots = false;

    public int scrolledIndex = 0;

    public float smoothScroll = 0;

    private int maxScrollableIndex = 0;

    private int accessoriesSlotStartIndex = 0;
    private int cosmeticSlotStartIndex = 0;

    private final Set<SlotGroup> validGroups = new HashSet<>();

    private final Map<Integer, Boolean> slotToView = new HashMap<>();

    private Runnable onScrollToEvent = () -> {};

    @Nullable
    private Set<SlotType> usedSlots = null;

    public AccessoriesMenu(int containerId, class_1661 inventory, @Nullable class_1309 targetEntity) {
        super(Accessories.ACCESSORIES_MENU_TYPE, containerId);

        this.owner = inventory.field_7546;
        this.targetEntity = targetEntity;

        var accessoryTarget = targetEntity != null ? targetEntity : owner;

        var capability = AccessoriesCapability.get(accessoryTarget);

        if (capability == null) return;

        //-- Vanilla Slot Setup

        for (int i = 0; i < 4; i++) {
            var equipmentSlot = SLOT_IDS[i];
            class_2960 resourceLocation = TEXTURE_EMPTY_SLOTS.get(equipmentSlot);
            this.method_7621(new ArmorSlot(inventory, owner, equipmentSlot, 39 - i, 8, 8 + i * 18, resourceLocation));
        }

        for (int i = 0; i < 3; i++) {
            for (int j = 0; j < 9; j++) {
                this.method_7621(new class_1735(inventory, j + (i + 1) * 9, 8 + j * 18, 84 + i * 18));
            }
        }

        for (int i = 0; i < 9; i++) {
            this.method_7621(new class_1735(inventory, i, 8 + i * 18, 142));
        }

        this.method_7621(new class_1735(inventory, 40, 152, 62) {
            @Override
            public void method_48931(class_1799 oldStack) {
                var newStack = this.method_7677();
                owner.method_6116(class_1304.field_6171, oldStack, newStack);
                super.method_48931(oldStack);
            }

            @Override
            public Pair<class_2960, class_2960> method_7679() {
                return Pair.of(BLOCK_ATLAS, EMPTY_ARMOR_SLOT_SHIELD);
            }
        });

        //--

        if(!this.areUnusedSlotsShown()) {
            this.usedSlots = ImmutableSet.copyOf(AccessoriesAPI.getUsedSlotsFor(targetEntity != null ? targetEntity : owner, owner.method_31548()));
        }

        int minX = -46, maxX = 60, minY = 8, maxY = 152;

        int yIndex = 0;

        this.accessoriesSlotStartIndex = this.field_7761.size();

        var slotVisibility = new HashMap<class_1735, Boolean>();

        var accessoriesSlots = new ArrayList<AccessoriesInternalSlot>();
        var cosmeticSlots = new ArrayList<AccessoriesInternalSlot>();

        var groups = SlotGroupLoader.getGroups(inventory.field_7546.method_37908(), !this.areUniqueSlotsShown());

        var containers = capability.getContainers();

        var slotTypes = groups.stream().sorted(Comparator.comparingInt(SlotGroup::order).reversed())
                .flatMap(slotGroup -> {
                    return slotGroup.slots().stream()
                            .map(s -> {
                                var slotType = SlotTypeLoader.getSlotType(owner.method_37908(), s);

                                if(this.usedSlots != null && !this.usedSlots.contains(slotType)) return null;

                                this.validGroups.add(slotGroup);

                                return slotType;
                            })
                            .filter(Objects::nonNull)
                            .sorted(Comparator.comparingInt(SlotType::order).reversed());
                }).toList();

        //LOGGER.info("SlotTypes for [{}] Screen: {}", (owner.level().isClientSide() ? "client" : "server"), slotTypes);
        //LOGGER.info("Containers for [{}] Screen: {}", (owner.level().isClientSide() ? "client" : "server"), containers.keySet());

        for (var slot : slotTypes) {
            var accessoryContainer = containers.get(slot.name());

            if (accessoryContainer == null || accessoryContainer.slotType() == null) continue;

            var size = accessoryContainer.getSize();

            for (int i = 0; i < size; i++) {
                int currentY = (yIndex * 18) + minY + 8;

                int currentX = minX;

                var cosmeticSlot = new AccessoriesInternalSlot(yIndex, accessoryContainer, true, i, currentX, currentY)
                                .isActive((slot1) -> this.isCosmeticsOpen() && this.slotToView.getOrDefault(slot1.field_7874, true))
                                .isAccessible(slot1 -> slot1.isCosmetic && isCosmeticsOpen());

                cosmeticSlots.add(cosmeticSlot);

                slotVisibility.put(cosmeticSlot, !this.overMaxVisibleSlots);

                currentX += 18 + 2;

                var baseSlot = new AccessoriesInternalSlot(yIndex, accessoryContainer, false, i, currentX, currentY)
                                .isActive(slot1 -> this.slotToView.getOrDefault(slot1.field_7874, true));

                accessoriesSlots.add(baseSlot);

                slotVisibility.put(baseSlot, !this.overMaxVisibleSlots);

                yIndex++;

                if (!this.overMaxVisibleSlots && currentY + 18 > maxY) this.overMaxVisibleSlots = true;
            }
        }

        for (var accessoriesSlot : accessoriesSlots) {
            this.method_7621(accessoriesSlot);

            slotToView.put(accessoriesSlot.field_7874, slotVisibility.getOrDefault(accessoriesSlot, false));
        }

        this.cosmeticSlotStartIndex = this.field_7761.size();

        for (var cosmeticSlot : cosmeticSlots) {
            this.method_7621(cosmeticSlot);

            this.slotToView.put(cosmeticSlot.field_7874, slotVisibility.getOrDefault(cosmeticSlot, false));
        }

        this.totalSlots = yIndex;

        this.maxScrollableIndex = this.totalSlots - 8;
    }

    public void setScrollEvent(Runnable event) {
        this.onScrollToEvent = event;
    }

    public boolean scrollTo(int i, boolean smooth) {
        var index = Math.min(Math.max(i, 0), this.maxScrollableIndex);

        if (index == this.scrolledIndex) return false;

        var diff = this.scrolledIndex - index;

        if (!smooth) this.smoothScroll = class_3532.method_15363(index / (float) this.maxScrollableIndex, 0.0f, 1.0f);

        for (class_1735 slot : this.field_7761) {
            if (!(slot instanceof AccessoriesInternalSlot accessoriesSlot)) continue;

            ((SlotAccessor) accessoriesSlot).accessories$setY(accessoriesSlot.field_7872 + (diff * 18));

            var menuIndex = accessoriesSlot.menuIndex;

            this.slotToView.put(accessoriesSlot.field_7874, (menuIndex >= index && menuIndex < index + 8));
        }

        this.scrolledIndex = index;

        this.onScrollToEvent.run();

        return true;
    }

    public int maxScrollableIndex(){
        return this.maxScrollableIndex;
    }

    @Nullable
    public class_1309 targetEntity() {
        return this.targetEntity;
    }

    public class_1657 owner() {
        return this.owner;
    }

    public static AccessoriesMenu of(int containerId, class_1661 inventory, AccessoriesMenuData data) {
        var targetEntity = data.targetEntityId().map(i -> {
            var entity = inventory.field_7546.method_37908().method_8469(i);

            if(entity instanceof class_1309 livingEntity) return livingEntity;

            return null;
        }).orElse(null);

        return new AccessoriesMenu(containerId, inventory, targetEntity);
    }

    public boolean showingSlots() {
        return this.usedSlots == null || !this.usedSlots.isEmpty();
    }

    @Nullable
    public Set<SlotType> usedSlots() {
        return this.usedSlots;
    }

    public Set<SlotGroup> validGroups() {
        return this.validGroups;
    }

    public boolean isCosmeticsOpen() {
        return Optional.ofNullable(AccessoriesHolder.get(owner)).map(AccessoriesHolder::cosmeticsShown).orElse(false);
    }

    public boolean areLinesShown() {
        return Optional.ofNullable(AccessoriesHolder.get(owner)).map(AccessoriesHolder::linesShown).orElse(false);
    }

    public boolean areUnusedSlotsShown() {
        return Optional.ofNullable(AccessoriesHolder.get(owner)).map(AccessoriesHolder::showUnusedSlots).orElse(false);
    }

    public boolean areUniqueSlotsShown() {
        return Optional.ofNullable(AccessoriesHolder.get(owner)).map(AccessoriesHolder::showUniqueSlots).orElse(false);
    }

    public void reopenMenu() {
        AccessoriesInternals.getNetworkHandler().sendToServer(ScreenOpen.of(this.targetEntity));
    }

    //--

    @Override
    public boolean method_7597(class_1657 player) {
        return true;
    }

    @Override
    public class_1799 method_7601(class_1657 player, int clickedIndex) {
        final var slots = this.field_7761;
        final var clickedSlot = slots.get(clickedIndex);
        if (!clickedSlot.method_7681()) return class_1799.field_8037;

        class_1799 clickedStack = clickedSlot.method_7677();
        var oldStack = clickedStack.method_7972();
        class_1304 equipmentSlot = class_1308.method_32326(oldStack);

        int armorSlots = 4;
        int hotbarSlots = 9;
        int invSlots = 27;

        int armorStart = 0;
        int armorEnd = armorStart - 1 + armorSlots;
        int invStart = armorEnd + 1;
        int invEnd = invStart - 1 + invSlots;
        int hotbarStart = invEnd + 1;
        int hotbarEnd = hotbarStart - 1 + hotbarSlots;
        int offhand = hotbarEnd + 1;

        // If the clicked slot isn't an accessory slot
        if (clickedIndex < this.accessoriesSlotStartIndex) {
            // Try to move to accessories
            if (!this.method_7616(clickedStack, this.accessoriesSlotStartIndex, this.field_7761.size(), false)) {
                // If the clicked slot is one of the armor slots
                if (clickedIndex >= armorStart && clickedIndex <= armorEnd) {
                    // Try to move to the inventory or hotbar
                    if (!this.method_7616(clickedStack, invStart, hotbarEnd, false)) {
                        return class_1799.field_8037;
                    }
                    // If the clicked slot can go into an armor slot and said armor slot is empty
                } else if (equipmentSlot.method_5925() == class_1304.class_1305.field_6178 && !this.field_7761.get(armorEnd - equipmentSlot.method_5927()).method_7681()) {
                    // Try to move to the armor slot
                    int targetArmorSlotIndex = armorEnd - equipmentSlot.method_5927();
                    if (!this.method_7616(clickedStack, targetArmorSlotIndex, targetArmorSlotIndex + 1, false)) {
                        return class_1799.field_8037;
                    }
                    // If the clicked slot can go into the offhand slot and the offhand slot is empty
                } else if (equipmentSlot == class_1304.field_6171 && !this.field_7761.get(offhand).method_7681()) {
                    // Try to move to the offhand slot
                    if (!this.method_7616(clickedStack, offhand, offhand + 1, false)) {
                        return class_1799.field_8037;
                    }
                    // If the clicked slot is in the hotbar
                } else if (clickedIndex >= hotbarStart && clickedIndex <= hotbarEnd) {
                    // Try to move to the inventory
                    if (!this.method_7616(clickedStack, invStart, invEnd, false)) {
                        return class_1799.field_8037;
                    }
                    // If the clicked slot is in the inventory
                } else if (clickedIndex >= invStart && clickedIndex <= invEnd) {
                    // Try to move to the hotbar
                    if (!this.method_7616(clickedStack, hotbarStart, hotbarEnd, false)) {
                        return class_1799.field_8037;
                    }
                    // Try to move to the inventory or hotbar
                } else if (!this.method_7616(clickedStack, invStart, hotbarEnd, false)) {
                    return class_1799.field_8037;
                }
            }
        } else if (!this.method_7616(clickedStack, invStart, hotbarEnd, false)) {
            return class_1799.field_8037;
        }

        if (clickedStack.method_7960()) {
            clickedSlot.method_48931(class_1799.field_8037);
        } else {
            clickedSlot.method_7668();
        }

        if (clickedStack.method_7947() == oldStack.method_7947()) {
            return class_1799.field_8037;
        }

        clickedSlot.method_7667(player, clickedStack);

        return oldStack;
    }

    @Override
    protected boolean method_7616(class_1799 stack, int startIndex, int endIndex, boolean reverseDirection) {
        boolean bl = false;
        int i = startIndex;
        if (reverseDirection) {
            i = endIndex - 1;
        }

        if (stack.method_7946()) {
            while(!stack.method_7960() && (reverseDirection ? i >= startIndex : i < endIndex)) {
                class_1735 slot = this.field_7761.get(i);
                class_1799 itemStack = slot.method_7677();

                //Check if the slot dose not permit the given amount
                if(slot.method_7676(itemStack) < itemStack.method_7947()) {
                    if (!itemStack.method_7960() && class_1799.method_31577(stack, itemStack)) {
                        int j = itemStack.method_7947() + stack.method_7947();
                        if (j <= stack.method_7914()) {
                            stack.method_7939(0);
                            itemStack.method_7939(j);
                            slot.method_7668();
                            bl = true;
                        } else if (itemStack.method_7947() < stack.method_7914()) {
                            stack.method_7934(stack.method_7914() - itemStack.method_7947());
                            itemStack.method_7939(stack.method_7914());
                            slot.method_7668();
                            bl = true;
                        }
                    }
                }

                if (reverseDirection) {
                    --i;
                } else {
                    ++i;
                }
            }
        }

        if (!stack.method_7960()) {
            if (reverseDirection) {
                i = endIndex - 1;
            } else {
                i = startIndex;
            }

            while(reverseDirection ? i >= startIndex : i < endIndex) {
                class_1735 slot = this.field_7761.get(i);
                class_1799 itemStack = slot.method_7677();
                if (itemStack.method_7960() && slot.method_7680(stack)) {
                    //Use Stack aware form of getMaxStackSize
                    if (stack.method_7947() > slot.method_7676(stack)) {
                        slot.method_48931(stack.method_7971(slot.method_7676(stack)));
                    } else {
                        slot.method_48931(stack.method_7971(stack.method_7947()));
                    }

                    slot.method_7668();
                    bl = true;
                    break;
                }

                if (reverseDirection) {
                    --i;
                } else {
                    ++i;
                }
            }
        }

        return bl;
    }

    //--
}