package io.wispforest.accessories.client;

import io.wispforest.endec.Endec;
import io.wispforest.endec.impl.StructEndecBuilder;
import org.jetbrains.annotations.Nullable;

import java.util.Optional;
import net.minecraft.class_1309;

public record AccessoriesMenuData(Optional<Integer> targetEntityId) {
    public static final Endec<AccessoriesMenuData> ENDEC = StructEndecBuilder.of(
            Endec.VAR_INT.optionalOf().fieldOf("targetEntityId", AccessoriesMenuData::targetEntityId),
            AccessoriesMenuData::new
    );

    public static AccessoriesMenuData of(@Nullable class_1309 livingEntity) {
        return new AccessoriesMenuData(Optional.ofNullable(livingEntity != null ? livingEntity.method_5628() : null));
    }
}
