package io.wispforest.accessories.client;

import com.mojang.blaze3d.platform.GlStateManager;
import io.wispforest.accessories.Accessories;
import io.wispforest.accessories.api.AccessoriesCapability;
import io.wispforest.accessories.api.AccessoriesContainer;
import io.wispforest.accessories.api.slot.SlotReference;
import io.wispforest.accessories.api.client.AccessoriesRendererRegistry;
import io.wispforest.accessories.api.client.AccessoryRenderer;
import io.wispforest.accessories.client.gui.AccessoriesInternalSlot;
import io.wispforest.accessories.client.gui.AccessoriesScreen;
import io.wispforest.accessories.compat.AccessoriesConfig.ClientData.HoverOptions;
import io.wispforest.accessories.impl.ExpandedSimpleContainer;
import org.apache.commons.lang3.mutable.MutableBoolean;
import org.lwjgl.opengl.GL30;

import java.awt.*;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Map;
import java.util.Map.Entry;
import net.minecraft.class_1309;
import net.minecraft.class_1799;
import net.minecraft.class_276;
import net.minecraft.class_310;
import net.minecraft.class_3532;
import net.minecraft.class_3883;
import net.minecraft.class_3887;
import net.minecraft.class_437;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_4720;
import net.minecraft.class_572;
import net.minecraft.class_583;
import net.minecraft.class_922;

import static io.wispforest.accessories.client.gui.AccessoriesScreen.*;

import F;
import J;
import Z;


/**
 * Render layer used to render equipped Accessories for a given {@link class_1309}.
 * This is only applied to {@link class_922} that have a model that
 * extends {@link class_572}
 */
public class AccessoriesRenderLayer<T extends class_1309, M extends class_583<T>> extends class_3887<T, M> {

    private static final PostEffectBuffer BUFFER = new PostEffectBuffer();

    private static final float increment = 0.1f;

    private static Map<String, Float> brightnessMap = new HashMap<>();
    private static Map<String, Float> opacityMap = new HashMap<>();

    private static long lastUpdated20th = 0;

    public AccessoriesRenderLayer(class_3883<T, M> renderLayerParent) {
        super(renderLayerParent);
    }

    @Override
    public void render(
            class_4587 poseStack,
            class_4597 multiBufferSource,
            int light,
            T entity,
            float limbSwing,
            float limbSwingAmount,
            float partialTicks,
            float ageInTicks,
            float netHeadYaw,
            float headPitch
    ) {
        var highlightOptions = Accessories.getConfig().clientData.hoverOptions;

        var capability = AccessoriesCapability.get(entity);

        if (capability == null) return;

        var calendar = Calendar.getInstance();

        float scale = (float) (1 + (0.5 * (0.75 + (Math.sin((System.currentTimeMillis()) / 250d)))));

        var renderingLines = AccessoriesScreen.COLLECT_ACCESSORY_POSITIONS;

        var useCustomerBuffer = IS_RENDERING_UI_ENTITY;

        if (!renderingLines && !AccessoriesScreen.NOT_VERY_NICE_POSITIONS.isEmpty()) {
            AccessoriesScreen.NOT_VERY_NICE_POSITIONS.clear();
        }

        if (multiBufferSource instanceof class_4597.class_4598 bufferSource) {
            bufferSource.method_22993();
        }

        var current20th = calendar.getTimeInMillis() / 50;
        var shouldUpdate = lastUpdated20th != current20th;

        if (shouldUpdate) lastUpdated20th = current20th;

        var screen = class_310.method_1551().field_1755;

        AccessoriesInternalSlot selected = null;

        if (screen instanceof AccessoriesScreen accessoriesScreen && accessoriesScreen.getHoveredSlot() instanceof AccessoriesInternalSlot slot) {
            selected = slot;
        }

        for (var entry : capability.getContainers().entrySet()) {

            var container = entry.getValue();

            var accessories = container.getAccessories();
            var cosmetics = container.getCosmeticAccessories();

            var containerSelected = selected != null && selected.accessoriesContainer.slotType() == container.slotType();

            for (int i = 0; i < accessories.method_5439(); i++) {

                var isSelected = containerSelected && selected.method_34266() == i;

                if (shouldUpdate) {
                    var currentBrightness = brightnessMap.getOrDefault(entry.getKey() + i, 1f);
                    var currentOpacity = opacityMap.getOrDefault(entry.getKey() + i, 1f);

                    if (selected != null && !isSelected) {
                        brightnessMap.put(entry.getKey() + i, Math.max(highlightOptions.unHoveredOptions.darkenedBrightness, currentBrightness - increment));
                        opacityMap.put(entry.getKey() + i, Math.max(highlightOptions.unHoveredOptions.darkenedOpacity, currentOpacity - increment));
                    } else {
                        brightnessMap.put(entry.getKey() + i, Math.min(1, currentBrightness + increment));
                        opacityMap.put(entry.getKey() + i, Math.min(1, currentOpacity + increment));
                    }
                }

                var stack = accessories.method_5438(i);
                var cosmeticStack = cosmetics.method_5438(i);

                if (!cosmeticStack.method_7960()) stack = cosmeticStack;

                if (stack.method_7960()) continue;

                var renderer = AccessoriesRendererRegistry.getRender(stack);

                if (renderer == null || !renderer.shouldRender(container.shouldRender(i))) continue;

                poseStack.method_22903();

                var mpoatv = new MPOATVConstructingVertexConsumer();

                var bufferedGrabbedFlag = new MutableBoolean(false);

                class_4597 innerBufferSource = (renderType) -> {
                    bufferedGrabbedFlag.setValue(true);

                    return useCustomerBuffer ?
                            class_4720.method_24037(multiBufferSource.getBuffer(renderType), mpoatv) :
                            multiBufferSource.getBuffer(renderType);
                };

                if (!IS_RENDERING_UI_ENTITY || isSelected || selected == null || highlightOptions.unHoveredOptions.renderUnHovered) {
                    renderer.render(
                            stack,
                            SlotReference.of(entity, container.getSlotName(), i),
                            poseStack,
                            method_17165(),
                            innerBufferSource,
                            light,
                            limbSwing,
                            limbSwingAmount,
                            partialTicks,
                            ageInTicks,
                            netHeadYaw,
                            headPitch
                    );
                }

                float[] colorValues = null;

                if (useCustomerBuffer && bufferedGrabbedFlag.getValue()) {
                    if (multiBufferSource instanceof class_4597.class_4598 bufferSource) {
                        if (highlightOptions.hoveredOptions.brightenHovered && isSelected) {
                            if (calendar.get(Calendar.MONTH) + 1 == 5 && calendar.get(Calendar.DATE) == 16) {
                                var hue = (float) ((System.currentTimeMillis() / 20d % 360d) / 360d);

                                var color = new Color(class_3532.method_15369(hue, 1, 1));

                                colorValues = new float[]{color.getRed() / 128f, color.getGreen() / 128f, color.getBlue() / 128f, 1};
                            } else {
                                var mul = highlightOptions.hoveredOptions.cycleBrightness ? scale : 1.5f;
                                colorValues = new float[]{mul, mul, mul, 1};
                            }
                        } else if (highlightOptions.unHoveredOptions.darkenUnHovered) {
                            var darkness = brightnessMap.getOrDefault(entry.getKey() + i, 1f);
                            colorValues = new float[]{darkness, darkness, darkness, opacityMap.getOrDefault(entry.getKey() + i, 1f)};
                        }

                        if (colorValues != null) {
                            BUFFER.beginWrite(true, GL30.GL_DEPTH_BUFFER_BIT);
                            bufferSource.method_22993();
                            BUFFER.endWrite();

                            BUFFER.draw(colorValues);

                            var frameBuffer = BUFFER.buffer();

                            GlStateManager._glBindFramebuffer(GL30.GL_READ_FRAMEBUFFER, frameBuffer.field_1476);
                            GL30.glBlitFramebuffer(
                                    0,
                                    0,
                                    frameBuffer.field_1482,
                                    frameBuffer.field_1481,
                                    0,
                                    0,
                                    frameBuffer.field_1482,
                                    frameBuffer.field_1481,
                                    GL30.GL_DEPTH_BUFFER_BIT,
                                    GL30.GL_NEAREST
                            );
                            class_310.method_1551().method_1522().method_1235(false);
                        } else {
                            bufferSource.method_22993();
                        }
                    }

                    if (renderingLines && AccessoriesScreen.IS_RENDERING_LINE_TARGET) {
                        AccessoriesScreen.NOT_VERY_NICE_POSITIONS.put(container.getSlotName() + i, mpoatv.meanPos());
                    }
                }

                poseStack.method_22909();
            }
        }
    }
}
