package io.wispforest.accessories.client;

import I;
import io.wispforest.accessories.client.gui.AccessoriesScreen;
import net.minecraft.class_4588;
import org.jetbrains.annotations.NotNull;
import org.joml.Vector3d;
import org.joml.Vector3f;
import org.joml.Vector4i;

/**
 * Mean Position of all the Vertices™ (MPOATV)
 */
public final class MPOATVConstructingVertexConsumer implements class_4588 {

    private double minX = Double.MAX_VALUE;
    private double minY = Double.MAX_VALUE;
    private double minZ = Double.MAX_VALUE;
    private double maxX = -Double.MAX_VALUE;
    private double maxY = -Double.MAX_VALUE;
    private double maxZ = -Double.MAX_VALUE;

    private Vector3d meanPos = null;

    public Vector3d meanPos(){
        return this.meanPos;
    }

    @Override
    @NotNull
    public class_4588 method_22912(double x, double y, double z) {
        var leeway = 10;

        var box = AccessoriesScreen.SCISSOR_BOX;

        if ((x >= box.x - leeway && x <= box.z + leeway) && (y >= box.y - leeway && y <= box.w + leeway)) {
            this.minX = Math.min(this.minX, x);
            this.maxX = Math.max(this.maxX, x);

            this.minY = Math.min(this.minY, y);
            this.maxY = Math.max(this.maxY, y);

            this.minZ = Math.min(this.minZ, z);
            this.maxZ = Math.max(this.maxZ, z);
        }

        this.meanPos = new Vector3d((this.minX + this.maxX) / 2, (this.minY + this.maxY) / 2, (this.minZ + this.maxZ) / 2);

        return this;
    }

    @Override public class_4588 method_1336(int i, int j, int k, int l) { return this; }
    @Override public class_4588 method_22913(float f, float g) { return this; }
    @Override public class_4588 method_22917(int i, int j) { return this; }
    @Override public class_4588 method_22921(int i, int j) { return this; }
    @Override public class_4588 method_22914(float f, float g, float h) { return this; }
    @Override public void method_1344() {}
    @Override public void method_22901(int defaultR, int defaultG, int defaultB, int defaultA) {}
    @Override public void method_35666() {}
}