package io.wispforest.accessories.client;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import io.wispforest.accessories.pond.AccessoriesFrameBufferExtension;
import net.minecraft.class_276;
import net.minecraft.class_284;
import net.minecraft.class_310;
import net.minecraft.class_6367;
import org.lwjgl.opengl.GL11;
import org.lwjgl.opengl.GL30;
import org.lwjgl.opengl.GL30C;

public class PostEffectBuffer {

    private class_276 framebuffer = null;
    private int prevBuffer = 0;
    private int textureFilter = -1;

    public void clear() {
        this.ensureInitialized();

        int previousBuffer = GlStateManager.getBoundFramebuffer();
        this.framebuffer.method_1230(class_310.field_1703);
        GlStateManager._glBindFramebuffer(GL30.GL_FRAMEBUFFER, previousBuffer);
    }

    public void beginWrite(boolean clear, int blitFromMain) {
        this.ensureInitialized();

        this.prevBuffer = GlStateManager.getBoundFramebuffer();
        if (clear) this.framebuffer.method_1230(class_310.field_1703);

        if (blitFromMain != 0) {
            GlStateManager._glBindFramebuffer(GL30C.GL_READ_FRAMEBUFFER, this.prevBuffer);
            GlStateManager._glBindFramebuffer(GL30.GL_DRAW_FRAMEBUFFER, this.framebuffer.field_1476);
            GL30.glBlitFramebuffer(
                    0, 0,
                    this.framebuffer.field_1482, this.framebuffer.field_1481,
                    0, 0,
                    this.framebuffer.field_1482, this.framebuffer.field_1481,
                    blitFromMain, GL11.GL_NEAREST
            );
        }

        this.framebuffer.method_1235(false);
    }

    public void endWrite() {
        GlStateManager._glBindFramebuffer(GL30C.GL_FRAMEBUFFER, this.prevBuffer);
    }

    public void draw(boolean blend) {
        if (blend) {
            RenderSystem.enableBlend();
            RenderSystem.defaultBlendFunc();
        }

        RenderSystem.backupProjectionMatrix();
        this.framebuffer.method_22594(this.framebuffer.field_1482, this.framebuffer.field_1481, !blend);
        RenderSystem.restoreProjectionMatrix();
    }

    public void draw(float[] color) {
        var modulator = class_310.method_1551().field_1773.field_29403.field_29474;
        modulator.method_1254(color[0], color[1], color[2], color[3]);
        this.draw(true);
        modulator.method_1254(1f, 1f, 1f, 1f);
    }

    public class_276 buffer() {
        this.ensureInitialized();
        return this.framebuffer;
    }

    private void ensureInitialized() {
        if (this.framebuffer != null) return;

        this.framebuffer = new class_6367(class_310.method_1551().method_1522().field_1482, class_310.method_1551().method_1522().field_1481, true, class_310.field_1703);
        this.framebuffer.method_1236(0, 0, 0, 0);

        AccessoriesClient.WINDOW_RESIZE_CALLBACK_EVENT.register((client, window) -> {
            this.framebuffer.method_1234(window.method_4489(), window.method_4506(), class_310.field_1703);
            if (this.textureFilter != -1) {
                this.framebuffer.method_1232(this.textureFilter);
            }
        });
    }

}
