package io.wispforest.accessories.client.gui;

import io.wispforest.accessories.Accessories;
import io.wispforest.accessories.api.AccessoriesAPI;
import io.wispforest.accessories.api.menu.AccessoriesBasedSlot;
import io.wispforest.accessories.api.AccessoriesContainer;
import io.wispforest.accessories.api.slot.SlotReference;
import io.wispforest.accessories.api.slot.SlotType;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import net.minecraft.class_124;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_2561;
import net.minecraft.class_2960;

public class AccessoriesInternalSlot extends AccessoriesBasedSlot {

    public final int menuIndex;

    public final boolean isCosmetic;

    private Function<AccessoriesInternalSlot, Boolean> isActive = (slot) -> true;
    private Function<AccessoriesInternalSlot, Boolean> isAccessible = (slot) -> true;

    public AccessoriesInternalSlot(int menuIndex, AccessoriesContainer container, boolean isCosmetic, int slot, int x, int y) {
        super(container, isCosmetic ? container.getCosmeticAccessories() : container.getAccessories(), slot, x, y);

        this.menuIndex = menuIndex;

        this.isCosmetic = isCosmetic;
    }

    public AccessoriesInternalSlot isActive(Function<AccessoriesInternalSlot, Boolean> isActive){
        this.isActive = isActive;

        return this;
    }

    public AccessoriesInternalSlot isAccessible(Function<AccessoriesInternalSlot, Boolean> isAccessible){
        this.isAccessible = isAccessible;

        return this;
    }

    @Override
    protected class_2960 icon() {
        return (this.isCosmetic) ? Accessories.of("gui/slot/cosmetic") : super.icon();
    }

    public List<class_2561> getTooltipData() {
        List<class_2561> tooltipData = new ArrayList<>();

        var key = this.isCosmetic ? "cosmetic_" : "";

        var slotType = this.accessoriesContainer.slotType();

        tooltipData.add(class_2561.method_43471(Accessories.translation(key + "slot.tooltip.singular"))
                .method_27692(class_124.field_1080)
                .method_10852(class_2561.method_43471(slotType.translation()).method_27692(class_124.field_1078)));

        return tooltipData;
    }

    @Override
    public void method_7673(class_1799 stack) {
        var prevStack = this.method_7677();

        super.method_7673(stack);

        // TODO: SHOULD THIS BE HERE?
//        if(isCosmetic) {
//            var reference = new SlotReference(container.getSlotName(), entity, getContainerSlot());
//
//            AccessoriesAPI.getAccessory(prevStack)
//                    .ifPresent(prevAccessory1 -> prevAccessory1.onUnequip(prevStack, reference));
//
//            AccessoriesAPI.getAccessory(stack)
//                    .ifPresent(accessory1 -> accessory1.onEquip(stack, reference));
//        }
    }

    @Override
    public boolean method_7680(class_1799 stack) {
        return this.isAccessible.apply(this) && super.method_7680(stack);
    }

    @Override
    public boolean method_7674(class_1657 player) {
        return this.isAccessible.apply(this) && (isCosmetic || super.method_7674(player));
    }

    @Override
    public boolean method_32754(class_1657 player) {
        return this.isAccessible.apply(this) && super.method_32754(player);
    }

    @Override
    public boolean method_7682() {
        return this.isActive.apply(this);
    }
}
