package io.wispforest.accessories.client.gui;

import D;
import I;
import Z;
import io.wispforest.accessories.Accessories;
import io.wispforest.accessories.AccessoriesInternals;
import io.wispforest.accessories.api.AccessoriesContainer;
import io.wispforest.accessories.api.slot.SlotGroup;
import io.wispforest.accessories.api.slot.SlotType;
import io.wispforest.accessories.api.slot.UniqueSlotHandling;
import io.wispforest.accessories.client.AccessoriesMenu;
import io.wispforest.accessories.client.GuiGraphicsUtils;
import io.wispforest.accessories.data.EntitySlotLoader;
import io.wispforest.accessories.data.SlotGroupLoader;
import io.wispforest.accessories.impl.ExpandedSimpleContainer;
import io.wispforest.accessories.impl.SlotGroupImpl;
import io.wispforest.accessories.mixin.client.ScreenAccessor;
import io.wispforest.accessories.networking.holder.HolderProperty;
import io.wispforest.accessories.networking.holder.SyncHolderChange;
import io.wispforest.accessories.networking.server.MenuScroll;
import io.wispforest.accessories.pond.ContainerScreenExtension;
import it.unimi.dsi.fastutil.Pair;
import org.apache.commons.lang3.Range;
import org.jetbrains.annotations.Nullable;
import org.joml.*;
import org.lwjgl.glfw.GLFW;

import java.lang.Math;
import java.util.*;
import java.util.Map.Entry;
import net.minecraft.class_1109;
import net.minecraft.class_124;
import net.minecraft.class_1309;
import net.minecraft.class_1661;
import net.minecraft.class_1735;
import net.minecraft.class_1921;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_3417;
import net.minecraft.class_3532;
import net.minecraft.class_364;
import net.minecraft.class_4185;
import net.minecraft.class_4264;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4608;
import net.minecraft.class_465;
import net.minecraft.class_490;
import net.minecraft.class_765;
import net.minecraft.class_7919;

public class AccessoriesScreen extends class_465<AccessoriesMenu> implements ContainerScreenExtension {

    private static final class_2960 SLOT = Accessories.of("textures/gui/slot.png");

    private static final class_2960 ACCESSORIES_INVENTORY_LOCATION = Accessories.of("textures/gui/container/accessories_inventory.png");

    private static final class_2960 BACKGROUND_PATCH = Accessories.of("background_patch");

    private static final class_2960 SCROLL_BAR_PATCH = Accessories.of("scroll_bar_patch");
    private static final class_2960 SCROLL_BAR = Accessories.of("scroll_bar");

    static {
        GuiGraphicsUtils.register(BACKGROUND_PATCH, GuiGraphicsUtils.NineSlicingDimensionImpl.of(Accessories.of("textures/gui/sprites/background_patch.png"), 15, 15, 5));
        GuiGraphicsUtils.register(SCROLL_BAR_PATCH, GuiGraphicsUtils.NineSlicingDimensionImpl.of(Accessories.of("textures/gui/sprites/scroll_bar_patch.png"), 6, 6, 2));
        GuiGraphicsUtils.register(SCROLL_BAR, GuiGraphicsUtils.NineSlicingDimensionImpl.of(Accessories.of("textures/gui/sprites/scroll_bar.png"), 6, 6, 2));
    }

    private static final class_2960 HORIZONTAL_TABS = Accessories.of("textures/gui/container/horizontal_tabs_small.png");

    public static final SpriteGetter<class_4264> SPRITES_12X12 = SpriteGetter.ofButton(Accessories.of("textures/gui/sprites/widget/12x12/button.png"), Accessories.of("textures/gui/sprites/widget/12x12/button_disabled.png"), Accessories.of("textures/gui/sprites/widget/12x12/button_highlighted.png"));
    public static final SpriteGetter<class_4264> SPRITES_8X8 = SpriteGetter.ofButton(Accessories.of("textures/gui/sprites/widget/8x8/button.png"), Accessories.of("textures/gui/sprites/widget/8x8/button_disabled.png"), Accessories.of("textures/gui/sprites/widget/8x8/button_highlighted.png"));

    private static final class_2960 BACk_ICON = Accessories.of("textures/gui/sprites/widget/back.png");

    private static final class_2960 LINE_HIDDEN = Accessories.of("textures/gui/sprites/widget/line_hidden.png");
    private static final class_2960 LINE_SHOWN = Accessories.of("textures/gui/sprites/widget/line_shown.png");

    private static final class_2960 UNUSED_SLOTS_HIDDEN = Accessories.of("textures/gui/sprites/widget/unused_slots_hidden.png");
    private static final class_2960 UNUSED_SLOTS_SHOWN = Accessories.of("textures/gui/sprites/widget/unused_slots_shown.png");

    public static Vector4i SCISSOR_BOX = new Vector4i();
    // are we currently rendering an entity in a screen
    public static boolean IS_RENDERING_UI_ENTITY = false;
    // are we currently rendering the entity that lines should be drawn to
    public static boolean IS_RENDERING_LINE_TARGET = false;

    public static boolean COLLECT_ACCESSORY_POSITIONS = false;

    public static final Map<String, Vector3d> NOT_VERY_NICE_POSITIONS = new HashMap<>();

    public static boolean FORCE_TOOLTIP_LEFT = false;

    private final List<Pair<Vector3d, Vector3d>> accessoryLines = new ArrayList<>();

    private final List<Vector3d> accessoryPositions = new ArrayList<>();

    private final Map<AccessoriesInternalSlot, ToggleButton> cosmeticButtons = new LinkedHashMap<>();

    private int currentTabPage = 1;

    private int scrollBarHeight = 0;

    private boolean isScrolling = false;

    public AccessoriesScreen(AccessoriesMenu menu, class_1661 inventory, class_2561 component) {
        super(menu, inventory, class_2561.method_43473());

        this.field_25267 = 97;
        this.field_25269 = 42069;
    }

    private static final int upperPadding = 8;

    public int getPanelHeight() {
        return getPanelHeight(upperPadding);
    }

    public int getPanelHeight(int upperPadding) {
        return 14 + (Math.min(field_2797.totalSlots, 8) * 18) + upperPadding;
    }

    public int getPanelWidth() {
        int width = 8 + 18 + 18;

        if (field_2797.isCosmeticsOpen()) width += 18 + 2;

        if (!field_2797.overMaxVisibleSlots) width -= 12;

        return width;
    }

    public int getStartingPanelX() {
        int x = this.field_2776 - ((field_2797.isCosmeticsOpen()) ? 72 : 52);

        if (!field_2797.overMaxVisibleSlots) x += 12;

        return x;
    }

    public int leftPos() {
        return this.field_2776;
    }

    public int topPos() {
        return this.field_2800;
    }

    public final class_1309 targetEntityDefaulted() {
        var targetEntity = this.field_2797.targetEntity();

        return (targetEntity != null) ? targetEntity : this.field_22787.field_1724;
    }

    protected boolean insideScrollbar(double mouseX, double mouseY) {
        int x = getStartingPanelX() + 13;
        int y = this.field_2800 + 7 + upperPadding;

        int height = getPanelHeight() - 22;
        int width = 8;

        return this.field_2797.overMaxVisibleSlots && (mouseX >= x && mouseY >= y && mouseX < (x + width) && mouseY < (y + height));
    }

    @Override
    public boolean method_25402(double mouseX, double mouseY, int button) {
        var bl = super.method_25402(mouseX, mouseY, button);

        if (this.method_25399() instanceof class_4185) ((ScreenAccessor) this).call$clearFocus();

        if (this.insideScrollbar(mouseX, mouseY)) {
            this.isScrolling = true;

            return true;
        }

        if (Accessories.getConfig().clientData.showGroupTabs && this.field_2797.maxScrollableIndex() > 0) {
            int x = getStartingPanelX();
            int y = this.field_2800;

            for (var value : this.getGroups(x, y).values()) {
                if (!value.isInBounds((int) Math.round(mouseX), (int) Math.round(mouseY))) continue;

                var index = value.startingIndex;

                if (index > this.field_2797.maxScrollableIndex()) index = this.field_2797.maxScrollableIndex();

                if (index != this.field_2797.scrolledIndex) {
                    AccessoriesInternals.getNetworkHandler().sendToServer(new MenuScroll(index, false));

                    class_310.method_1551().method_1483()
                            .method_4873(class_1109.method_47978(class_3417.field_15015, 1.0F));
                }

                break;
            }
        }

        return bl;
    }

    @Override
    public boolean method_25406(double mouseX, double mouseY, int button) {
        if (!this.insideScrollbar(mouseX, mouseY) && button == GLFW.GLFW_MOUSE_BUTTON_1) this.isScrolling = false;

        return super.method_25406(mouseX, mouseY, button);
    }

    @Override
    protected void method_2389(class_332 guiGraphics, float partialTick, int mouseX, int mouseY) {
        this.method_25420(guiGraphics);

        int leftPos = this.field_2776;
        int topPos = this.field_2800;

        guiGraphics.method_25302(ACCESSORIES_INVENTORY_LOCATION, leftPos, topPos, 0, 0, this.field_2792, this.field_2779);

        //--

        var scissorStart = new Vector2i(leftPos + 26, topPos + 8);
        var scissorEnd = new Vector2i(leftPos + 26 + 124, topPos + 8 + 70);
        var size = new Vector2i((scissorEnd.x - scissorStart.x) / 2, scissorEnd.y - scissorStart.y);

        SCISSOR_BOX.set(scissorStart.x, scissorStart.y, scissorEnd.x, scissorEnd.y);

        // --

        COLLECT_ACCESSORY_POSITIONS = Accessories.getConfig().clientData.hoverOptions.hoveredOptions.line || Accessories.getConfig().clientData.hoverOptions.hoveredOptions.clickbait;

        IS_RENDERING_UI_ENTITY = true;

        IS_RENDERING_LINE_TARGET = true;

        renderEntityInInventoryFollowingMouseRotated(guiGraphics, scissorStart, size, scissorStart, scissorEnd, mouseX, mouseY, 0);

        IS_RENDERING_LINE_TARGET = false;

        renderEntityInInventoryFollowingMouseRotated(guiGraphics, new Vector2i(scissorStart).add(size.x, 0), size, scissorStart, scissorEnd, mouseX, mouseY, 180);

        IS_RENDERING_UI_ENTITY = false;

        COLLECT_ACCESSORY_POSITIONS = false;


//        HOVERED_SLOT_TYPE = null;

        //--

        var pose = guiGraphics.method_51448();

        pose.method_22903();
        pose.method_46416(0.0F, 0.0F, 0);

        int x = getStartingPanelX();
        int y = this.field_2800;

        int height = getPanelHeight();
        int width = getPanelWidth();

        //guiGraphics.blitSprite(AccessoriesScreen.BACKGROUND_PATCH, x + 6, y, width, height); //147
        GuiGraphicsUtils.blitSpriteBatched(guiGraphics, AccessoriesScreen.BACKGROUND_PATCH, x + 6, y, width, height); //147

        if (field_2797.overMaxVisibleSlots) {
            //guiGraphics.blitSprite(AccessoriesScreen.SCROLL_BAR_PATCH, x + 13, y + 7 + upperPadding, 8, height - 22);
            GuiGraphicsUtils.blitSpriteBatched(guiGraphics, AccessoriesScreen.SCROLL_BAR_PATCH, x + 13, y + 7 + upperPadding, 8, height - 22);
        }

        pose.method_22909();

        //--

        pose.method_22903();
        pose.method_46416(-1, -1, 0);

//        for (Slot slot : this.menu.slots) {
//            if (!(slot.container instanceof ExpandedSimpleContainer) || !slot.isActive()) continue;
//
//            if (slot instanceof AccessoriesInternalSlot accessoriesSlot && !accessoriesSlot.getItem().isEmpty()) {
//                var positionKey = accessoriesSlot.accessoriesContainer.getSlotName() + accessoriesSlot.getContainerSlot();
//
//                var vec = NOT_VERY_NICE_POSITIONS.getOrDefault(positionKey, null);
//
//                if (!accessoriesSlot.isCosmetic && vec != null && (menu.areLinesShown())) {
//                    var start = new Vector3d(slot.x + this.leftPos + 17, slot.y + this.topPos + 9, 5000);
//                    var vec3 = vec.add(0, 0, 5000);
//
//                    this.accessoryLines.add(Pair.of(start, vec3));}
//            }
//        }

        GuiGraphicsUtils.batched(guiGraphics, SLOT, this.field_2797.field_7761, (bufferBuilder, poseStack, slot) -> {
            if (!(slot.field_7871 instanceof ExpandedSimpleContainer) || !slot.method_7682()) return;

            GuiGraphicsUtils.blit(bufferBuilder, poseStack, slot.field_7873 + this.field_2776, slot.field_7872 + this.field_2800, 18);
        });

        if (getHoveredSlot() != null && getHoveredSlot() instanceof AccessoriesInternalSlot slot && slot.method_7682() && !slot.method_7677().method_7960()) {
            if (NOT_VERY_NICE_POSITIONS.containsKey(slot.accessoriesContainer.getSlotName() + slot.method_34266())) {
                this.accessoryPositions.add(NOT_VERY_NICE_POSITIONS.get(slot.accessoriesContainer.getSlotName() + slot.method_34266()));

                var positionKey = slot.accessoriesContainer.getSlotName() + slot.method_34266();
                var vec = NOT_VERY_NICE_POSITIONS.getOrDefault(positionKey, null);

                if (!slot.isCosmetic && vec != null && (field_2797.areLinesShown())) {
                    var start = new Vector3d(slot.field_7873 + this.field_2776 + 17, slot.field_7872 + this.field_2800 + 9, 5000);
                    var vec3 = vec.add(0, 0, 5000);

                    this.accessoryLines.add(Pair.of(start, vec3));}
            }
        }

        pose.method_22909();
    }

    @Override
    public boolean method_25401(double mouseX, double mouseY, double scrollY) {
        if (insideScrollbar(mouseX, mouseY) || (Accessories.getConfig().clientData.allowSlotScrolling && this.field_2787 instanceof AccessoriesInternalSlot)) {
            int index = (int) Math.max(Math.min(-scrollY + this.field_2797.scrolledIndex, this.field_2797.maxScrollableIndex()), 0);

            if (index != field_2797.scrolledIndex) {
                AccessoriesInternals.getNetworkHandler().sendToServer(new MenuScroll(index, false));

                return true;
            }
        }

        return super.method_25401(mouseX, mouseY, scrollY);
    }

    @Override
    public boolean method_25403(double mouseX, double mouseY, int button, double dragX, double dragY) {
        if (this.isScrolling) {
            int patchYOffset = this.field_2800 + 7 + upperPadding;
            int height = getPanelHeight();

            this.field_2797.smoothScroll = class_3532.method_15363((float) (mouseY - patchYOffset) / (height - 22f), 0.0f, 1.0f); //(menu.smoothScroll + (dragY / (getPanelHeight(upperPadding) - 24)))

            int index = Math.round(this.field_2797.smoothScroll * this.field_2797.maxScrollableIndex());

            if (index != field_2797.scrolledIndex) {
                AccessoriesInternals.getNetworkHandler().sendToServer(new MenuScroll(index, true));

                return true;
            }
        }

        return super.method_25403(mouseX, mouseY, button, dragX, dragY);
    }

    @Override
    public void method_25394(class_332 guiGraphics, int mouseX, int mouseY, float partialTick) {
        super.method_25394(guiGraphics, mouseX, mouseY, partialTick);

        for (var cosmeticButton : this.cosmeticButtons.values()) {
            cosmeticButton.method_25394(guiGraphics, mouseX, mouseY, partialTick);
        }

        int x = getStartingPanelX();
        int y = this.field_2800;

        int panelHeight = getPanelHeight();

        if (this.field_2797.overMaxVisibleSlots) {
            int startingY = y + upperPadding + 8;

            startingY += this.field_2797.smoothScroll * (panelHeight - 24 - this.scrollBarHeight);

            GuiGraphicsUtils.blitSpriteBatched(guiGraphics, AccessoriesScreen.SCROLL_BAR, x + 14, startingY, 6, this.scrollBarHeight);
        }

        //--

        var pose = guiGraphics.method_51448();

        if (Accessories.getConfig().clientData.showGroupTabs) {
            for (var entry : getGroups(x, y).entrySet()) {
                var group = entry.getKey();
                var pair = entry.getValue();

                var vector = pair.dimensions();

                int v = (pair.isSelected()) ? vector.w : vector.w * 3;

                guiGraphics.method_25290(HORIZONTAL_TABS, vector.x, vector.y, 0, v, vector.z, vector.w, 19, vector.w * 4); //32,128

                pose.method_22903();

                pose.method_46416(vector.x + 3, vector.y + 3, 0);
                pose.method_46416(1, 1, 0);

                if (pair.isSelected) pose.method_46416(2, 0, 0);

                // MultiDraw?
                guiGraphics.method_25290(group.icon().method_45138("textures/").method_48331(".png"),0, 0, 0, 0, 8, 8, 8,8);

                pose.method_22909();
            }
        }

        //--

        if (Accessories.getConfig().clientData.hoverOptions.hoveredOptions.clickbait) {
            accessoryPositions.forEach(pos -> {
                var matrix = guiGraphics.method_51448();

                matrix.method_22903();

                matrix.method_46416((float) pos.x - 128, (float) pos.y - 128, 200);

                matrix.method_22905(0.5f, 0.5f, 0);

                guiGraphics.method_25291(Accessories.of("textures/gui/sprites/highlight/clickbait.png"), 0, 0, 0, 0, 0, 512, 512, 512, 512);

                matrix.method_22909();
            });
            this.accessoryPositions.clear();
        }

        this.method_2380(guiGraphics, mouseX, mouseY);

        if (!this.accessoryLines.isEmpty() && Accessories.getConfig().clientData.hoverOptions.hoveredOptions.line) {
            var buf = guiGraphics.method_51450().getBuffer(class_1921.field_21695);
            var lastPose = guiGraphics.method_51448().method_23760().method_23762();

            for (Pair<Vector3d, Vector3d> line : this.accessoryLines) {

                var normalVec = line.second().sub(line.first(), new Vector3d()).normalize().get(new Vector3f());

                double segments = Math.max(10, ((int) (line.first().distance(line.second()) * 10)) / 100);
                segments *= 2;

                var movement = (System.currentTimeMillis() / (segments * 1000) % 1);
                var delta = movement % (2 / (segments)) % segments;

                var firstVec = line.first().get(new Vector3f());

                if (delta > 0.05) {
                    buf.method_22912(firstVec.x(), firstVec.y(), firstVec.z())
                            .method_1336(255, 255, 255, 255)
                            .method_22922(class_4608.field_21444)
                            .method_22916(class_765.field_32769)
                            .method_23763(lastPose, normalVec.x, normalVec.y, normalVec.z)
                            .method_1344();

                    var pos = new Vector3d(
                            class_3532.method_16436(delta - 0.05, line.first().x, line.second().x),
                            class_3532.method_16436(delta - 0.05, line.first().y, line.second().y),
                            class_3532.method_16436(delta - 0.05, line.first().z, line.second().z)
                    ).get(new Vector3f());

                    buf.method_22912(pos.x(), pos.y(), pos.z())
                            .method_1336(255, 255, 255, 255)
                            .method_22922(class_4608.field_21444)
                            .method_22916(class_765.field_32769)
                            .method_23763(lastPose, normalVec.x, normalVec.y, normalVec.z)
                            .method_1344();
                }
                for (int i = 0; i < segments / 2; i++) {
                    var delta1 = ((i * 2) / segments + movement) % 1;
                    var delta2 = ((i * 2 + 1) / segments + movement) % 1;

                    var pos1 = new Vector3d(
                            class_3532.method_16436(delta1, line.first().x, line.second().x),
                            class_3532.method_16436(delta1, line.first().y, line.second().y),
                            class_3532.method_16436(delta1, line.first().z, line.second().z)
                    ).get(new Vector3f());
                    var pos2 = (delta2 > delta1 ? new Vector3d(
                            class_3532.method_16436(delta2, line.first().x, line.second().x),
                            class_3532.method_16436(delta2, line.first().y, line.second().y),
                            class_3532.method_16436(delta2, line.first().z, line.second().z)
                    ) : line.second()).get(new Vector3f());

                    buf.method_22912(pos1.x(), pos1.y(), pos1.z())
                            .method_1336(255, 255, 255, 255)
                            .method_22922(class_4608.field_21444)
                            .method_22916(class_765.field_32769)
                            .method_23763(lastPose, normalVec.x, normalVec.y, normalVec.z)
                            .method_1344();
                    buf.method_22912(pos2.x(), pos2.y(), pos2.z())
                            .method_1336(255, 255, 255, 255)
                            .method_22922(class_4608.field_21444)
                            .method_22916(class_765.field_32769)
                            .method_23763(lastPose, normalVec.x, normalVec.y, normalVec.z)
                            .method_1344();
                }
            }

            field_22787.method_22940().method_23000().method_22994(class_1921.field_21695);

            this.accessoryLines.clear();
        }
    }

    private class_4185 backButton = null;

    private class_4185 cosmeticToggleButton = null;
    private class_4185 linesToggleButton = null;

    private class_4185 unusedSlotsToggleButton = null;
    private class_4185 uniqueSlotsToggleButton = null;

    private class_4185 tabUpButton = null;
    private class_4185 tabDownButton = null;

    @Override
    protected void method_25426() {
        super.method_25426();

        this.currentTabPage = 1;

        this.cosmeticButtons.clear();

        this.backButton = this.method_37063(
                class_4185.method_46430(class_2561.method_43473(), (btn) -> this.field_22787.method_1507(new class_490(field_22787.field_1724)))
                        .method_46434(this.field_2776 + 141, this.field_2800 + 9, 8, 8)
                        .method_46436(class_7919.method_47407(class_2561.method_43471(Accessories.translation("back.screen"))))
                        .method_46431()).adjustRendering((button, guiGraphics, sprite, x, y, width, height) -> {
            guiGraphics.method_25290(SPRITES_8X8.getLocation(button), x, y, width, height, 8, 8, 8, 8);

            var pose = guiGraphics.method_51448();

//            pose.pushPose();
//            pose.translate(0.5, 0.5, 0.0);
//
//            guiGraphics.blitSprite(BACk_ICON, x, y, width - 1, height - 1);
//
//            pose.popPose();

            return true;
        });

        var cosmeticsOpen = this.field_2797.isCosmeticsOpen();

        this.cosmeticToggleButton = this.method_37063(
                class_4185.method_46430(class_2561.method_43473(), (btn) -> {
                            AccessoriesInternals.getNetworkHandler()
                                    .sendToServer(SyncHolderChange.of(HolderProperty.COSMETIC_PROP, this.method_17577().owner(), bl -> !bl));
                        })
                        .method_46436(cosmeticsToggleTooltip(cosmeticsOpen))
                        .method_46434(this.field_2776 - 27 + (cosmeticsOpen ? -20 : 0), this.field_2800 + 7, (cosmeticsOpen ? 38 : 18), 6)
                        .method_46431());

        var btnOffset = this.field_2800 + 7;

        this.unusedSlotsToggleButton = this.method_37063(
                class_4185.method_46430(class_2561.method_43473(), (btn) -> {
                            AccessoriesInternals.getNetworkHandler()
                                    .sendToServer(SyncHolderChange.of(HolderProperty.UNUSED_PROP, this.method_17577().owner(), bl -> !bl));
                        })
                        .method_46436(unusedSlotsToggleButton(this.field_2797.areUnusedSlotsShown()))
                        .method_46434(this.field_2776 + 154, btnOffset, 12, 12)
                        .method_46431()).adjustRendering((button, guiGraphics, sprite, x, y, width, height) -> {
            guiGraphics.method_25290(SPRITES_12X12.getLocation(button), x, y, width, height, 12, 12, 12, 12);
            guiGraphics.method_25290((this.field_2797.areUnusedSlotsShown() ? UNUSED_SLOTS_SHOWN : UNUSED_SLOTS_HIDDEN), x, y, width, height, 12, 12, 12, 12);

            return true;
        });

        btnOffset += 15;

        if (Accessories.getConfig().clientData.showUniqueRendering) {
            var anyUniqueSlots = EntitySlotLoader.getEntitySlots(this.targetEntityDefaulted()).values()
                    .stream()
                    .anyMatch(slotType -> UniqueSlotHandling.isUniqueSlot(slotType.name()));

            if (anyUniqueSlots) {
                this.uniqueSlotsToggleButton = this.method_37063(
                        class_4185.method_46430(class_2561.method_43473(), (btn) -> {
                                    AccessoriesInternals.getNetworkHandler()
                                            .sendToServer(SyncHolderChange.of(HolderProperty.UNIQUE_PROP, this.method_17577().owner(), bl -> !bl));
                                })
                                .method_46436(uniqueSlotsToggleButton(this.field_2797.areUniqueSlotsShown()))
                                .method_46434(this.field_2776 + 154, btnOffset, 12, 12)
                                .method_46431()).adjustRendering((button, guiGraphics, sprite, x, y, width, height) -> {
                    guiGraphics.method_25290(SPRITES_12X12.getLocation(button), x, y, width, height, 12, 12, 12, 12);
                    guiGraphics.method_25290((this.field_2797.areUniqueSlotsShown() ? UNUSED_SLOTS_SHOWN : UNUSED_SLOTS_HIDDEN), x, y, width, height, 12, 12, 12, 12);

                    return true;
                });

                btnOffset += 15;
            }
        }

//        if (Accessories.getConfig().clientData.showLineRendering) {
//            this.linesToggleButton = this.addRenderableWidget(
//                    Button.builder(Component.empty(), (btn) -> {
//                                AccessoriesInternals.getNetworkHandler()
//                                        .sendToServer(SyncHolderChange.of(HolderProperty.LINES_PROP, this.getMenu().owner(), bl -> !bl));
//                            })
//                            .bounds(this.leftPos + 154, btnOffset, 12, 12)
//                            //.bounds(this.leftPos - (this.menu.isCosmeticsOpen() ? 59 : 39), this.topPos + 7, 8, 6)
//                            .build()).adjustRendering((button, guiGraphics, sprite, x, y, width, height) -> {
//                guiGraphics.blit(SPRITES_12X12.getLocation(button), x, y, width, height, 12, 12, 12, 12);
//                guiGraphics.blit((this.menu.areLinesShown() ? LINE_SHOWN : LINE_HIDDEN), x, y, width, height, 12, 12, 12, 12);
//
//                return true;
//            });
//        }

        int accessoriesSlots = 0;

        for (class_1735 slot : this.field_2797.field_7761) {
            if (!(slot instanceof AccessoriesInternalSlot accessoriesSlot && !accessoriesSlot.isCosmetic)) continue;

            var slotButton = ToggleButton.ofSlot(slot.field_7873 + this.field_2776 + 13, slot.field_7872 + this.field_2800 - 2, 300, accessoriesSlot);

            slotButton.field_22764 = accessoriesSlot.method_7682();
            slotButton.field_22763 = accessoriesSlot.method_7682();

            cosmeticButtons.put(accessoriesSlot, this.method_25429(slotButton));

            accessoriesSlots++;
        }

        if (tabPageCount() > 1) {
            this.tabDownButton = this.method_37063(
                    class_4185.method_46430(class_2561.method_43470("⬆"), button -> this.onTabPageChange(true))
                            .method_46434(this.field_2776 - 56, this.field_2800 - 11, 10, 10)
                            .method_46431());

            this.tabDownButton.field_22763 = false;

            var height = getPanelHeight();

            this.tabUpButton = this.method_37063(
                    class_4185.method_46430(class_2561.method_43470("⬇"), button -> this.onTabPageChange(false))
                            .method_46434(this.field_2776 - 56, this.field_2800 + height + 0, 10, 10)
                            .method_46431());

            this.tabUpButton.method_47400(class_7919.method_47407(class_2561.method_43470("Page 2")));

            this.tabUpButton.field_22763 = tabPageCount() != 1;
        }

        this.field_2797.setScrollEvent(this::updateAccessoryToggleButtons);

        this.scrollBarHeight = class_3532.method_48781(Math.min(accessoriesSlots / 20f, 1.0f), 101, 31);

        if (this.scrollBarHeight % 2 == 0) this.scrollBarHeight++;
    }

    private void onTabPageChange(boolean isDown) {
        if ((this.currentTabPage <= 1 && isDown) || (this.currentTabPage > tabPageCount() && !isDown)) {
            return;
        }

        this.currentTabPage += (isDown) ? -1 : 1;

        var lowerLabel = "Page " + (this.currentTabPage - 1);
        var upperLabel = "Page " + (this.currentTabPage + 1);

        this.tabDownButton.method_47400(class_7919.method_47407(class_2561.method_43470(lowerLabel)));
        this.tabUpButton.method_47400(class_7919.method_47407(class_2561.method_43470(upperLabel)));

//        this.tabDownButton.setMessage(Component.literal(lowerLabel));
//        this.tabUpButton.setMessage(Component.literal(upperLabel));

        if (this.currentTabPage <= 1) {
            this.tabDownButton.field_22763 = false;
        } else if (!this.tabDownButton.field_22763) {
            this.tabDownButton.field_22763 = true;
        }

        if (this.currentTabPage >= tabPageCount()) {
            this.tabUpButton.field_22763 = false;
        } else if (!this.tabUpButton.field_22763) {
            this.tabUpButton.field_22763 = true;
        }
    }

    public void updateButtons(String name) {
        switch (name) {
            case "lines" -> updateLinesButton();
            case "cosmetic" -> updateCosmeticToggleButton();
            case "unused_slots" -> updateUnusedSlotToggleButton();
            case "unique_slots" -> updateUniqueSlotToggleButton();
        }
    }

    public void updateLinesButton() {
//        if (Accessories.getConfig().clientData.showLineRendering) {
//            this.linesToggleButton.setTooltip(linesToggleTooltip(this.menu.areLinesShown()));
//        }
    }

    public void updateCosmeticToggleButton() {
        var btn = this.cosmeticToggleButton;
        btn.method_25358(this.field_2797.isCosmeticsOpen() ? 38 : 18);
        btn.method_46421(btn.method_46426() + (this.field_2797.isCosmeticsOpen() ? -20 : 20));
        btn.method_47400(cosmeticsToggleTooltip(this.field_2797.isCosmeticsOpen()));
    }

    public void updateUnusedSlotToggleButton() {
        this.unusedSlotsToggleButton.method_47400(unusedSlotsToggleButton(this.field_2797.areUnusedSlotsShown()));
        this.field_2797.reopenMenu();
    }

    public void updateUniqueSlotToggleButton() {
        this.uniqueSlotsToggleButton.method_47400(uniqueSlotsToggleButton(this.field_2797.areUniqueSlotsShown()));
        this.field_2797.reopenMenu();
    }

    public void updateAccessoryToggleButtons() {
        for (var entry : cosmeticButtons.entrySet()) {
            var accessoriesSlot = entry.getKey();
            var btn = entry.getValue();

            if (!accessoriesSlot.method_7682()) {
                btn.field_22763 = false;
                btn.field_22764 = false;
            } else {
                btn.method_47400(toggleTooltip(accessoriesSlot.accessoriesContainer.shouldRender(accessoriesSlot.method_34266())));

                btn.method_46421(accessoriesSlot.field_7873 + this.field_2776 + 13);
                btn.method_46419(accessoriesSlot.field_7872 + this.field_2800 - 2);

                btn.toggled(accessoriesSlot.accessoriesContainer.shouldRender(accessoriesSlot.method_34266()));

                btn.field_22763 = true;
                btn.field_22764 = true;
            }
        }
    }

    private static class_7919 cosmeticsToggleTooltip(boolean value) {
        return createToggleTooltip("slot.cosmetics", value);
    }

    private static class_7919 linesToggleTooltip(boolean value) {
        return createToggleTooltip("lines", value);
    }

    private static class_7919 unusedSlotsToggleButton(boolean value) {
        return createToggleTooltip("unused_slots", value);
    }

    private static class_7919 uniqueSlotsToggleButton(boolean value) {
        return createToggleTooltip("unique_slots", value);
    }

    private static class_7919 toggleTooltip(boolean value) {
        return createToggleTooltip("display", value);
    }

    private static class_7919 createToggleTooltip(String type, boolean value) {
        var key = type + ".toggle." + (!value ? "show" : "hide");

        return class_7919.method_47407(class_2561.method_43471(Accessories.translation(key)));
    }

    @Override
    public @Nullable Boolean isHovering(class_1735 slot, double mouseX, double mouseY) {
        for (var child : this.method_25396()) {
            if (child instanceof ToggleButton btn && btn.method_25405(mouseX, mouseY)) return false;
        }

        return ContainerScreenExtension.super.isHovering(slot, mouseX, mouseY);
    }

    @Override
    protected void method_2380(class_332 guiGraphics, int x, int y) {
        if (this.field_2787 instanceof AccessoriesInternalSlot slot) {
            FORCE_TOOLTIP_LEFT = true;

            if (slot.method_7677().method_7960() && slot.accessoriesContainer.slotType() != null) {
                guiGraphics.method_51437(class_310.method_1551().field_1772, slot.getTooltipData(), Optional.empty(), x, y);

                return;
            }
        }

        if (Accessories.getConfig().clientData.showGroupTabs) {
            int panelX = getStartingPanelX();
            int panelY = this.field_2800;

            for (var entry : getGroups(panelX, panelY).entrySet()) {
                if (!entry.getValue().isInBounds(x, y)) continue;

                var tooltipData = new ArrayList<class_2561>();
                var group = entry.getKey();

                tooltipData.add(class_2561.method_43471(group.translation()));
                if (UniqueSlotHandling.isUniqueGroup(group.name(), true)) tooltipData.add(class_2561.method_43470(group.name()).method_27695(class_124.field_1078, class_124.field_1056));

                guiGraphics.method_51437(class_310.method_1551().field_1772, tooltipData, Optional.empty(), x, y);

                break;
            }
        }

        super.method_2380(guiGraphics, x, y);

        FORCE_TOOLTIP_LEFT = false;
    }

    @Override
    protected boolean method_2381(double mouseX, double mouseY, int x, int y, int mouseButton) {
        int leftPos = this.field_2776;
        int topPos = this.field_2800;

        boolean insideMainPanel = (mouseX >= leftPos && mouseX <= leftPos + this.field_2792)
                && (mouseY >= topPos && mouseY <= topPos + this.field_2779);

        int sidePanelX = getStartingPanelX();
        int sidePanelY = topPos;

        boolean insideSidePanel = (mouseX >= sidePanelX && mouseX <= sidePanelX + this.getPanelWidth() + this.field_2792)
                && (mouseY >= sidePanelY && mouseY <= sidePanelY + this.getPanelHeight());

        boolean insideGroupPanel = false;

        if (Accessories.getConfig().clientData.showGroupTabs && this.field_2797.maxScrollableIndex() > 0) {
            for (var value : this.getGroups(sidePanelX, sidePanelY).values()) {
                if (value.isInBounds((int) Math.round(mouseX), (int) Math.round(mouseY))) {
                    insideGroupPanel = true;
                    break;
                }
            }
        }

        return !(insideMainPanel || insideSidePanel || insideGroupPanel);
    }

    public static int tabPageCount() {
        var groups = SlotGroupLoader.INSTANCE.getGroups(true, true);

        return (int) Math.ceil(groups.size() / 9f);
    }

    // MAX 9
    private Map<SlotGroup, SlotGroupData> getGroups(int x, int y) {
        var groups = this.method_17577().validGroups().stream()
                .sorted(Comparator.comparingInt(SlotGroup::order).reversed())
                .toList();

        if (tabPageCount() > 1) {
            var lowerBound = (this.currentTabPage - 1) * 9;
            var upperBound = lowerBound + 9;

            if (upperBound > groups.size()) upperBound = groups.size();

            groups = groups.subList(lowerBound, upperBound);
        }

        var bottomIndex = this.field_2797.scrolledIndex;
        var upperIndex = bottomIndex + 8 - 1;

        var scrollRange = Range.between(bottomIndex, upperIndex, Integer::compareTo);

        var targetEntity = this.targetEntityDefaulted();
        var containers = targetEntity.accessoriesCapability().getContainers();

        var slotToSize = new HashMap<String, Integer>();

        for (var slotType : EntitySlotLoader.getEntitySlots(targetEntity).values()) {
            var usedSlots = this.method_17577().usedSlots();
            if (usedSlots != null && !usedSlots.contains(slotType)) continue;

            var container = containers.get(slotType.name());
            if(container == null) continue;

            slotToSize.put(slotType.name(), container.getAccessories().method_5439());
        }

        int currentIndexOffset = 0;

        var groupToIndex = new HashMap<SlotGroup, Integer>();
        var selectedGroup = new HashSet<String>();

        for (var group : groups) {
            var groupSize = slotToSize.entrySet().stream()
                    .filter(entry -> group.slots().contains(entry.getKey()))
                    .mapToInt(Map.Entry::getValue)
                    .sum();

            if (groupSize <= 0) continue;

            var groupMinIndex = currentIndexOffset;
            var groupMaxIndex = groupMinIndex + groupSize - 1;

            var groupRange = Range.between(groupMinIndex, groupMaxIndex, Integer::compareTo);

            if (groupRange.isOverlappedBy(scrollRange)) {
                selectedGroup.add(group.name());
            }

            groupToIndex.put(group, groupMinIndex);

            currentIndexOffset += groupSize;
        }

        int maxHeight = getPanelHeight() - 4;

        int width = 19;//32;
        int height = 16;//28;

        int tabY = y + 4;
        int tabX = x - (width - 10);

        int yOffset = 0;

        var groupValues = new HashMap<SlotGroup, SlotGroupData>();

        for (var group : groups) {
            if ((yOffset + height) > maxHeight) break;

            var selected = selectedGroup.contains(group.name());

            int xOffset = (selected) ? 0 : 2;

            var index = groupToIndex.get(group);

            if (index == null) continue;

            groupValues.put(group, new SlotGroupData(new Vector4i(tabX + xOffset, tabY + yOffset, width - xOffset, height), selected, index));

            yOffset += height + 1;
        }

        return groupValues;
    }

    private static SlotGroupImpl copy(SlotGroup group) {
        return new SlotGroupImpl(group.name() + 1, group.order(), group.slots(), group.icon());
    }

    private record SlotGroupData(Vector4i dimensions, boolean isSelected, int startingIndex) {
        private boolean isInBounds(int x, int y) {
            return (x > dimensions.x) && (y > dimensions.y) && (x < dimensions.x + dimensions.z) && (y < dimensions.y + dimensions.w);
        }
    }

    //--

    private void renderEntityInInventoryFollowingMouseRotated(class_332 guiGraphics, Vector2i pos, Vector2i size, Vector2i scissorStart, Vector2i scissorEnd, float mouseX, float mouseY, float rotation) {
        int scale = 30;
        float yOffset = 0.0625F;
        var entity = this.targetEntityDefaulted();

        float f = (float) (pos.x + pos.x + size.x) / 2.0F;
        float g = (float) (pos.y + pos.y + size.y) / 2.0F;
        guiGraphics.method_44379(scissorStart.x, scissorStart.y, scissorEnd.x, scissorEnd.y);
        float h = (float) Math.atan(((scissorStart.x + scissorStart.x + size.x) / 2f - mouseX) / 40.0F);
        float i = (float) Math.atan(((scissorStart.y + scissorStart.y + size.y) / 2f - mouseY) / 40.0F);
        Quaternionf quaternionf = (new Quaternionf()).rotateZ(3.1415927F).rotateY((float) (rotation * (Math.PI / 180)));
        Quaternionf quaternionf2 = (new Quaternionf()).rotateX(i * 20.0F * 0.017453292F);
        quaternionf.mul(quaternionf2);
        float j = entity.field_6283;
        float k = entity.method_36454();
        float l = entity.method_36455();
        float m = entity.field_6259;
        float n = entity.field_6241;
        entity.field_6283 = 180.0F + h * 30.0F;
        entity.method_36456(180.0F + h * 40.0F);
        entity.method_36457(-i * 20.0F);
        entity.field_6241 = entity.method_36454();
        entity.field_6259 = entity.method_36454();
        //Vector3f vector3f = new Vector3f(0.0F, entity.getBbHeight() / 2.0F + yOffset, 0.0F);
        class_490.method_48472(guiGraphics, (int) f, (int) (g + (entity.method_17682() * 17 + yOffset)), 28, quaternionf, quaternionf2, entity);
        entity.field_6283 = j;
        entity.method_36456(k);
        entity.method_36457(l);
        entity.field_6259 = m;
        entity.field_6241 = n;
        guiGraphics.method_44380();
    }

    public class_1735 getHoveredSlot() {
        return this.field_2787;
    }
}
