package io.wispforest.accessories.commands;

import I;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.LiteralMessage;
import com.mojang.brigadier.arguments.BoolArgumentType;
import com.mojang.brigadier.arguments.DoubleArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.Dynamic3CommandExceptionType;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import com.mojang.logging.LogUtils;
import io.wispforest.accessories.Accessories;
import io.wispforest.accessories.AccessoriesInternals;
import io.wispforest.accessories.api.components.AccessoriesDataComponents;
import io.wispforest.accessories.api.components.AccessoryItemAttributeModifiers;
import io.wispforest.accessories.api.components.AccessorySlotValidationComponent;
import io.wispforest.accessories.api.components.AccessoryStackSizeComponent;
import io.wispforest.accessories.api.slot.SlotGroup;
import io.wispforest.accessories.api.slot.SlotType;
import io.wispforest.accessories.data.EntitySlotLoader;
import io.wispforest.accessories.data.SlotGroupLoader;
import io.wispforest.accessories.data.SlotTypeLoader;
import io.wispforest.accessories.utils.AttributeUtils;
import it.unimi.dsi.fastutil.Pair;
import org.apache.commons.lang3.mutable.MutableBoolean;
import org.slf4j.Logger;

import java.util.Arrays;
import java.util.Locale;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1320;
import net.minecraft.class_1322;
import net.minecraft.class_1322.class_1323;
import net.minecraft.class_1799;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2186;
import net.minecraft.class_2232;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_6880;
import net.minecraft.class_7157;

public class AccessoriesCommands {

    public static final SimpleCommandExceptionType NON_LIVING_ENTITY_TARGET = new SimpleCommandExceptionType(class_2561.method_43471("argument.livingEntities.nonLiving"));

    public static final SimpleCommandExceptionType INVALID_SLOT_TYPE = new SimpleCommandExceptionType(new LiteralMessage("Invalid Slot Type"));

    public static final Logger LOGGER = LogUtils.getLogger();

    public static void registerCommandArgTypes() {
        AccessoriesInternals.registerCommandArgumentType(Accessories.of("slot_type"), SlotArgumentType.class, RecordArgumentTypeInfo.of(ctx -> SlotArgumentType.INSTANCE));
        AccessoriesInternals.registerCommandArgumentType(Accessories.of("resource"), ResourceExtendedArgument.class, RecordArgumentTypeInfo.of(ResourceExtendedArgument::attributes));
    }

    public static class_1309 getOrThrowLivingEntity(CommandContext<class_2168> ctx) throws CommandSyntaxException {
        var entity = class_2186.method_9313(ctx, "entity");

        if(!(entity instanceof class_1309 livingEntity)) {
            throw NON_LIVING_ENTITY_TARGET.create();
        }

        return livingEntity;
    }

    //accessories edit {}
    public static void registerCommands(CommandDispatcher<class_2168> dispatcher, class_7157 context) {
        dispatcher.register(
                class_2170.method_9247("accessories")
                        .requires(commandSourceStack -> commandSourceStack.method_9259(class_2170.field_31839))
                        .then(
                                class_2170.method_9247("edit")
                                        .then(
                                                class_2170.method_9244("entity", class_2186.method_9309())
                                                        .executes((ctx) -> {
                                                            var player = ctx.getSource().method_9207();

                                                            Accessories.openAccessoriesMenu(player, getOrThrowLivingEntity(ctx));

                                                            return 1;
                                                        })
                                        )
                                        .executes(ctx -> {
                                            return Accessories.attemptOpenScreenPlayer(ctx.getSource().method_9207())
                                                    ? 1
                                                    : 0;
                                        })
                        )
                        .then(
                                class_2170.method_9247("slot")
                                        .then(
                                                class_2170.method_9247("add")
                                                        .then(
                                                                class_2170.method_9247("valid")
                                                                        .then(class_2170.method_9244("slot", SlotArgumentType.INSTANCE)
                                                                                .executes(ctx -> adjustSlotValidationOnStack(0, ctx.getSource().method_9207(), ctx))
                                                                        ))
                                                        .then(
                                                                class_2170.method_9247("invalid")
                                                                        .then(class_2170.method_9244("slot", SlotArgumentType.INSTANCE)
                                                                                .executes(ctx -> adjustSlotValidationOnStack(1, ctx.getSource().method_9207(), ctx))
                                                                        ))

                                        ).then(
                                                class_2170.method_9247("remove")
                                                        .then(
                                                                class_2170.method_9247("valid")
                                                                        .then(class_2170.method_9244("slot", SlotArgumentType.INSTANCE)
                                                                                .executes(ctx -> adjustSlotValidationOnStack(2, ctx.getSource().method_9207(), ctx))
                                                                        ))
                                                        .then(
                                                                class_2170.method_9247("invalid")
                                                                        .then(class_2170.method_9244("slot", SlotArgumentType.INSTANCE)
                                                                                .executes(ctx -> adjustSlotValidationOnStack(3, ctx.getSource().method_9207(), ctx))
                                                                        ))
                                        )
                        )
                        .then(
                                class_2170.method_9247("stack-sizing")
                                        .then(
                                                class_2170.method_9247("useStackSize")
                                                        .then(
                                                                class_2170.method_9244("value", BoolArgumentType.bool())
                                                                        .executes(ctx -> {
                                                                            var player = ctx.getSource().method_9207();

                                                                            var bl = ctx.getArgument("value", Boolean.class);

                                                                            AccessoriesDataComponents.update(
                                                                                    AccessoriesDataComponents.STACK_SIZE,
                                                                                    player.method_6047(),
                                                                                    component -> component.useStackSize(bl));

                                                                            return 1;
                                                                        })
                                                        )
                                        ).then(
                                                class_2170.method_9244("value", IntegerArgumentType.integer())
                                                        .executes(ctx -> {
                                                            var player = ctx.getSource().method_9207();

                                                            var size = ctx.getArgument("value", Integer.class);

                                                            AccessoriesDataComponents.update(
                                                                    AccessoriesDataComponents.STACK_SIZE,
                                                                    player.method_6047(),
                                                                    component -> component.sizeOverride(size));

                                                            return 1;
                                                        })
                                        )
                        )
                        .then(
                                class_2170.method_9247("attribute")
                                        .then(
                                                class_2170.method_9247("modifier")
                                                        .then(
                                                                class_2170.method_9247("add")
                                                                        .then(
                                                                                class_2170.method_9244("attribute", ResourceExtendedArgument.attributes(context))
                                                                                        .then(
                                                                                                class_2170.method_9244("id", class_2232.method_9441())
                                                                                                        .then(class_2170.method_9244("value", DoubleArgumentType.doubleArg())
                                                                                                                        .then(createAddLiteral("addition"))
                                                                                                                        .then(createAddLiteral("multiply_base"))
                                                                                                                        .then(createAddLiteral("multiply_total"))
                                                                                                        )
                                                                                        )
                                                                        )
                                                        )
                                                        .then(
                                                                class_2170.method_9247("remove")
                                                                        .then(
                                                                                class_2170.method_9244("attribute", ResourceExtendedArgument.attributes(context))
                                                                                        .then(
                                                                                                class_2170.method_9244("id", class_2232.method_9441())
                                                                                                        .executes(
                                                                                                                ctx -> removeModifier(
                                                                                                                        ctx.getSource(),
                                                                                                                        ctx.getSource().method_9207(),
                                                                                                                        ResourceExtendedArgument.getAttribute(ctx, "attribute"),
                                                                                                                        class_2232.method_9443(ctx, "id")
                                                                                                                )
                                                                                                        )
                                                                                        )
                                                                        )
                                                        )
                                                        .then(
                                                                class_2170.method_9247("get")
                                                                        .then(
                                                                                class_2170.method_9244("attribute", ResourceExtendedArgument.attributes(context))
                                                                                        .then(
                                                                                                class_2170.method_9244("id", class_2232.method_9441())
                                                                                                        .executes(
                                                                                                                ctx -> getAttributeModifier(
                                                                                                                        ctx.getSource(),
                                                                                                                        ctx.getSource().method_9207(),
                                                                                                                        ResourceExtendedArgument.getAttribute(ctx, "attribute"),
                                                                                                                        class_2232.method_9443(ctx, "id"),
                                                                                                                        1.0
                                                                                                                )
                                                                                                        )
                                                                                                        .then(
                                                                                                                class_2170.method_9244("scale", DoubleArgumentType.doubleArg())
                                                                                                                        .executes(
                                                                                                                                ctx -> getAttributeModifier(
                                                                                                                                        ctx.getSource(),
                                                                                                                                        ctx.getSource().method_9207(),
                                                                                                                                        ResourceExtendedArgument.getAttribute(ctx, "attribute"),
                                                                                                                                        class_2232.method_9443(ctx, "id"),
                                                                                                                                        DoubleArgumentType.getDouble(ctx, "scale")
                                                                                                                                )
                                                                                                                        )
                                                                                                        )
                                                                                        )
                                                                        )
                                                        )
                                        )
                        ).then(
                                class_2170.method_9247("log")
                                        .then(
                                                class_2170.method_9247("slots")
                                                        .executes(ctx -> {
                                                            LOGGER.info("All given Slots registered:");

                                                            for (var slotType : SlotTypeLoader.getSlotTypes(ctx.getSource().method_9225()).values()) {
                                                                LOGGER.info(slotType.toString());
                                                            }

                                                            return 1;
                                                        })
                                        )
                                        .then(
                                                class_2170.method_9247("groups")
                                                        .executes(ctx -> {
                                                            LOGGER.info("All given Slot Groups registered:");

                                                            for (var group : SlotGroupLoader.getGroups(ctx.getSource().method_9225())) {
                                                                LOGGER.info(group.toString());
                                                            }

                                                            return 1;
                                                        })
                                        )
                                        .then(
                                                class_2170.method_9247("entity_bindings")
                                                        .executes(ctx -> {
                                                            LOGGER.info("All given Entity Bindings registered:");

                                                            EntitySlotLoader.INSTANCE.getEntitySlotData(false).forEach((type, slots) -> {
                                                                LOGGER.info("[{}]: {}", type, slots.keySet());
                                                            });

                                                            return 1;
                                                        })
                                        )
                        )
        );
    }

    private static LiteralArgumentBuilder<class_2168> createAddLiteral(String literal) {
        var selectedValue = Arrays.stream(class_1322.class_1323.values())
                .filter(value -> value.name().toLowerCase(Locale.ROOT).equals(literal))
                .findFirst()
                .orElse(null);

        if(selectedValue == null) throw new IllegalStateException("Unable to handle the given literal as its not a valid AttributeModifier Operation! [Literal: " + literal + "]");

        return class_2170.method_9247(literal)
                .then(
                        class_2170.method_9244("slot", SlotArgumentType.INSTANCE)
                                .then(
                                        class_2170.method_9244("isStackable", BoolArgumentType.bool())
                                                .executes(
                                                        ctx -> addModifier(
                                                                ctx.getSource(),
                                                                ctx.getSource().method_9207(),
                                                                ResourceExtendedArgument.getAttribute(ctx, "attribute"),
                                                                class_2232.method_9443(ctx, "id"),
                                                                DoubleArgumentType.getDouble(ctx, "value"),
                                                                selectedValue,
                                                                SlotArgumentType.getSlot(ctx, "slot"),
                                                                BoolArgumentType.getBool(ctx, "isStackable")
                                                        )
                                                )
                                )
                );
    }

    private static int getAttributeModifier(class_2168 commandSourceStack, class_1309 livingEntity, class_6880<class_1320> holder, class_2960 resourceLocation, double d) throws CommandSyntaxException {
        var stack = livingEntity.method_6047();

        var component = AccessoriesDataComponents.readOrDefault(AccessoriesDataComponents.ATTRIBUTES, stack);

        var modifier = component.getModifier(holder.comp_349(), resourceLocation);

        if (modifier == null) {
            throw ERROR_NO_SUCH_MODIFIER.create(stack.method_7954(), getAttributeDescription(holder), resourceLocation);
        }

        double e = modifier.method_6186();

        commandSourceStack.method_9226(
                () -> class_2561.method_43469(
                        "commands.attribute.modifier.value.get.success_itemstack", resourceLocation, getAttributeDescription(holder), stack.method_7954(), e
                ),
                false
        );

        return (int)(e * d);
    }

    private static final Dynamic3CommandExceptionType ERROR_MODIFIER_ALREADY_PRESENT = new Dynamic3CommandExceptionType(
            (var1, var2, var3) -> class_2561.method_43469("commands.attribute.failed.modifier_already_present_itemstack", var1, var2, var3)
    );

    private static int addModifier(class_2168 commandSourceStack, class_1309 livingEntity, class_6880<class_1320> holder, class_2960 resourceLocation, double d, class_1322.class_1323 operation, String slotName, boolean isStackable) throws CommandSyntaxException {
        var stack = livingEntity.method_6047();

        var component = AccessoriesDataComponents.readOrDefault(AccessoriesDataComponents.ATTRIBUTES, stack);

        if (component.hasModifier(holder.comp_349(), resourceLocation)) {
            throw ERROR_MODIFIER_ALREADY_PRESENT.create(resourceLocation, getAttributeDescription(holder), stack.method_7954());
        }

        var data = AttributeUtils.getModifierData(resourceLocation);

        AccessoriesDataComponents.write(
                AccessoriesDataComponents.ATTRIBUTES,
                stack,
                component.withModifierAdded(holder.comp_349(), new class_1322(data.second(), data.first(), d, operation), slotName, isStackable));

        commandSourceStack.method_9226(
                () -> class_2561.method_43469(
                        "commands.attribute.modifier.add.success_itemstack", resourceLocation, getAttributeDescription(holder), stack.method_7954()
                ),
                false
        );

        return 1;
    }

    private static final Dynamic3CommandExceptionType ERROR_NO_SUCH_MODIFIER = new Dynamic3CommandExceptionType(
            (var1, var2, var3) -> class_2561.method_43469("commands.attribute.failed.no_modifier_itemstack", var1, var2, var3)
    );

    private static int removeModifier(class_2168 commandSourceStack, class_1309 livingEntity, class_6880<class_1320> holder, class_2960 resourceLocation) throws CommandSyntaxException {
        MutableBoolean removedModifier = new MutableBoolean(false);

        var stack = livingEntity.method_6047();

        AccessoriesDataComponents.update(AccessoriesDataComponents.ATTRIBUTES, stack, component -> {
            var size = component.modifiers().size();

            component = component.withoutModifier(holder, resourceLocation);

            if(size != component.modifiers().size()) removedModifier.setTrue();

            return component;
        });

        if(!removedModifier.getValue()) {
            throw ERROR_NO_SUCH_MODIFIER.create(resourceLocation, getAttributeDescription(holder), stack.method_7954());
        }

        commandSourceStack.method_9226(
                () -> class_2561.method_43469(
                        "commands.attribute.modifier.remove.success_itemstack", resourceLocation, getAttributeDescription(holder), stack.method_7954()
                ),
                false
        );

        return 1;
    }

    private static class_2561 getAttributeDescription(class_6880<class_1320> attribute) {
        return class_2561.method_43471(attribute.comp_349().method_26830());
    }

    private static int adjustSlotValidationOnStack(int operation, class_1309 player, CommandContext<class_2168> ctx) {
        var slotName = SlotArgumentType.getSlot(ctx, "slot");

        AccessoriesDataComponents.update(
                AccessoriesDataComponents.SLOT_VALIDATION,
                player.method_6047(),
                component -> {
                    return switch (operation) {
                        case 0 -> component.addValidSlot(slotName);
                        case 1 -> component.addInvalidSlot(slotName);
                        case 2 -> component.removeValidSlot(slotName);
                        case 3 -> component.removeInvalidSlot(slotName);
                        default -> throw new IllegalStateException("Unexpected value: " + operation);
                    };
                }
        );

        return 1;
    }

}
