package io.wispforest.accessories.criteria;

import com.google.gson.JsonObject;
import io.wispforest.accessories.Accessories;
import io.wispforest.accessories.api.slot.SlotReference;
import io.wispforest.accessories.data.SlotGroupLoader;
import io.wispforest.endec.*;
import io.wispforest.endec.format.gson.GsonDeserializer;
import io.wispforest.endec.format.gson.GsonEndec;
import io.wispforest.endec.impl.StructEndecBuilder;
import net.minecraft.advancements.critereon.*;
import net.minecraft.class_1799;
import net.minecraft.class_195;
import net.minecraft.class_2073;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_4558;
import net.minecraft.class_5257;
import net.minecraft.class_5258;
import java.util.List;
import java.util.Optional;

public class AccessoryChangedCriterion extends class_4558<AccessoryChangedCriterion.Conditions> {

    private final class_2960 location;

    public AccessoryChangedCriterion(class_2960 location) {
        this.location = location;
    }

    public void trigger(class_3222 player, class_1799 accessory, SlotReference reference, Boolean cosmetic) {
        this.method_22510(player, conditions -> {
            return conditions.itemPredicates().map(predicates -> predicates.stream().allMatch(predicate -> predicate.method_8970(accessory))).orElse(true)
                    && conditions.groups().flatMap(groups -> SlotGroupLoader.INSTANCE.findGroup(false, reference.slotName()).map(group -> groups.stream().noneMatch(s -> s.equals(group.name())))).orElse(true)
                    && conditions.slots().map(slots -> slots.stream().noneMatch(reference.slotName()::equals)).orElse(true)
                    && conditions.indices().map(indices -> indices.stream().noneMatch(index -> index == reference.slot())).orElse(true)
                    && conditions.cosmetic().map(isCosmetic -> isCosmetic && cosmetic).orElse(true);
        });
    }

    @Override
    protected Conditions method_27854(JsonObject jsonObject, class_5258 contextAwarePredicate, class_5257 deserializationContext) {
        var ctx = SerializationContext.attributes(new ContextAwarePredicateAttribute(contextAwarePredicate), new CriterionIdAttribute(this.method_794()));

        return Conditions.ENDEC.decodeFully(ctx, GsonDeserializer::of, jsonObject);
    }

    public static class Conditions extends class_195 {
        private static final Endec<Conditions> ENDEC = StructEndecBuilder.of(
                CRITERION_ID.flatFieldOf(conditions -> conditions.method_806()),
                CONTEXT_AWARE_PREDICATE_ENDEC.flatFieldOf(conditions -> conditions.method_27790()),
                ITEM_PREDICATE_ENDEC.listOf().optionalOf().optionalFieldOf("items", Conditions::itemPredicates, () -> Optional.empty()),
                Endec.STRING.listOf().optionalOf().optionalFieldOf("groups", Conditions::groups, () -> Optional.empty()),
                Endec.STRING.listOf().optionalOf().optionalFieldOf("slots", Conditions::slots, () -> Optional.empty()),
                Endec.INT.listOf().optionalOf().optionalFieldOf("indices", Conditions::indices, () -> Optional.empty()),
                Endec.BOOLEAN.optionalOf().optionalFieldOf("cosmetic", Conditions::cosmetic, () -> Optional.empty()),
                Conditions::new);

        private final Optional<List<class_2073>> itemPredicates;
        private final Optional<List<String>> groups;
        private final Optional<List<String>> slots;
        private final Optional<List<Integer>> indices;
        private final Optional<Boolean> cosmetic;

        public Conditions(
                class_2960 id,
                class_5258 player,
                Optional<List<class_2073>> itemPredicates,
                Optional<List<String>> groups,
                Optional<List<String>> slots,
                Optional<List<Integer>> indices,
                Optional<Boolean> cosmetic
        ) {
            super(id, player);

            this.itemPredicates = itemPredicates;
            this.groups = groups;
            this.slots = slots;
            this.indices = indices;
            this.cosmetic = cosmetic;
        }

        public Optional<class_5258> player() {
            return Optional.of(this.method_27790());
        }

        public Optional<List<class_2073>> itemPredicates() {
            return itemPredicates;
        }

        public Optional<List<String>> groups() {
            return groups;
        }

        public Optional<List<String>> slots() {
            return slots;
        }

        public Optional<List<Integer>> indices() {
            return indices;
        }

        public Optional<Boolean> cosmetic() {
            return cosmetic;
        }
    }

    @Override
    public class_2960 method_794() {
        return location;
    }

    private static final Endec<class_2073> ITEM_PREDICATE_ENDEC = GsonEndec.INSTANCE.xmap(class_2073::method_8969, class_2073::method_8971);
    private static final StructEndec<class_5258> CONTEXT_AWARE_PREDICATE_ENDEC = new StructEndec<>() {
        @Override
        public void encodeStruct(SerializationContext ctx, Serializer<?> serializer, Serializer.Struct struct, class_5258 value) {}

        @Override
        public class_5258 decodeStruct(SerializationContext ctx, Deserializer<?> deserializer, Deserializer.Struct struct) {
            return ctx.requireAttributeValue(ContextAwarePredicateAttribute.INSTANCE).predicate();
        }
    };

    private static final StructEndec<class_2960> CRITERION_ID = new StructEndec<>() {
        @Override
        public void encodeStruct(SerializationContext ctx, Serializer<?> serializer, Serializer.Struct struct, class_2960 value) {}

        @Override
        public class_2960 decodeStruct(SerializationContext ctx, Deserializer<?> deserializer, Deserializer.Struct struct) {
            return ctx.requireAttributeValue(CriterionIdAttribute.INSTANCE).id();
        }
    };

    public record ContextAwarePredicateAttribute(class_5258 predicate) implements SerializationAttribute.Instance {

        public static final SerializationAttribute.WithValue<ContextAwarePredicateAttribute> INSTANCE = SerializationAttribute.withValue("accessories:context_aware_predicate");

        @Override
        public SerializationAttribute attribute() {
            return INSTANCE;
        }

        @Override
        public Object value() {
            return this;
        }
    }

    public record CriterionIdAttribute(class_2960 id) implements SerializationAttribute.Instance {

        public static final SerializationAttribute.WithValue<CriterionIdAttribute> INSTANCE = SerializationAttribute.withValue("accessories:criterion_id");

        @Override
        public SerializationAttribute attribute() {
            return INSTANCE;
        }

        @Override
        public Object value() {
            return this;
        }
    }
}