package io.wispforest.accessories.data;

import com.google.gson.*;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;

import java.io.IOException;
import java.io.Reader;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Map.Entry;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import net.minecraft.class_2960;
import net.minecraft.class_3298;
import net.minecraft.class_3300;
import net.minecraft.class_3518;
import net.minecraft.class_3695;
import net.minecraft.class_4080;
import net.minecraft.class_7654;

public abstract class ReplaceableJsonResourceReloadListener extends class_4080<Map<class_2960, JsonObject>> {

    private final Logger logger;
    private final Gson gson;

    protected final String directory;

    protected ReplaceableJsonResourceReloadListener(Gson gson, Logger logger, String directory){
        this.logger = logger;
        this.gson = gson;

        this.directory = directory;
    }

    @Override
    protected Map<class_2960, JsonObject> method_18789(class_3300 resourceManager, class_3695 profiler) {
        var fileToIdConverter = class_7654.method_45114(directory);

        var output = new HashMap<class_2960, JsonObject>();

        for(var entry : fileToIdConverter.method_45116(resourceManager).entrySet()) {
            var filePath = entry.getKey();
            var resourceLocation = fileToIdConverter.method_45115(entry.getKey());

            for (class_3298 resource : entry.getValue()) {
                try(Reader reader = resource.method_43039()) {
                    var jsonElement = class_3518.method_15276(gson, reader, JsonElement.class);

                    if(!(jsonElement instanceof JsonObject jsonObject)){
                        logger.warn("File was found not to be parsed as a valid JsonObject, it will be skipped: [Location: " + filePath + "]");
                        continue;
                    }

                    if(output.containsKey(resourceLocation)){
                        var jsonObject2 = output.get(resourceLocation).getAsJsonObject();

                        //TODO: SHOULD THIS OVERWRITE ENTRIES OR REPLACE THE OBJECT????
                        if(class_3518.method_15270(jsonObject, "replace")){
                            jsonObject.asMap().forEach(jsonObject2::add);
                        }
                    } else {
                        output.put(resourceLocation, jsonObject);
                    }
                } catch (IllegalArgumentException | IOException | JsonParseException var14) {
                    logger.error("Couldn't parse data file {} from {}", resourceLocation, resourceLocation, var14);
                }
            }
        }

        return output;
    }

    public <T> void decodeJsonArray(JsonArray jsonArray, String name, class_2960 location, Function<JsonElement, @Nullable T> decoder, Consumer<T> consumer){
        for (var element : jsonArray) {
            if(!element.isJsonPrimitive()) {
                logger.warn("Unable to parse " + name + " as it is not a valid Json Primitive! [Location: " + location + "]");
                continue;
            }

            var value = decoder.apply(element);

            if(value == null) {
                logger.warn("Unable to parse " + name + " as it is not a valid ResourceLocation! [Location: " + location + ", Value: " + element.getAsString() + "]");
                continue;
            }

            consumer.accept(value);
        }
    }

    @Nullable
    protected <T> T safeHelper(BiFunction<JsonObject, String, T> func, JsonObject object, String key, class_2960 location){
        return safeHelper(func, object, key, null, location);
    }

    protected <T> T safeHelper(BiFunction<JsonObject, String, T> func, JsonObject object, String key, T defaultValue, class_2960 location){
        if(!object.has(key)) return defaultValue;

        try {
            return func.apply(object, key);
        } catch (Exception e){
            logger.warn("Unable to deserialize value for the given file: [Location: " + location + ", Field: " + key + "]", e);
        }

        return defaultValue;
    }
}
