package io.wispforest.accessories.fabric;

import com.google.gson.JsonObject;
import com.mojang.brigadier.arguments.ArgumentType;
import io.wispforest.accessories.api.AccessoriesHolder;
import io.wispforest.accessories.client.AccessoriesMenu;
import io.wispforest.accessories.client.AccessoriesMenuData;
import io.wispforest.accessories.endec.CodecUtils;
import io.wispforest.accessories.impl.AccessoriesHolderImpl;
import io.wispforest.accessories.networking.base.BaseNetworkHandler;
import io.wispforest.endec.format.bytebuf.ByteBufDeserializer;
import io.wispforest.endec.format.bytebuf.ByteBufSerializer;
import net.fabricmc.fabric.api.command.v2.ArgumentTypeRegistry;
import net.fabricmc.fabric.api.resource.conditions.v1.ResourceConditions;
import net.fabricmc.fabric.api.screenhandler.v1.ExtendedScreenHandlerFactory;
import net.fabricmc.fabric.api.screenhandler.v1.ExtendedScreenHandlerType;
import net.fabricmc.fabric.api.transfer.v1.item.ItemVariant;
import net.fabricmc.fabric.api.transfer.v1.item.PlayerInventoryStorage;
import net.fabricmc.fabric.api.transfer.v1.transaction.Transaction;
import net.fabricmc.fabric.impl.resource.conditions.ResourceConditionsImpl;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1799;
import net.minecraft.class_2314;
import net.minecraft.class_2378;
import net.minecraft.class_2540;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_3505;
import net.minecraft.class_3917;
import net.minecraft.class_5321;
import net.minecraft.class_6862;
import net.minecraft.class_6880;
import net.minecraft.class_7225;
import net.minecraft.class_7923;
import org.apache.commons.lang3.function.TriFunction;
import org.jetbrains.annotations.Nullable;

import java.util.*;
import java.util.function.UnaryOperator;
import java.util.stream.Collectors;

public class AccessoriesInternalsImpl {

    public static boolean isDevelopmentEnv() {
        return FabricLoader.getInstance().isDevelopmentEnvironment();
    }

    public static AccessoriesHolder getHolder(class_1309 livingEntity){
        return livingEntity.getAttachedOrCreate(AccessoriesFabric.HOLDER_ATTACHMENT_TYPE);
    }

    public static void modifyHolder(class_1309 livingEntity, UnaryOperator<AccessoriesHolderImpl> modifier){
        var holder = (AccessoriesHolderImpl) getHolder(livingEntity);

        holder = modifier.apply(holder);

        livingEntity.setAttached(AccessoriesFabric.HOLDER_ATTACHMENT_TYPE, holder);
    }

    public static BaseNetworkHandler getNetworkHandler(){
        return AccessoriesFabricNetworkHandler.INSTANCE;
    }

    public static final ThreadLocal<Map<class_5321<?>, Map<class_2960, Collection<class_6880<?>>>>> LOADED_TAGS = new ThreadLocal<>();

    public static void setTags(List<class_3505.class_6863<?>> tags) {
        Map<class_5321<?>, Map<class_2960, Collection<class_6880<?>>>> tagMap = new IdentityHashMap<>();

        for (class_3505.class_6863<?> registryTags : tags) {
            tagMap.put(registryTags.comp_328(), (Map) registryTags.comp_329());
        }

        LOADED_TAGS.set(tagMap);
    }

    public static <T> Optional<Collection<class_6880<T>>> getHolder(class_6862<T> tagKey){
        var tags = LOADED_TAGS.get().get(tagKey.comp_326());

        if(tags == null) return Optional.empty();

        var holders = tags.get(tagKey.comp_327());

        if(holders == null) return Optional.empty();

        var converted = holders
                .stream()
                .map(holder -> (class_6880<T>) holder)
                .collect(Collectors.toUnmodifiableSet());

        return Optional.of(converted);
    }

    //--

    public static void giveItemToPlayer(class_3222 player, class_1799 stack) {
        if(stack.method_7960()) return;

        try(var transaction = Transaction.openOuter()) {
            PlayerInventoryStorage.of(player).offerOrDrop(ItemVariant.of(stack), stack.method_7947(), transaction);
            transaction.commit();
        }
    }

    public static boolean isValidOnConditions(JsonObject object, String dataType, class_2960 key, @Nullable class_7225.class_7874 registryLookup) {
        return ResourceConditions.objectMatchesConditions(object);
    }

    public static <T extends class_1703> class_3917<T> registerMenuType(class_2960 location, TriFunction<Integer, class_1661, AccessoriesMenuData, T> func) {
        return class_2378.method_10230(class_7923.field_41187, location, new ExtendedScreenHandlerType<>((syncId, inventory, buf) -> {
            return func.apply(syncId, inventory, AccessoriesMenuData.ENDEC.decodeFully(ByteBufDeserializer::of, buf));
        }));
    }

    public static <A extends ArgumentType<?>, T extends class_2314.class_7217<A>, I extends class_2314<A, T>> I registerCommandArgumentType(class_2960 location, Class<A> clazz, I info) {
        ArgumentTypeRegistry.registerArgumentType(location, clazz, info);

        return info;
    }

    public static void openAccessoriesMenu(class_1657 player, @Nullable class_1309 targetEntity, @Nullable class_1799 carriedStack) {
        player.method_17355(new ExtendedScreenHandlerFactory() {
            @Override
            public void writeScreenOpeningData(class_3222 player, class_2540 buf) {
                AccessoriesMenuData.ENDEC.encodeFully(() -> ByteBufSerializer.of(buf), AccessoriesMenuData.of(targetEntity));
            }

            @Override
            public class_2561 method_5476() { return class_2561.method_43473(); }

            @Override
            public boolean shouldCloseCurrentScreen() {
                return false;
            }

            @Nullable
            @Override
            public class_1703 createMenu(int i, class_1661 inventory, class_1657 player) {
                var menu = new AccessoriesMenu(i, inventory, targetEntity);

                if(carriedStack != null) menu.method_34254(carriedStack);

                return menu;
            }
        });
    }
}
