package io.wispforest.accessories.fabric;

import io.wispforest.accessories.Accessories;
import io.wispforest.accessories.DataLoaderBase;
import io.wispforest.accessories.data.EntitySlotLoader;
import io.wispforest.accessories.data.SlotGroupLoader;
import io.wispforest.accessories.data.SlotTypeLoader;
import io.wispforest.accessories.impl.AccessoriesEventHandler;
import net.fabricmc.fabric.api.resource.IdentifiableResourceReloadListener;
import net.fabricmc.fabric.api.resource.ResourceManagerHelper;
import net.fabricmc.fabric.api.resource.SimpleSynchronousResourceReloadListener;
import net.minecraft.class_2960;
import net.minecraft.class_3264;
import net.minecraft.class_3300;
import net.minecraft.class_3302;
import net.minecraft.class_3695;
import org.jetbrains.annotations.Nullable;

import java.util.*;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;

public class DataLoaderImpl extends DataLoaderBase {

    public static final class_2960 SLOT_LOADER_LOCATION = Accessories.of("slot_loader");
    public static final class_2960 ENTITY_SLOT_LOADER_LOCATION = Accessories.of("entity_slot_loader");
    public static final class_2960 SLOT_GROUP_LOADER_LOCATION = Accessories.of("slot_group_loader");

    private IdentifiableResourceReloadListener identifiedSlotLoader = null;
    private IdentifiableResourceReloadListener identifiedEntitySlotLoader = null;

    @Override
    protected Optional<class_3302> getIdentifiedSlotLoader() {
        return Optional.ofNullable(identifiedSlotLoader);
    }

    @Override
    protected Optional<class_3302> getIdentifiedEntitySlotLoader() {
        return Optional.ofNullable(identifiedEntitySlotLoader);
    }

    @Override
    public void registerListeners() {
        var manager = ResourceManagerHelper.get(class_3264.field_14190);

        this.identifiedSlotLoader = new IdentifiableResourceReloadListenerImpl(SLOT_LOADER_LOCATION, SlotTypeLoader.INSTANCE);
        this.identifiedEntitySlotLoader = new IdentifiableResourceReloadListenerImpl(ENTITY_SLOT_LOADER_LOCATION, EntitySlotLoader.INSTANCE, SLOT_LOADER_LOCATION);

        manager.registerReloadListener(identifiedSlotLoader);
        manager.registerReloadListener(identifiedEntitySlotLoader);
        manager.registerReloadListener(new IdentifiableResourceReloadListenerImpl(SLOT_GROUP_LOADER_LOCATION, SlotGroupLoader.INSTANCE, SLOT_LOADER_LOCATION));

        manager.registerReloadListener(new SimpleSynchronousResourceReloadListener() {
            @Override
            public class_2960 getFabricId() {
                return Accessories.of("data_reload_hook");
            }

            @Override
            public void method_14491(class_3300 resourceManager) {
                AccessoriesEventHandler.dataReloadOccurred = true;
            }
        });

        super.registerListeners();
    }

    private record IdentifiableResourceReloadListenerImpl(class_2960 location, class_3302 listener, Set<class_2960> dependencies) implements IdentifiableResourceReloadListener {

        public IdentifiableResourceReloadListenerImpl(class_2960 location, class_3302 listener, class_2960 ...dependencies){
            this(location, listener, new HashSet<>(List.of(dependencies)));
        }

        @Override
        public class_2960 getFabricId() {
            return this.location;
        }

        @Override
        public CompletableFuture<Void> method_25931(class_4045 preparationBarrier, class_3300 resourceManager, class_3695 preparationsProfiler, class_3695 reloadProfiler, Executor backgroundExecutor, Executor gameExecutor) {
            return this.listener.method_25931(preparationBarrier, resourceManager, preparationsProfiler, reloadProfiler, backgroundExecutor, gameExecutor);
        }

        @Override
        public Collection<class_2960> getFabricDependencies() {
            return dependencies;
        }
    }
}
