package io.wispforest.accessories.impl;

import I;
import Z;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import com.mojang.datafixers.util.Pair;
import io.wispforest.accessories.api.AccessoriesAPI;
import io.wispforest.accessories.api.AccessoriesCapability;
import io.wispforest.accessories.api.AccessoriesContainer;
import io.wispforest.accessories.api.Accessory;
import io.wispforest.accessories.api.slot.ExtraSlotTypeProperties;
import io.wispforest.accessories.api.slot.SlotReference;
import io.wispforest.accessories.api.slot.SlotType;
import io.wispforest.accessories.endec.format.nbt.NbtEndec;
import io.wispforest.accessories.utils.AttributeUtils;
import io.wispforest.endec.Endec;
import io.wispforest.endec.SerializationContext;
import io.wispforest.endec.impl.KeyedEndec;
import io.wispforest.endec.util.MapCarrier;
import net.minecraft.class_1263;
import net.minecraft.class_1265;
import net.minecraft.class_1277;
import net.minecraft.class_1309;
import net.minecraft.class_1322;
import net.minecraft.class_1799;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.nbt.*;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;

import java.util.*;

@ApiStatus.Internal
public class AccessoriesContainerImpl implements AccessoriesContainer, InstanceEndec, class_1265 {

    protected AccessoriesCapability capability;
    private String slotName;

    protected final Map<UUID, class_1322> modifiers = new HashMap<>();
    protected final Set<class_1322> persistentModifiers = new HashSet<>();
    protected final Set<class_1322> cachedModifiers = new HashSet<>();

    private final Multimap<class_1322.class_1323, class_1322> modifiersByOperation = HashMultimap.create();

    @Nullable
    private Integer baseSize;

    private List<Boolean> renderOptions;

    private ExpandedSimpleContainer accessories;
    private ExpandedSimpleContainer cosmeticAccessories;

    private boolean update = false;
    private boolean resizingUpdate = false;

    public AccessoriesContainerImpl(AccessoriesCapability capability, SlotType slotType){
        this.capability = capability;

        this.slotName = slotType.name();
        this.baseSize = slotType.amount();

        this.accessories = new ExpandedSimpleContainer(this, this.baseSize, "accessories", false);
        this.cosmeticAccessories = new ExpandedSimpleContainer(this, this.baseSize, "cosmetic_accessories", false);

        this.renderOptions = getWithSize(baseSize, new ArrayList<>(), true);
    }

    protected boolean containerListenerLock = false;

    @Override
    public void method_5453(class_1263 container) {
        if(containerListenerLock) return;

        if(((ExpandedSimpleContainer) container).name().contains("cosmetic")) return;

        this.markChanged();
        this.update();
    }

    @Nullable
    public Integer getBaseSize(){
        return this.baseSize;
    }

    @Override
    public void markChanged(boolean resizingUpdate){
        this.update = true;
        this.resizingUpdate = resizingUpdate;

        if(this.capability.entity().method_37908().field_9236) return;

        var inv = ((AccessoriesCapabilityImpl) this.capability).getUpdatingInventories();

        inv.remove(this);
        inv.put(this, resizingUpdate);
    }

    @Override
    public boolean hasChanged() {
        return this.update;
    }

    public void update(){
        var hasChangeOccurred = !this.resizingUpdate;

        if(!update) return;

        this.update = false;

        if(this.capability.entity().method_37908().field_9236) return;

        var slotType = this.slotType();

        if(this.baseSize == null) this.baseSize = 0;

        if (slotType != null && this.baseSize != slotType.amount()) {
            this.baseSize = slotType.amount();

            hasChangeOccurred = true;
        }

        double baseSize = this.baseSize;

        double size;

        if(ExtraSlotTypeProperties.getProperty(this.slotName, false).allowResizing()) {
            for (class_1322 modifier : this.getModifiersForOperation(class_1322.class_1323.field_6328)) {
                baseSize += modifier.method_6186();
            }

            size = baseSize;

            for (class_1322 modifier : this.getModifiersForOperation(class_1322.class_1323.field_6330)) {
                size += (this.baseSize * modifier.method_6186());
            }

            for (class_1322 modifier : this.getModifiersForOperation(class_1322.class_1323.field_6331)) {
                size *= modifier.method_6186();
            }
        } else {
            size = baseSize;
        }

        //--

        var currentSize = (int) Math.round(size);

        if(currentSize != this.accessories.method_5439()) {
            hasChangeOccurred = true;

            var invalidAccessories = new ArrayList<Pair<Integer, class_1799>>();

            var invalidStacks = new ArrayList<class_1799>();

            this.containerListenerLock = true;

            var newAccessories = new ExpandedSimpleContainer(this, currentSize, "accessories");
            var newCosmetics = new ExpandedSimpleContainer(this, currentSize, "cosmetic_accessories");

            for (int i = 0; i < this.accessories.method_5439(); i++) {
                if (i < newAccessories.method_5439()) {
                    newAccessories.method_5447(i, this.accessories.method_5438(i));
                    newCosmetics.method_5447(i, this.cosmeticAccessories.method_5438(i));
                } else {
                    invalidAccessories.add(Pair.of(i, this.accessories.method_5438(i)));
                    invalidStacks.add(this.cosmeticAccessories.method_5438(i));
                }
            }

            this.containerListenerLock = false;

            newAccessories.copyPrev(this.accessories);
            newCosmetics.copyPrev(this.cosmeticAccessories);

            this.accessories = newAccessories;
            this.cosmeticAccessories = newCosmetics;

            this.renderOptions = getWithSize(currentSize, this.renderOptions, true);

            var livingEntity = this.capability.entity();

            //TODO: Confirm if this is needed
            for (var invalidAccessory : invalidAccessories) {
                var index = invalidAccessory.getFirst();

                var invalidStack = invalidAccessory.getSecond();

                if (invalidStack.method_7960()) continue;

                var slotReference = SlotReference.of(livingEntity, this.slotName, index);

                AttributeUtils.removeTransientAttributeModifiers(livingEntity, AccessoriesAPI.getAttributeModifiers(invalidStack, slotReference));

                var accessory = AccessoriesAPI.getAccessory(invalidStack);

                if (accessory != null) accessory.onUnequip(invalidStack, slotReference);

                invalidStacks.add(invalidStack);
            }

            ((AccessoriesHolderImpl) this.capability.getHolder()).invalidStacks.addAll(invalidStacks);

            if (this.update) this.capability.updateContainers();
        }

        if(!hasChangeOccurred) {
            var inv = ((AccessoriesCapabilityImpl) this.capability).getUpdatingInventories();

            inv.remove(this);
        }
    }

    @Override
    public int getSize() {
        this.update();
        return this.accessories.method_5439();
    }

    @Override
    public String getSlotName(){
        return this.slotName;
    }

    @Override
    public AccessoriesCapability capability() {
        return this.capability;
    }

    @Override
    public List<Boolean> renderOptions() {
        this.update();
        return this.renderOptions;
    }

    @Override
    public ExpandedSimpleContainer getAccessories() {
        this.update();
        return accessories;
    }

    @Override
    public ExpandedSimpleContainer getCosmeticAccessories() {
        this.update();
        return cosmeticAccessories;
    }

    @Override
    public Map<UUID, class_1322> getModifiers() {
        return this.modifiers;
    }

    public Set<class_1322> getCachedModifiers(){
        return this.cachedModifiers;
    }

    @Override
    public Collection<class_1322> getModifiersForOperation(class_1322.class_1323 operation) {
        return this.modifiersByOperation.get(operation);
    }

    @Override
    public void addTransientModifier(class_1322 modifier) {
        this.modifiers.put(modifier.method_6189(), modifier);
        this.getModifiersForOperation(modifier.method_6182()).add(modifier);
        this.markChanged();
    }

    @Override
    public void addPersistentModifier(class_1322 modifier) {
        this.addTransientModifier(modifier);
        this.persistentModifiers.add(modifier);
    }

    @Override
    public boolean hasModifier(UUID id) {
        return this.modifiers.containsKey(id);
    }

    @Override
    public void removeModifier(UUID id) {
        var modifier = this.modifiers.remove(id);

        if(modifier == null) return;

        this.persistentModifiers.remove(modifier);
        this.getModifiersForOperation(modifier.method_6182()).remove(modifier);
        this.markChanged();
    }

    @Override
    public void clearModifiers() {
        this.getModifiers().keySet().iterator().forEachRemaining(this::removeModifier);
    }

    @Override
    public void removeCachedModifiers(class_1322 modifier) {
        this.cachedModifiers.remove(modifier);
    }

    @Override
    public void clearCachedModifiers() {
        this.cachedModifiers.forEach(cachedModifier -> this.removeModifier(cachedModifier.method_6189()));
        this.cachedModifiers.clear();
    }

    //--

    public void copyFrom(AccessoriesContainerImpl other){
        this.modifiers.clear();
        this.modifiersByOperation.clear();
        this.persistentModifiers.clear();
        other.modifiers.values().forEach(this::addTransientModifier);
        other.persistentModifiers.forEach(this::addPersistentModifier);
        this.update();
    }

    //TODO: Confirm Cross Dimension stuff works!
//    public static void copyFrom(LivingEntity oldEntity, LivingEntity newEntity){
//        var api = AccessoriesAccess.getAPI();
//
//        var oldCapability = api.getCapability(oldEntity);
//        var newCapability = api.getCapability(newEntity);
//
//        if(oldCapability.isEmpty() || newCapability.isEmpty()) return;
//
//        var newContainers = newCapability.get().getContainers();
//        for (var containerEntries : oldCapability.get().getContainers().entrySet()) {
//            if(!newContainers.containsKey(containerEntries.getKey())) continue;
//        }
//    }

    //--

    public static final KeyedEndec<String> SLOT_NAME_KEY = Endec.STRING.keyed("SlotName", "UNKNOWN");

    public static final KeyedEndec<Integer> BASE_SIZE_KEY = Endec.INT.keyed("BaseSize", () -> null);

    public static final KeyedEndec<Integer> CURRENT_SIZE_KEY = Endec.INT.keyed("size", 0);

    public static final KeyedEndec<List<Boolean>> RENDER_OPTIONS_KEY = Endec.BOOLEAN.listOf().keyed("RenderOptions", ArrayList::new);

    public static final KeyedEndec<List<class_2487>> MODIFIERS_KEY = NbtEndec.COMPOUND.listOf().keyed("Modifiers", ArrayList::new);
    public static final KeyedEndec<List<class_2487>> PERSISTENT_MODIFIERS_KEY = NbtEndec.COMPOUND.listOf().keyed("PersistentModifiers", ArrayList::new);
    public static final KeyedEndec<List<class_2487>> CACHED_MODIFIERS_KEY = NbtEndec.COMPOUND.listOf().keyed("CachedModifiers", ArrayList::new);

    public static final KeyedEndec<class_2499> ITEMS_KEY = NbtEndec.LIST.keyed("Items", class_2499::new);
    public static final KeyedEndec<class_2499> COSMETICS_KEY = NbtEndec.LIST.keyed("Cosmetics", class_2499::new);

    @Override
    public void write(MapCarrier carrier, SerializationContext ctx) {
        write(carrier, ctx, false);
    }

    public void write(MapCarrier carrier, SerializationContext ctx, boolean sync){
        carrier.put(SLOT_NAME_KEY, this.slotName);

        carrier.putIfNotNull(ctx, BASE_SIZE_KEY, this.baseSize);

        carrier.put(RENDER_OPTIONS_KEY, this.renderOptions);

        if(!sync || this.accessories.wasNewlyConstructed()) {
            carrier.put(CURRENT_SIZE_KEY, accessories.method_5439());

            carrier.put(ITEMS_KEY, accessories.method_7660());
            carrier.put(COSMETICS_KEY, cosmeticAccessories.method_7660());
        }

        if(sync){
            if(!this.modifiers.isEmpty()){
                var modifiersTag = new ArrayList<class_2487>();

                this.modifiers.values().forEach(modifier -> modifiersTag.add(modifier.method_26860()));

                carrier.put(MODIFIERS_KEY, modifiersTag);
            }
        } else {
            if(!this.persistentModifiers.isEmpty()){
                var persistentTag = new ArrayList<class_2487>();

                this.persistentModifiers.forEach(modifier -> persistentTag.add(modifier.method_26860()));

                carrier.put(PERSISTENT_MODIFIERS_KEY, persistentTag);
            }

            if(!this.modifiers.isEmpty()){
                var cachedTag = new ArrayList<class_2487>();

                this.modifiers.values().forEach(modifier -> {
                    if(this.persistentModifiers.contains(modifier)) return;

                    cachedTag.add(modifier.method_26860());
                });

                carrier.put(CACHED_MODIFIERS_KEY, cachedTag);
            }
        }
    }

    @Override
    public void read(MapCarrier carrier, SerializationContext ctx) {
        read(carrier, ctx, false);
    }

    public void read(MapCarrier carrier, SerializationContext ctx, boolean sync){
        this.slotName = carrier.get(SLOT_NAME_KEY);

        this.baseSize = carrier.get(BASE_SIZE_KEY);

        if(sync) {
            this.modifiers.clear();
            this.persistentModifiers.clear();
            this.modifiersByOperation.clear();

            if (carrier.has(MODIFIERS_KEY)) {
                var persistentTag = carrier.get(MODIFIERS_KEY);

                for (var compoundTag : persistentTag) {
                    var modifier = class_1322.method_26859(compoundTag);

                    if (modifier != null) this.addTransientModifier(modifier);
                }
            }
        } else {
            if (carrier.has(PERSISTENT_MODIFIERS_KEY)) {
                var persistentTag = carrier.get(PERSISTENT_MODIFIERS_KEY);

                for (var compoundTag : persistentTag) {
                    var modifier = class_1322.method_26859(compoundTag);

                    if (modifier != null) this.addPersistentModifier(modifier);
                }
            }

            if (carrier.has(CACHED_MODIFIERS_KEY)) {
                var cachedTag = carrier.get(CACHED_MODIFIERS_KEY);

                for (class_2487 compoundTag : cachedTag) {
                    var modifier = class_1322.method_26859(compoundTag);

                    if (modifier != null) {
                        this.cachedModifiers.add(modifier);
                        this.addTransientModifier(modifier);
                    }

                    this.update();
                }
            }
        }

        if(carrier.has(CURRENT_SIZE_KEY)) {
            var currentSize = carrier.get(CURRENT_SIZE_KEY);

            var sentOptions = carrier.get(RENDER_OPTIONS_KEY);

            this.renderOptions = getWithSize(currentSize, sentOptions, true);

            if(this.accessories.method_5439() != currentSize) {
                this.accessories = new ExpandedSimpleContainer(this, currentSize, "accessories");
                this.cosmeticAccessories = new ExpandedSimpleContainer(this, currentSize, "cosmetic_accessories");
            }

            this.accessories.method_7659(carrier.get(ITEMS_KEY));
            this.cosmeticAccessories.method_7659(carrier.get(COSMETICS_KEY));
        } else {
            this.renderOptions = carrier.get(RENDER_OPTIONS_KEY);
        }
    }

    private <T> List<T> getWithSize(int size, List<T> list, T defaultValue) {
        var sizedList = new ArrayList<T>(size);

        for (int i = 0; i < size; i++) {
            var value = (i < list.size()) ? list.get(i) : defaultValue;

            sizedList.add(value);
        }

        return sizedList;
    }

    public static class_1277 readContainer(MapCarrier carrier, SerializationContext ctx, KeyedEndec<class_2499> key){
        return readContainers(carrier, ctx, key).get(0);
    }

    @SafeVarargs
    public static List<class_1277> readContainers(MapCarrier carrier, SerializationContext ctx, KeyedEndec<class_2499> ...keys){
        var containers = new ArrayList<class_1277>();

        for (var key : keys) {
            var stacks = new class_1277();

            if(carrier.has(key)) stacks.method_7659(carrier.get(key));

            containers.add(stacks);
        }

        return containers;
    }

    public static class_1277 copyContainerList(class_1277 container){
        return new class_1277(container.method_24514().toArray(class_1799[]::new));
    }
}
