package io.wispforest.accessories.impl;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Multimap;
import com.google.common.collect.Sets;
import com.google.common.collect.Sets.SetView;
import io.wispforest.accessories.Accessories;
import io.wispforest.accessories.AccessoriesInternals;
import io.wispforest.accessories.api.*;
import io.wispforest.accessories.api.attributes.AccessoryAttributeBuilder;
import io.wispforest.accessories.api.components.AccessoriesDataComponents;
import io.wispforest.accessories.api.components.AccessoryItemAttributeModifiers;
import io.wispforest.accessories.api.components.AccessoryNestContainerContents;
import io.wispforest.accessories.api.events.*;
import io.wispforest.accessories.api.slot.SlotEntryReference;
import io.wispforest.accessories.api.slot.SlotReference;
import io.wispforest.accessories.api.slot.SlotType;
import io.wispforest.accessories.api.slot.UniqueSlotHandling;
import io.wispforest.accessories.client.AccessoriesMenu;
import io.wispforest.accessories.data.EntitySlotLoader;
import io.wispforest.accessories.data.SlotTypeLoader;
import io.wispforest.accessories.endec.NbtMapCarrier;
import io.wispforest.accessories.networking.client.SyncEntireContainer;
import io.wispforest.accessories.networking.base.BaseNetworkHandler;
import io.wispforest.accessories.networking.client.SyncContainerData;
import io.wispforest.accessories.networking.client.SyncData;
import io.wispforest.accessories.utils.AttributeUtils;
import io.wispforest.endec.SerializationContext;
import it.unimi.dsi.fastutil.Pair;
import net.fabricmc.fabric.api.util.TriState;
import net.minecraft.class_124;
import net.minecraft.class_1263;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1271;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1320;
import net.minecraft.class_1322;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_1890;
import net.minecraft.class_1928;
import net.minecraft.class_1937;
import net.minecraft.class_2561;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3324;
import net.minecraft.class_5134;
import net.minecraft.class_5244;
import net.minecraft.class_5250;
import net.minecraft.class_6862;
import net.minecraft.class_7924;
import net.minecraft.world.*;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;

import java.util.*;
import java.util.Map.Entry;
import java.util.stream.Collectors;

import static io.wispforest.accessories.Accessories.ACCESSORY_EQUIPPED;
import static io.wispforest.accessories.Accessories.ACCESSORY_UNEQUIPPED;

import I;
import Z;

@ApiStatus.Internal
public class AccessoriesEventHandler {

    public static boolean dataReloadOccurred = false;

    public static void onWorldTick(class_1937 level) {
        if (!(level instanceof class_3218 serverLevel)) return;

        revalidatePlayersOnReload(serverLevel.method_8503().method_3760());
    }

    public static void revalidatePlayersOnReload(class_3324 playerList) {
        if(!dataReloadOccurred) return;

        for (var player : playerList.method_14571()) revalidatePlayer(player);

        dataReloadOccurred = false;
    }

    public static void revalidatePlayer(class_3222 player) {
        var capability = AccessoriesCapability.get(player);

        if (capability == null) return;

        var validSlotTypes = EntitySlotLoader.getEntitySlots(player).values();

        for (var container : capability.getContainers().values()) {
            var slotType = container.slotType();

            if (slotType != null && validSlotTypes.contains(slotType)) {
                var baseSize = ((AccessoriesContainerImpl) container).getBaseSize();

                if (baseSize == null || baseSize != slotType.amount()) {
                    container.markChanged();
                    container.update();
                }

                var stacks = container.getAccessories();
                var cosmeticStacks = container.getCosmeticAccessories();

                for (int i = 0; i < container.getSize(); i++) {
                    var reference = container.createReference(i);

                    handleInvalidStacks(stacks, reference, player);
                    handleInvalidStacks(cosmeticStacks, reference, player);
                }
            } else {
                // TODO: DROP CONTAINER ?!
                var stacks = container.getAccessories();
                var cosmeticStacks = container.getCosmeticAccessories();

                for (int i = 0; i < container.getSize(); i++) {
                    var reference = container.createReference(i);

                    dropAndRemoveStack(stacks, reference, player);
                    dropAndRemoveStack(cosmeticStacks, reference, player);
                }
            }
        }
    }

    private static void handleInvalidStacks(class_1263 container, SlotReference reference, class_3222 player) {
        var bl = !AccessoriesAPI.canInsertIntoSlot(container.method_5438(reference.slot()), reference);

        if (bl) dropAndRemoveStack(container, reference, player);
    }

    private static void dropAndRemoveStack(class_1263 container, SlotReference reference, class_3222 player) {
        var stack = container.method_5438(reference.slot());

        container.method_5447(reference.slot(), class_1799.field_8037);

        AccessoriesInternals.giveItemToPlayer(player, stack);
    }

    public static void entityLoad(class_1309 entity, class_1937 level) {
        if (!level.method_8608() || !(entity instanceof class_3222 serverPlayer)) return;

        var capability = AccessoriesCapability.get(serverPlayer);

        if(capability == null) return;

        var carrier = NbtMapCarrier.of();

        ((AccessoriesHolderImpl) capability.getHolder()).write(carrier, SerializationContext.empty());

        AccessoriesInternals.getNetworkHandler().sendToTrackingAndSelf(serverPlayer, new SyncEntireContainer(capability.entity().method_5628(), carrier));
    }

    public static void onTracking(class_1309 entity, class_3222 serverPlayer) {
        var capability = AccessoriesCapability.get(entity);

        if(capability == null) return;

        var carrier = NbtMapCarrier.of();

        ((AccessoriesHolderImpl) capability.getHolder()).write(carrier, SerializationContext.empty());

        AccessoriesInternals.getNetworkHandler().sendToPlayer(serverPlayer, new SyncEntireContainer(capability.entity().method_5628(), carrier));
    }

    public static void dataSync(@Nullable class_3324 list, @Nullable class_3222 player) {
        var networkHandler = AccessoriesInternals.getNetworkHandler();
        var syncPacket = SyncData.create();

        if (list != null && !list.method_14571().isEmpty()) {
            revalidatePlayersOnReload(list);

            // TODO: OPTIMIZE THIS?
            for (var playerEntry : list.method_14571()) {
                networkHandler.sendToPlayer(playerEntry, syncPacket);

                var capability = AccessoriesCapability.get(playerEntry);

                if(capability == null) return;

                var carrier = NbtMapCarrier.of();

                ((AccessoriesHolderImpl) capability.getHolder()).write(carrier, SerializationContext.empty());

                networkHandler.sendToTrackingAndSelf(playerEntry, new SyncEntireContainer(capability.entity().method_5628(), carrier));

                if(playerEntry.field_7512 instanceof AccessoriesMenu accessoriesMenu) {
                    Accessories.openAccessoriesMenu(playerEntry, accessoriesMenu.targetEntity());
                }
            }
        } else if (player != null) {
            networkHandler.sendToPlayer(player, syncPacket);

            revalidatePlayer(player);

            var capability = AccessoriesCapability.get(player);

            if(capability == null) return;

            var carrier = NbtMapCarrier.of();

            ((AccessoriesHolderImpl) capability.getHolder()).write(carrier, SerializationContext.empty());

            networkHandler.sendToPlayer(player, new SyncEntireContainer(capability.entity().method_5628(), carrier));

            if(player.field_7512 instanceof AccessoriesMenu accessoriesMenu) {
                Accessories.openAccessoriesMenu(player, accessoriesMenu.targetEntity());
            }
        }
    }

    public static void onLivingEntityTick(class_1309 entity) {
        if(entity.method_31481()) return;

        var capability = AccessoriesCapability.get(entity);

        if (capability != null) {
            var dirtyStacks = new HashMap<String, class_1799>();
            var dirtyCosmeticStacks = new HashMap<String, class_1799>();

            var removedAttributesBuilder = new AccessoryAttributeBuilder();
            var addedAttributesBuilder = new AccessoryAttributeBuilder();

            for (var containerEntry : capability.getContainers().entrySet()) {
                var container = containerEntry.getValue();
                var slotType = container.slotType();

                var accessories = (ExpandedSimpleContainer) container.getAccessories();
                var cosmetics = container.getCosmeticAccessories();

                for (int i = 0; i < accessories.method_5439(); i++) {
                    var slotReference = container.createReference(i);

                    var slotId = slotType.name() + "/" + i;

                    var currentStack = accessories.method_5438(i);

                    // TODO: Move ticking below checks?
                    if (!currentStack.method_7960()) {
                        // TODO: Document this behavior to prevent double ticking maybe!!!
                        currentStack.method_7917(entity.method_37908(), entity, -1, false);

                        var accessory = AccessoriesAPI.getAccessory(currentStack);

                        if (accessory != null) accessory.tick(currentStack, slotReference);
                    }

                    var lastStack = accessories.getPreviousItem(i);

                    // Prevent attribute related logic on the client and if the entity
                    // is dead as such data should not be updated. Though we allow for
                    // ticking to occur at least for vanilla parity I guess.
                    if (entity.method_37908().method_8608() || entity.method_29504()) continue;

                    if (!class_1799.method_7973(currentStack, lastStack)) {
                        container.getAccessories().setPreviousItem(i, currentStack.method_7972());
                        dirtyStacks.put(slotId, currentStack.method_7972());

                        if (!lastStack.method_7960()) {
                            removedAttributesBuilder.addFrom(AccessoriesAPI.getAttributeModifiers(lastStack, slotReference));
                        }

                        if (!currentStack.method_7960()) {
                            addedAttributesBuilder.addFrom(AccessoriesAPI.getAttributeModifiers(currentStack, slotReference));
                        }

                        boolean equipmentChange = false;

                        /*
                         * TODO: Does item check need to exist anymore?
                         */
                        if (!class_1799.method_7984(currentStack, lastStack) || accessories.isSlotFlagged(i)) {
                            AccessoriesAPI.getOrDefaultAccessory(lastStack.method_7909()).onUnequip(lastStack, slotReference);
                            AccessoriesAPI.getOrDefaultAccessory(currentStack.method_7909()).onEquip(currentStack, slotReference);

                            if (entity instanceof class_3222 serverPlayer) {
                                if (!currentStack.method_7960()) {
                                    ACCESSORY_EQUIPPED.trigger(serverPlayer, currentStack, slotReference, false);
                                }

                                if (!lastStack.method_7960()) {
                                    ACCESSORY_UNEQUIPPED.trigger(serverPlayer, lastStack, slotReference, false);
                                }
                            }

                            equipmentChange = true;
                        }

                        AccessoryChangeCallback.EVENT.invoker().onChange(lastStack, currentStack, slotReference, equipmentChange ? SlotStateChange.REPLACEMENT : SlotStateChange.MUTATION);

                        recursiveStackChange(slotReference, AccessoryNestUtils.getData(lastStack), AccessoryNestUtils.getData(currentStack));
                    }

                    var currentCosmeticStack = cosmetics.method_5438(i);
                    var lastCosmeticStack = container.getCosmeticAccessories().getPreviousItem(i);

                    if (!class_1799.method_7973(currentCosmeticStack, lastCosmeticStack)) {
                        cosmetics.setPreviousItem(i, currentCosmeticStack.method_7972());
                        dirtyCosmeticStacks.put(slotId, currentCosmeticStack.method_7972());

                        if (entity instanceof class_3222 serverPlayer) {
                            if (!currentStack.method_7960()) {
                                ACCESSORY_EQUIPPED.trigger(serverPlayer, currentStack, slotReference, true);
                            }
                            if (!lastStack.method_7960()) {
                                ACCESSORY_UNEQUIPPED.trigger(serverPlayer, lastStack, slotReference, true);
                            }
                        }
                    }
                }
            }

            if (entity.method_37908().method_8608()) return;

            AttributeUtils.removeTransientAttributeModifiers(entity, removedAttributesBuilder);
            AttributeUtils.addTransientAttributeModifiers(entity, addedAttributesBuilder);

            //--

            var updatedContainers = ((AccessoriesCapabilityImpl) capability).getUpdatingInventories();

            capability.updateContainers();

            ContainersChangeCallback.EVENT.invoker().onChange(entity, capability, ImmutableMap.copyOf(updatedContainers));

            if (!dirtyStacks.isEmpty() || !dirtyCosmeticStacks.isEmpty() || !updatedContainers.isEmpty()) {
                var packet = SyncContainerData.of(entity, updatedContainers.keySet(), dirtyStacks, dirtyCosmeticStacks);

                var networkHandler = AccessoriesInternals.getNetworkHandler();

                networkHandler.sendToTrackingAndSelf(entity, packet);
            }

            updatedContainers.clear();
        }

        //--

        var holder = ((AccessoriesHolderImpl) AccessoriesInternals.getHolder(entity));

        if(holder.loadedFromTag && capability == null) {
            var tempCapability = new AccessoriesCapabilityImpl(entity);
        }

        var invalidStacks = (holder).invalidStacks;

        if (!invalidStacks.isEmpty()) {
            for (class_1799 invalidStack : invalidStacks) {
                if (entity instanceof class_3222 serverPlayer) {
                    AccessoriesInternals.giveItemToPlayer(serverPlayer, invalidStack);
                } else {
                    entity.method_5775(invalidStack);
                }
            }

            invalidStacks.clear();
        }
    }

    private static void recursiveStackChange(SlotReference slotReference, @Nullable AccessoryNestContainerContents lastNestData, @Nullable AccessoryNestContainerContents currentNestData) {
        var lastInnerStacks = lastNestData != null ? List.copyOf(lastNestData.getMap(slotReference).entrySet()) : List.<Map.Entry<SlotEntryReference, Accessory>>of();
        var currentInnerStacks = currentNestData != null ? List.copyOf(currentNestData.getMap(slotReference).entrySet()) : List.<Map.Entry<SlotEntryReference, Accessory>>of();

        var maxIterationLength = Math.max(lastInnerStacks.size(), currentInnerStacks.size());

        for (int i = 0; i < maxIterationLength; i++) {
            var lastInnerEntry = (i < lastInnerStacks.size()) ? lastInnerStacks.get(i) : null;
            var currentInnerEntry = (i < currentInnerStacks.size()) ? currentInnerStacks.get(i) : null;

            if(lastInnerEntry == null && currentInnerEntry != null) {
                var currentRef = currentInnerEntry.getKey();

                AccessoryChangeCallback.EVENT.invoker().onChange(class_1799.field_8037, currentRef.stack(), currentRef.reference(), SlotStateChange.REPLACEMENT);
            } else if(currentInnerEntry == null && lastInnerEntry != null) {
                var lastRef = lastInnerEntry.getKey();

                AccessoryChangeCallback.EVENT.invoker().onChange(lastRef.stack(), class_1799.field_8037, lastRef.reference(), SlotStateChange.REPLACEMENT);
            } else if(lastInnerEntry != null && currentInnerEntry != null) {
                var currentRef = currentInnerEntry.getKey();
                var lastRef = lastInnerEntry.getKey();

                var innerRef = lastRef.reference();

                var currentInnerStack = currentRef.stack();
                var lastInnerStack = lastRef.stack();

                AccessoryChangeCallback.EVENT.invoker().onChange(lastInnerStack, currentInnerStack, innerRef, SlotStateChange.REPLACEMENT);

                recursiveStackChange(slotReference, AccessoryNestUtils.getData(lastInnerStack), AccessoryNestUtils.getData(currentInnerStack));
            }
        }
    }

    public static void getTooltipData(@Nullable class_1309 entity, class_1799 stack, List<class_2561> tooltip, class_1836 tooltipType) {
        var accessory = AccessoriesAPI.getOrDefaultAccessory(stack);

        if (accessory != null) {
            if(entity != null && AccessoriesCapability.get(entity) != null) addEntityBasedTooltipData(entity, accessory, stack, tooltip, tooltipType);

            accessory.getExtraTooltip(stack, tooltip, tooltipType);
        }
    }

    // TODO: Rewrite for better handling of various odd cases
    private static void addEntityBasedTooltipData(class_1309 entity, Accessory accessory, class_1799 stack, List<class_2561> tooltip, class_1836 tooltipType) {
        // TODO: MAYBE DEPENDING ON ENTITY OR SOMETHING SHOW ALL VALID SLOTS BUT COLOR CODE THEM IF NOT VALID FOR ENTITY?
        // TODO: ADD BETTER HANDLING FOR POSSIBLE SLOTS THAT ARE EQUIPABLE IN BUT IS AT ZERO SIZE
        var validSlotTypes = new HashSet<>(AccessoriesAPI.getValidSlotTypes(entity, stack));

        var validUniqueSlots = validSlotTypes.stream()
                .filter(slotType -> UniqueSlotHandling.isUniqueSlot(slotType.name()))
                .collect(Collectors.toSet());

        if (validSlotTypes.isEmpty()) return;

        validSlotTypes.removeAll(validUniqueSlots);

        var sharedSlotTypes = SlotTypeLoader.getSlotTypes(entity.method_37908()).values()
                .stream()
                .filter(slotType -> /*slotType.amount() > 0 &&*/ !UniqueSlotHandling.isUniqueSlot(slotType.name()))
                .collect(Collectors.toSet());

        var slotInfoComponent = class_2561.method_43470("");

        var slotsComponent = class_2561.method_43470("");
        boolean allSlots = false;


        if (validSlotTypes.containsAll(sharedSlotTypes)) {
            slotsComponent.method_10852(class_2561.method_43471(Accessories.translation("slot.any")));
            allSlots = true;
        } else {
            var entitySlotTypes = Set.copyOf(EntitySlotLoader.getEntitySlots(entity).values());

            var differenceSlotTypes = Sets.difference(entitySlotTypes, validSlotTypes);

            if(differenceSlotTypes.size() < validSlotTypes.size()) {
                slotsComponent.method_10852(class_2561.method_43471(Accessories.translation("slot.any")));
                slotsComponent.method_10852(class_2561.method_43470(" except ").method_27692(class_124.field_1080));

                var slotTypesList = List.copyOf(differenceSlotTypes);

                for (int i = 0; i < slotTypesList.size(); i++) {
                    var type = slotTypesList.get(i);

                    slotsComponent.method_10852(class_2561.method_43471(type.translation()).method_27692(class_124.field_1061));

                    if (i + 1 != slotTypesList.size()) {
                        slotsComponent.method_10852(class_2561.method_43470(", ").method_27692(class_124.field_1080));
                    }
                }
            } else {
                var slotTypesList = List.copyOf(validSlotTypes);

                for (int i = 0; i < slotTypesList.size(); i++) {
                    var type = slotTypesList.get(i);

                    slotsComponent.method_10852(class_2561.method_43471(type.translation()));

                    if (i + 1 != slotTypesList.size()) {
                        slotsComponent.method_10852(class_2561.method_43470(", ").method_27692(class_124.field_1080));
                    }
                }
            }
        }

        if(!validUniqueSlots.isEmpty()) {
            var uniqueSlotTypes = List.copyOf(validUniqueSlots);

            for (int i = 0; i < uniqueSlotTypes.size(); i++) {
                var type = uniqueSlotTypes.get(i);

                slotsComponent.method_10852(class_2561.method_43471(type.translation()));

                if (i + 1 != uniqueSlotTypes.size()) {
                    slotsComponent.method_10852(class_2561.method_43470(", ").method_27692(class_124.field_1080));
                }
            }

            validSlotTypes.addAll(validUniqueSlots);
        }

        var slotTranslationKey = "slot.tooltip." + ((validSlotTypes.size() > 1 && !allSlots) ? "plural" : "singular");

        slotInfoComponent.method_10852(
                class_2561.method_43471(Accessories.translation(slotTranslationKey))
                        .method_27692(class_124.field_1080)
                        .method_10852(slotsComponent.method_27692(class_124.field_1078))
        );

        tooltip.add(slotInfoComponent);

        var slotSpecificModifiers = new HashMap<SlotType, AccessoryAttributeBuilder>();
        AccessoryAttributeBuilder defaultModifiers = null;

        boolean allDuplicates = true;

        for (var slotType : validSlotTypes) {
            var reference = SlotReference.of(entity, slotType.name(), 0);

            var builder = AccessoriesAPI.getAttributeModifiers(stack, reference, true);

            slotSpecificModifiers.put(slotType, builder);

            if (defaultModifiers == null) {
                defaultModifiers = builder;
            } else if (allDuplicates) {
                // TODO: ! WARNING ! THIS MAY NOT WORK?
                allDuplicates = defaultModifiers.equals(builder);
            }
        }

        var slotTypeToTooltipInfo = new HashMap<SlotType, List<class_2561>>();

        if (allDuplicates) {
            if (!defaultModifiers.isEmpty()) {
                var attributeTooltip = new ArrayList<class_2561>();

                addAttributeTooltip(defaultModifiers.getAttributeModifiers(false), attributeTooltip);

                slotTypeToTooltipInfo.put(null, attributeTooltip);
            }
        } else {
            for (var slotModifiers : slotSpecificModifiers.entrySet()) {
                var slotType = slotModifiers.getKey();
                var modifiers = slotModifiers.getValue();

                if (modifiers.isEmpty()) continue;

                var attributeTooltip = new ArrayList<class_2561>();

                addAttributeTooltip(modifiers.getAttributeModifiers(false), attributeTooltip);

                slotTypeToTooltipInfo.put(slotType, attributeTooltip);
            }
        }

        var extraAttributeTooltips = new HashMap<SlotType, List<class_2561>>();
        List<class_2561> defaultExtraAttributeTooltip = null;

        boolean allDuplicatesExtras = true;

        for (var slotType : validSlotTypes) {
            var extraAttributeTooltip = new ArrayList<class_2561>();
            accessory.getAttributesTooltip(stack, slotType, extraAttributeTooltip, tooltipType);

            extraAttributeTooltips.put(slotType, extraAttributeTooltip);

            if (defaultExtraAttributeTooltip == null) {
                defaultExtraAttributeTooltip = extraAttributeTooltip;
            } else if (allDuplicatesExtras) {
                allDuplicatesExtras = extraAttributeTooltip.equals(defaultExtraAttributeTooltip);
            }
        }

        if (allDuplicatesExtras) {
            slotTypeToTooltipInfo.computeIfAbsent(null, s -> new ArrayList<>())
                    .addAll(defaultExtraAttributeTooltip);
        } else {
            extraAttributeTooltips.forEach((slotType, components) -> {
                slotTypeToTooltipInfo.computeIfAbsent(slotType, s -> new ArrayList<>())
                        .addAll(components);
            });
        }

        if(slotTypeToTooltipInfo.containsKey(null)) {
            var anyTooltipInfo = slotTypeToTooltipInfo.get(null);

            if (anyTooltipInfo.size() > 0) {
                tooltip.add(class_5244.field_39003);

                tooltip.add(
                        class_2561.method_43471(Accessories.translation("tooltip.attributes.any"))
                                .method_27692(class_124.field_1080)
                );

                tooltip.addAll(anyTooltipInfo);
            }

            slotTypeToTooltipInfo.remove(null);
        }

        if(!slotTypeToTooltipInfo.isEmpty()) {
            for (var entry : slotTypeToTooltipInfo.entrySet()) {
                var tooltipData = entry.getValue();

                if(tooltipData.size() == 0) continue;

                tooltip.add(class_5244.field_39003);

                tooltip.add(
                        class_2561.method_43469(
                                Accessories.translation("tooltip.attributes.slot"),
                                class_2561.method_43471(entry.getKey().translation()).method_27692(class_124.field_1078)
                        ).method_27692(class_124.field_1080)
                );

                tooltip.addAll(entry.getValue());
            }
        }
    }

    private static void addAttributeTooltip(Multimap<class_1320, class_1322> multimap, List<class_2561> tooltip) {
        if (multimap.isEmpty()) return;

        for (Map.Entry<class_1320, class_1322> entry : multimap.entries()) {
            class_1322 attributeModifier = entry.getValue();
            double d = attributeModifier.method_6186();

            if (attributeModifier.method_6182() == class_1322.class_1323.field_6330
                    || attributeModifier.method_6182() == class_1322.class_1323.field_6331) {
                d *= 100.0;
            } else if (entry.getKey().equals(class_5134.field_23718)) {
                d *= 10.0;
            }

            var key = entry.getKey();

            if (d > 0.0) {
                tooltip.add(
                        class_2561.method_43469(
                                        "attribute.modifier.plus." + attributeModifier.method_6182().method_6191(),
                                        class_1799.field_8029.format(d),
                                        class_2561.method_43471(key.method_26830())
                                )
                                .method_27692(class_124.field_1078)
                );
            } else if (d < 0.0) {
                d *= -1.0;
                tooltip.add(
                        class_2561.method_43469(
                                        "attribute.modifier.take." + attributeModifier.method_6182().method_6191(),
                                        class_1799.field_8029.format(d),
                                        class_2561.method_43471(key.method_26830())
                                )
                                .method_27692(class_124.field_1061)
                );
            }
        }
    }

    public static List<class_1799> onDeath(class_1309 entity, class_1282 source) {
        var capability = AccessoriesCapability.get(entity);

        var droppedStacks = new ArrayList<class_1799>();

        var gamerules = entity.method_37908().method_8450();

        var keepInv = gamerules.method_20746(class_1928.field_19389).method_20753() || gamerules.method_20746(Accessories.RULE_KEEP_ACCESSORY_INVENTORY).method_20753();

        if (capability != null) {
            for (var containerEntry : capability.getContainers().entrySet()) {
                var slotType = containerEntry.getValue().slotType();

                var slotDropRule = slotType != null ? slotType.dropRule() : DropRule.DEFAULT;

                var container = containerEntry.getValue();

                var stacks = container.getAccessories();
                var cosmeticStacks = container.getCosmeticAccessories();

                for (int i = 0; i < container.getSize(); i++) {
                    var reference = SlotReference.of(entity, container.getSlotName(), i);

                    var stack = dropStack(slotDropRule, entity, stacks, reference, source, keepInv);
                    if (stack != null) droppedStacks.add(stack);

                    var cosmeticStack = dropStack(slotDropRule, entity, cosmeticStacks, reference, source, keepInv);
                    if (cosmeticStack != null) droppedStacks.add(cosmeticStack);
                }
            }

            var result = OnDeathCallback.EVENT.invoker().shouldDrop(TriState.DEFAULT, entity, capability, source, droppedStacks);

            if (!result.orElse(true)) return List.of();
        }

        return droppedStacks;
    }

    @Nullable
    private static class_1799 dropStack(DropRule dropRule, class_1309 entity, ExpandedSimpleContainer container, SlotReference reference, class_1282 source, boolean keepInvEnabled) {
        var stack = container.method_5438(reference.slot());
        var accessory = AccessoriesAPI.getAccessory(stack);

        if (accessory != null && dropRule == DropRule.DEFAULT) {
            dropRule = accessory.getDropRule(stack, reference, source);
        }

        if (accessory instanceof AccessoryNest holdable) {
            var dropRuleToStacks = holdable.getDropRules(stack, reference, source);

            for (int i = 0; i < dropRuleToStacks.size(); i++) {
                var rulePair = dropRuleToStacks.get(i);

                var innerStack = rulePair.right();

                var result = OnDropCallback.getAlternativeRule(rulePair.left(), innerStack, reference, source);

                var breakInnerStack = (result == DropRule.DEFAULT && class_1890.method_8221(innerStack))
                        || (result == DropRule.DESTROY);

                if (breakInnerStack) {
                    holdable.setInnerStack(stack, i, class_1799.field_8037);
                    // TODO: Do we call break here for the accessory?

                    container.method_5447(reference.slot(), stack);
                }
            }
        }

        var result = OnDropCallback.getAlternativeRule(dropRule, stack, reference, source);

        boolean dropStack = true;

        if (result == DropRule.DESTROY) {
            container.method_5447(reference.slot(), class_1799.field_8037);
            dropStack = false;
            // TODO: Do we call break here for the accessory?
        } else if (result == DropRule.KEEP) {
            dropStack = false;
        } else if (result == DropRule.DEFAULT) {
            if (keepInvEnabled) {
                dropStack = false;
            } else if (class_1890.method_8221(stack)) {
                container.method_5447(reference.slot(), class_1799.field_8037);
                dropStack = false;
                // TODO: Do we call break here for the accessory?
            }
        }

        container.setPreviousItem(reference.slot(), class_1799.field_8037);

        if (!dropStack) return null;

        container.method_5447(reference.slot(), class_1799.field_8037);

        return stack;
    }

    public static class_1271<class_1799> attemptEquipFromUse(class_1657 player, class_1268 hand) {
        var stack = player.method_5998(hand);

        var capability = AccessoriesCapability.get(player);

        if(capability != null && !player.method_7325() && !stack.method_7960()) {
            var equipControl = capability.getHolder().equipControl();

            var shouldAttemptEquip = false;

            if(equipControl == PlayerEquipControl.MUST_CROUCH && player.method_5715()) {
                shouldAttemptEquip = true;
            } else if(equipControl == PlayerEquipControl.MUST_NOT_CROUCH && !player.method_5715()) {
                shouldAttemptEquip = true;
            }

            if (shouldAttemptEquip) {
                var accessory = AccessoriesAPI.getOrDefaultAccessory(stack);

                var equipReference = capability.canEquipAccessory(stack, true);

                if (equipReference != null && accessory.canEquipFromUse(stack)) {
                    accessory.onEquipFromUse(stack, equipReference.left());

                    var newHandStack = stack.method_7972();

                    var possibleSwappedStack = equipReference.second().equipStack(newHandStack);

                    if(possibleSwappedStack.isPresent()) {
                        var swappedStack = possibleSwappedStack.get();

                        if (newHandStack.method_7960()) {
                            newHandStack = swappedStack;
                        } else if(class_1799.method_31577(newHandStack, swappedStack) && (newHandStack.method_7947() + swappedStack.method_7947()) <= newHandStack.method_7914()) {
                            newHandStack.method_7933(swappedStack.method_7947());
                        } else {
                            player.method_7270(swappedStack);
                        }
                    }

                    return class_1271.method_22427(newHandStack);
                }
            }
        }

        return class_1271.method_22430(stack);
    }

    public static final class_6862<class_1299<?>> EQUIPMENT_MANAGEABLE = class_6862.method_40092(class_7924.field_41266, Accessories.of("equipment_manageable"));

    public static class_1269 attemptEquipOnEntity(class_1657 player, class_1268 hand, class_1297 entity) {
        var stack = player.method_5998(hand);

        if(!(entity instanceof class_1309 targetEntity) || !entity.method_5864().method_20210(EQUIPMENT_MANAGEABLE)) return class_1269.field_5811;

        var targetCapability = AccessoriesCapability.get(targetEntity);

        var canModify = AllowEntityModificationCallback.EVENT.invoker().allowModifications(targetEntity, player, null).orElse(false);

        if (canModify && targetCapability != null && !player.method_7325()) {
            if (player.method_5715()) {
                var accessory = AccessoriesAPI.getOrDefaultAccessory(stack);

                var equipReference = targetCapability.canEquipAccessory(stack, true);

                if (equipReference != null && accessory.canEquipFromUse(stack)) {
                    if(!stack.method_7960()) accessory.onEquipFromUse(stack, equipReference.left());

                    var newHandStack = stack.method_7972();

                    var possibleSwappedStack = equipReference.second().equipStack(newHandStack);

                    if(possibleSwappedStack.isPresent()) {
                        var swappedStack = possibleSwappedStack.get();

                        if (newHandStack.method_7960()) {
                            newHandStack = swappedStack;
                        } else if(class_1799.method_31577(newHandStack, swappedStack) && (newHandStack.method_7947() + swappedStack.method_7947()) <= newHandStack.method_7914()) {
                            newHandStack.method_7933(swappedStack.method_7947());
                        } else {
                            player.method_7270(swappedStack);
                        }
                    }

                    player.method_6122(hand, newHandStack);

                    return class_1269.field_5812;
                }
            }
        }

        return class_1269.field_5811;
    }

//    public static void setupItems(AddDataComponentCallback callback) {
//        AccessoriesAPI.getAllAccessories().forEach((item, accessory) -> {
//            var builder = AccessoryItemAttributeModifiers.builder();
//
//            accessory.getStaticModifiers(item, builder);
//
//            if(!builder.isEmpty()) {
//                callback.addTo(item, AccessoriesDataComponents.ATTRIBUTES, builder.build());
//            }
//        });
//    }

//    public interface AddDataComponentCallback {
//        <T> void addTo(Item item, DataComponentType<T> componentType, T component);
//    }
}
