package io.wispforest.accessories.impl;

import Z;
import com.mojang.datafixers.util.Pair;
import com.mojang.logging.LogUtils;
import io.wispforest.accessories.AccessoriesInternals;
import io.wispforest.accessories.api.AccessoriesCapability;
import it.unimi.dsi.fastutil.ints.Int2BooleanArrayMap;
import it.unimi.dsi.fastutil.ints.Int2BooleanMap;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;

import java.util.ArrayList;
import java.util.Iterator;
import net.minecraft.class_1277;
import net.minecraft.class_1799;
import net.minecraft.class_2371;
import net.minecraft.class_2487;
import net.minecraft.class_2499;

/**
 * An implementation of SimpleContainer with easy utilities for iterating over the stacks
 * and holding on to previous stack info
 */
public class ExpandedSimpleContainer extends class_1277 implements Iterable<Pair<Integer, class_1799>> {

    private static final Logger LOGGER = LogUtils.getLogger();

    private final AccessoriesContainerImpl container;

    private final String name;
    private final class_2371<class_1799> previousItems;
    private final Int2BooleanMap setFlags = new Int2BooleanArrayMap();

    private boolean newlyConstructed;

    public ExpandedSimpleContainer(AccessoriesContainerImpl container, int size, String name) {
        this(container, size, name, true);
    }

    public ExpandedSimpleContainer(AccessoriesContainerImpl container, int size, String name, boolean toggleNewlyConstructed) {
        super(size);

        this.container = container;

        this.method_5489(container);

        if(toggleNewlyConstructed) this.newlyConstructed = true;

        this.name = name;
        this.previousItems = class_2371.method_10213(size, class_1799.field_8037);
    }

    public String name() {
        return this.name;
    }

    //--

    public boolean wasNewlyConstructed() {
        var bl = newlyConstructed;

        this.newlyConstructed = false;

        return bl;
    }

    public boolean isSlotFlagged(int slot){
        var bl = setFlags.getOrDefault(slot, false);

        if(bl) setFlags.put(slot, false);

        return bl;
    }

    public void setPreviousItem(int slot, class_1799 stack) {
        if(!validIndex(slot)) return;
        this.previousItems.set(slot, stack);
        if (!stack.method_7960() && stack.method_7947() > this.method_5444()) {
            stack.method_7939(this.method_5444());
        }
    }

    public class_1799 getPreviousItem(int slot) {
        return slot >= 0 && slot < this.previousItems.size()
                ? this.previousItems.get(slot)
                : class_1799.field_8037;
    }

    //--

    @Override
    public class_1799 method_5438(int slot) {
        if(!validIndex(slot)) return class_1799.field_8037;

        return super.method_5438(slot);
    }

    @Override
    public class_1799 method_5434(int slot, int amount) {
        if(!validIndex(slot)) return class_1799.field_8037;

        var stack = super.method_5434(slot, amount);

        if (!stack.method_7960()) {
            setFlags.put(slot, true);
        }

        return stack;
    }

    @Override
    public class_1799 method_5441(int slot) {
        if(!validIndex(slot)) return class_1799.field_8037;

        // TODO: Concerning the flagging system, should this work for it?

        return super.method_5441(slot);
    }

    @Override
    public void method_5447(int slot, class_1799 stack) {
        if(!validIndex(slot)) return;

        super.method_5447(slot, stack);

        setFlags.put(slot, true);
    }

    // Simple validation method to make sure that the given access is valid before attempting an operation
    public boolean validIndex(int slot){
        var isValid = slot >= 0 && slot < this.method_5439();

        var nameInfo = (this.name != null ? "Container: " + this.name + ", " : "");

        if(!isValid && AccessoriesInternals.isDevelopmentEnv()){
            try {
                throw new IllegalStateException("Access to a given Inventory was found to be out of the range valid for the container! [Name: " + nameInfo + " Index: " + slot + "]");
            } catch (Exception e) {
                LOGGER.debug("Full Exception: ", e);
            }
        }

        return isValid;
    }

    //--

    @Override
    public void method_7659(class_2499 containerNbt) {
        this.container.containerListenerLock = true;

        var capability = this.container.capability;

        var prevStacks = new ArrayList<class_1799>();

        for(int i = 0; i < this.method_5439(); ++i) {
            var currentStack = this.method_5438(i);

            prevStacks.add(currentStack);

            this.method_5447(i, class_1799.field_8037);
        }

        var invalidStacks = new ArrayList<class_1799>();
        var decodedStacks = new ArrayList<class_1799>();

        for(int i = 0; i < containerNbt.size(); ++i) {
            var compoundTag = containerNbt.method_10602(i);

            int j = compoundTag.method_10550("Slot");

            var stack = class_1799.method_7915(compoundTag);

            decodedStacks.add(stack);

            if (j >= 0 && j < this.method_5439()) {
                this.method_5447(j, stack);
            } else {
                invalidStacks.add(stack);
            }
        }

        this.container.containerListenerLock = false;

        if (!capability.entity().method_37908().method_8608()) {
            if (!prevStacks.equals(decodedStacks)) {
                this.method_5431();
            }

            ((AccessoriesHolderImpl) capability.getHolder()).invalidStacks.addAll(invalidStacks);
        }
    }

    @Override
    public class_2499 method_7660() {
        class_2499 listTag = new class_2499();

        for(int i = 0; i < this.method_5439(); ++i) {
            class_1799 itemStack = this.method_5438(i);

            if (!itemStack.method_7960()) {
                var compoundTag = new class_2487();

                compoundTag.method_10569("Slot", i);

                listTag.add(itemStack.method_7953(compoundTag));
            }
        }

        return listTag;
    }

    //--

    @NotNull
    @Override
    public Iterator<Pair<Integer, class_1799>> iterator() {
        return new Iterator<>() {
            private int index = 0;

            @Override
            public boolean hasNext() {
                return index < ExpandedSimpleContainer.this.method_5439();
            }

            @Override
            public Pair<Integer, class_1799> next() {
                var pair = new Pair<>(index, ExpandedSimpleContainer.this.method_5438(index));

                index++;

                return pair;
            }
        };
    }

    public void setFromPrev(ExpandedSimpleContainer prevContainer) {
        prevContainer.forEach(pair -> this.setPreviousItem(pair.getFirst(), pair.getSecond()));
    }

    public void copyPrev(ExpandedSimpleContainer prevContainer) {
        for (int i = 0; i < prevContainer.method_5439(); i++) {
            if(i >= this.method_5439()) continue;

            var prevItem = prevContainer.getPreviousItem(i);

            if(!prevItem.method_7960()) this.setPreviousItem(i, prevItem);
        }
    }
}
