package io.wispforest.accessories.mixin;

import Z;
import io.wispforest.accessories.api.AccessoriesCapability;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

import java.util.function.Predicate;
import net.minecraft.class_1263;
import net.minecraft.class_1661;
import net.minecraft.class_1799;

@Mixin(class_1263.class)
public interface ContainerMixin {

    @Inject(method = "hasAnyMatching", at = @At("TAIL"))
    private void extendHasAnyMatching(Predicate<class_1799> predicate, CallbackInfoReturnable<Boolean> cir) {
        if (!(this instanceof class_1661 inventory)) return;

        var capability = AccessoriesCapability.get(inventory.field_7546);

        if (capability == null) return;

        var bl = capability.isEquipped(predicate);

        if (bl) cir.setReturnValue(true);
    }
}
